/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl;

import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.util.ListCloneUtils;
import com.tydic.commodity.util.MoneyUtils;
import com.tydic.commodity.validate.ValidatorUtil;
import com.tydic.uccext.bo.CategoryRecommendCommodityBO;
import com.tydic.uccext.bo.UccCommoCategoryRecommendReqBO;
import com.tydic.uccext.bo.UccCommoCategoryRecommendRspBO;
import com.tydic.uccext.dao.UccCommoRecommendMapper;
import com.tydic.uccext.dao.UccCommoRecommendTitleMapper;
import com.tydic.uccext.dao.po.UccCommoRecommendPO;
import com.tydic.uccext.dao.po.UccCommoRecommendTitlePO;
import com.tydic.uccext.service.UccCommoCategoryRecommendBusiService;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccCommoCategoryRecommendBusiService"})
public class UccCommoCategoryRecommendBusiServiceImpl
implements UccCommoCategoryRecommendBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCommoCategoryRecommendBusiServiceImpl.class);
    @Autowired
    private UccCommoRecommendTitleMapper commoRecommendTitleMapper;
    @Autowired
    private UccCommoRecommendMapper recommendMapper;

    @PostMapping(value={"qryCategoryRecommend"})
    public UccCommoCategoryRecommendRspBO qryCategoryRecommend(@RequestBody UccCommoCategoryRecommendReqBO reqBO) {
        UccCommoCategoryRecommendRspBO rspBO = new UccCommoCategoryRecommendRspBO();
        try {
            ValidatorUtil.validator((Object)reqBO);
        }
        catch (BusinessException e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.getMsgInfo());
            return rspBO;
        }
        if (reqBO.getOrgIdIn() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("orgIdIn\u83b7\u53d6\u5931\u8d25");
            return rspBO;
        }
        UccCommoRecommendTitlePO po = new UccCommoRecommendTitlePO();
        po.setTitleSource(reqBO.getTitleSource());
        po.setSupplierId(reqBO.getOrgIdIn());
        List<UccCommoRecommendTitlePO> uccCommoRecommendTitlePOs = this.commoRecommendTitleMapper.queryRecommendTitle(po);
        if (CollectionUtils.isEmpty(uccCommoRecommendTitlePOs)) {
            LOGGER.error("\u7c7b\u76ee\u5546\u54c1\u63a8\u8350\u67e5\u8be2\uff0c\u63a8\u9001\u6807\u9898\u4e3a\u7a7a");
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u7c7b\u76ee\u5546\u54c1\u63a8\u8350\u67e5\u8be2\uff0c\u63a8\u9001\u6807\u9898\u4e3a\u7a7a");
            return rspBO;
        }
        UccCommoRecommendPO uccCommoRecommendPO = null;
        for (UccCommoRecommendTitlePO uccCommoRecommendTitlePO : uccCommoRecommendTitlePOs) {
            uccCommoRecommendPO = new UccCommoRecommendPO();
            uccCommoRecommendPO.setColumnCode(uccCommoRecommendTitlePO.getId().toString());
            uccCommoRecommendPO.setCategoryId(reqBO.getCategoryId());
            uccCommoRecommendPO.setSupplierId(uccCommoRecommendTitlePO.getSupplierId());
        }
        List<UccCommoRecommendPO> commoRecommendPOS = this.recommendMapper.queryCategoryRecommend(uccCommoRecommendPO);
        try {
            List categoryRecommendCommodityBOS = ListCloneUtils.clonePOListToBOList(commoRecommendPOS, CategoryRecommendCommodityBO.class);
            for (CategoryRecommendCommodityBO categoryRecommendCommodityBO : categoryRecommendCommodityBOS) {
                if (null == categoryRecommendCommodityBO.getPrice()) continue;
                categoryRecommendCommodityBO.setPrice(MoneyUtils.haoToYuan((BigDecimal)categoryRecommendCommodityBO.getPrice()));
            }
            rspBO.setCategoryRecommendCommodityBO(categoryRecommendCommodityBOS);
        }
        catch (Exception e) {
            LOGGER.error("\u7c7b\u76ee\u5546\u54c1\u63a8\u8350\u67e5\u8be2\uff0c\u6570\u636e\u8f6c\u6362\u5f02\u5e38");
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6570\u636e\u67e5\u8be2\u5f02\u5e38");
            return rspBO;
        }
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }
}

