/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl;

import com.google.common.collect.Lists;
import com.tydic.commodity.bo.busi.UccCommodityDownReqBO;
import com.tydic.commodity.bo.busi.UccCommodityDownRspBO;
import com.tydic.commodity.busi.api.UccCommodityDownBusiService;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.uccext.bo.ShelvesDetailBO;
import com.tydic.uccext.bo.UccCommodityBatchDownShelvesReqBO;
import com.tydic.uccext.bo.UccCommodityBatchDownShelvesRspBO;
import com.tydic.uccext.dao.UccCommoRecommendMapper;
import com.tydic.uccext.dao.po.UccCommoRecommendPO;
import com.tydic.uccext.service.UccCommodityBatchDownShelvesBusiService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccCommodityBatchDownShelvesBusiService"})
public class UccCommodityBatchDownShelvesBusiServiceImpl
implements UccCommodityBatchDownShelvesBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCommodityBatchDownShelvesBusiServiceImpl.class);
    @Autowired
    private UccCommodityDownBusiService uccCommodityDownBusiService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccCommoRecommendMapper commoRecommendMapper;
    private static final String SUCCESS_COUNT = "SUCCESS_COUNT";
    private static final String ERROR_COUNT = "ERROR_COUNT";

    @PostMapping(value={"batchDownShelves"})
    public UccCommodityBatchDownShelvesRspBO batchDownShelves(@RequestBody UccCommodityBatchDownShelvesReqBO reqBO) {
        UccCommodityBatchDownShelvesRspBO rspBO = new UccCommodityBatchDownShelvesRspBO();
        HashMap<String, MutableInteger> countMap = new HashMap<String, MutableInteger>();
        ArrayList shelvesDetailBOS = Lists.newArrayList();
        try {
            for (Long commodityId : reqBO.getCommodityId()) {
                ShelvesDetailBO shelvesDetailBO = new ShelvesDetailBO();
                MutableInteger initValue = new MutableInteger(1);
                UccCommoRecommendPO uccCommoRecommendPO = new UccCommoRecommendPO();
                uccCommoRecommendPO.setCommodityId(commodityId);
                uccCommoRecommendPO.setSupplierId(reqBO.getOrgIdIn());
                List<UccCommoRecommendPO> uccCommoRecommendPOS = this.commoRecommendMapper.queryCommoRecommendID(uccCommoRecommendPO);
                if (CollectionUtils.isNotEmpty(uccCommoRecommendPOS)) {
                    shelvesDetailBO.setCommodityId(commodityId);
                    shelvesDetailBO.setDownType(Boolean.valueOf(false));
                    shelvesDetailBO.setReason("\u5546\u54c1\u5904\u4e8e\u5e7f\u544a\u4f4d\u9500\u552e\u4e2d");
                    shelvesDetailBOS.add(shelvesDetailBO);
                    MutableInteger oldValue = countMap.put(ERROR_COUNT, initValue);
                    if (oldValue == null) continue;
                    initValue.set(oldValue.get() + 1);
                    continue;
                }
                UccSkuPo uccSkuPo = new UccSkuPo();
                uccSkuPo.setCommodityId(commodityId);
                List uccSkuPoList = this.uccSkuMapper.qerySku(uccSkuPo);
                if (CollectionUtils.isEmpty((Collection)uccSkuPoList)) {
                    LOGGER.error("linkmall \u5546\u54c1\u4e0b\u67b6\u5931\u8d25\uff0c\u5355\u54c1\u4e0d\u5b58\u5728\uff0ccommodityId:" + commodityId);
                    shelvesDetailBO.setCommodityId(commodityId);
                    shelvesDetailBO.setDownType(Boolean.valueOf(false));
                    shelvesDetailBO.setReason("\u5546\u54c1\u4e0b\u67b6\u5931\u8d25\uff0c\u5355\u54c1\u4e0d\u5b58\u5728");
                    shelvesDetailBOS.add(shelvesDetailBO);
                    MutableInteger oldValue = countMap.put(ERROR_COUNT, initValue);
                    if (oldValue == null) continue;
                    initValue.set(oldValue.get() + 1);
                    continue;
                }
                List skuIdList = uccSkuPoList.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
                UccCommodityDownReqBO uccCommodityDownReqBO = new UccCommodityDownReqBO();
                uccCommodityDownReqBO.setDownType(Integer.valueOf(1));
                uccCommodityDownReqBO.setSupplierShopId(((UccSkuPo)uccSkuPoList.get(0)).getSupplierShopId());
                uccCommodityDownReqBO.setSkuIds(skuIdList);
                uccCommodityDownReqBO.setReason(reqBO.getReason());
                UccCommodityDownRspBO uccCommodityDownRspBO = this.uccCommodityDownBusiService.dealCommodityDown(uccCommodityDownReqBO);
                if ("8888".equals(uccCommodityDownRspBO.getRespCode())) {
                    LOGGER.error("linkmall\u4e0b\u67b6\u5931\u8d25\uff0cskuIds:" + skuIdList.toString() + "\u539f\u56e0\uff1a" + uccCommodityDownRspBO.getRespDesc());
                    shelvesDetailBO.setCommodityId(commodityId);
                    shelvesDetailBO.setDownType(Boolean.valueOf(false));
                    shelvesDetailBO.setReason(uccCommodityDownRspBO.getRespDesc());
                    shelvesDetailBOS.add(shelvesDetailBO);
                    MutableInteger oldValue = countMap.put(ERROR_COUNT, initValue);
                    if (oldValue == null) continue;
                    initValue.set(oldValue.get() + 1);
                    continue;
                }
                UccCommodityPo uccCommodityPo = new UccCommodityPo();
                uccCommodityPo.setRemark(reqBO.getReason());
                uccCommodityPo.setCommodityId(commodityId);
                uccCommodityPo.setSupplierShopId(((UccSkuPo)uccSkuPoList.get(0)).getSupplierShopId());
                try {
                    this.uccCommodityMapper.updateCommodity(uccCommodityPo);
                }
                catch (Exception e) {
                    LOGGER.error("linkmall\u4e0b\u67b6\u5931\u8d25\uff0c\u4fee\u6539\u5546\u54c1\u4e0b\u67b6\u539f\u56e0\u5931\u8d25" + e);
                    shelvesDetailBO.setCommodityId(commodityId);
                    shelvesDetailBO.setDownType(Boolean.valueOf(false));
                    shelvesDetailBO.setReason("\u4fee\u6539\u5546\u54c1\u4e0b\u67b6\u539f\u56e0\u5931\u8d25");
                    shelvesDetailBOS.add(shelvesDetailBO);
                    MutableInteger oldValue = countMap.put(ERROR_COUNT, initValue);
                    if (oldValue == null) continue;
                    initValue.set(oldValue.get() + 1);
                    continue;
                }
                MutableInteger oldValue = countMap.put(SUCCESS_COUNT, initValue);
                if (oldValue != null) {
                    initValue.set(oldValue.get() + 1);
                }
                shelvesDetailBO.setCommodityId(commodityId);
                shelvesDetailBO.setDownType(Boolean.valueOf(true));
                shelvesDetailBOS.add(shelvesDetailBO);
            }
        }
        catch (Exception e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5931\u8d25");
            return rspBO;
        }
        rspBO.setFail(Integer.valueOf(countMap.get(ERROR_COUNT) == null ? 0 : ((MutableInteger)countMap.get(ERROR_COUNT)).get()));
        rspBO.setSuccess(Integer.valueOf(countMap.get(SUCCESS_COUNT) == null ? 0 : ((MutableInteger)countMap.get(SUCCESS_COUNT)).get()));
        int errorCount = countMap.get(ERROR_COUNT) == null ? 0 : ((MutableInteger)countMap.get(ERROR_COUNT)).get();
        int successCount = countMap.get(SUCCESS_COUNT) == null ? 0 : ((MutableInteger)countMap.get(SUCCESS_COUNT)).get();
        rspBO.setTotal(Integer.valueOf(errorCount + successCount));
        rspBO.setDownResult((List)shelvesDetailBOS);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private static final class MutableInteger {
        private int val;

        public MutableInteger(int val) {
            this.val = val;
        }

        public int get() {
            return this.val;
        }

        public void set(int val) {
            this.val = val;
        }

        public String toString() {
            return Integer.toString(this.val);
        }
    }
}

