/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.atom.UccCreateUserOperRecordAtomService;
import com.tydic.commodity.atom.bo.UccCreateUserOperRecordAtomReqBO;
import com.tydic.commodity.atom.bo.UccUserOperInfoCreateBO;
import com.tydic.commodity.dao.UccCommodityDetailMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityPicMapper;
import com.tydic.commodity.dao.UccSkuDetailMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.UccCommodityDetailPo;
import com.tydic.commodity.dao.po.UccCommodityPicPo;
import com.tydic.commodity.dao.po.UccSkuDetailPO;
import com.tydic.commodity.enumType.SkuOperTypeEnum;
import com.tydic.commodity.util.ListUtils;
import com.tydic.uccext.bo.UccCommodityPicSyncBusiReqBO;
import com.tydic.uccext.bo.UccCommodityPicSyncBusiRspBO;
import com.tydic.uccext.bo.UccCommodiytSyncPicBO;
import com.tydic.uccext.constant.UccConstants;
import com.tydic.uccext.dao.UccPicSyncTaskMapper;
import com.tydic.uccext.dao.po.UccPicSyncTaskPO;
import com.tydic.uccext.service.UccCommodityPicSyncBusiService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccCommodityPicSyncBusiServiceImpl
implements UccCommodityPicSyncBusiService {
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityPicMapper uccCommodityPicMapper;
    @Autowired
    private UccCommodityDetailMapper uccCommodityDetailMapper;
    @Autowired
    private UccSkuDetailMapper uccSkuDetailMapper;
    @Autowired
    private UccPicSyncTaskMapper uccPicSyncTaskMapper;
    @Autowired
    private UccCreateUserOperRecordAtomService uccCreateUserOperRecordAtomService;
    private Sequence sequence = Sequence.getInstance();
    private final String prefix = "<img src=\"";
    private final String suffix = "\" alt=\"\" /><br/>";

    public UccCommodityPicSyncBusiRspBO dealCommodityPicSync(UccCommodityPicSyncBusiReqBO reqBo) {
        UccCommodityPicSyncBusiRspBO rspBo = new UccCommodityPicSyncBusiRspBO();
        List<Long> comIds = reqBo.getPicInfo().stream().map(UccCommodiytSyncPicBO::getCommodityId).distinct().collect(Collectors.toList());
        this.updateCommodityPic(reqBo);
        this.updateCommodityDetail(reqBo);
        this.dealOperRecord(comIds, reqBo.getUsername());
        UccPicSyncTaskPO setPo = new UccPicSyncTaskPO();
        setPo.setFinishTime(new Date());
        setPo.setIsFinish(UccConstants.YesOrNo.YES);
        UccPicSyncTaskPO wherePo = new UccPicSyncTaskPO();
        wherePo.setTaskId(reqBo.getTaskId());
        this.uccPicSyncTaskMapper.updateBy(setPo, wherePo);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void updateCommodityPic(UccCommodityPicSyncBusiReqBO reqBo) {
        Map batchList;
        ArrayList list = new ArrayList();
        this.uccCommodityPicMapper.batchDelete(reqBo.getPicInfo().stream().map(UccCommodiytSyncPicBO::getCommodityId).distinct().collect(Collectors.toList()));
        Date now = new Date();
        reqBo.getPicInfo().forEach(picInfo -> {
            if (0 != picInfo.getPicType()) {
                UccCommodityPicPo uccCommodityPicPo = new UccCommodityPicPo();
                uccCommodityPicPo.setCommodityPicId(Long.valueOf(this.sequence.nextId()));
                uccCommodityPicPo.setCommodityId(picInfo.getCommodityId());
                uccCommodityPicPo.setCommodityPicType(picInfo.getPicType());
                uccCommodityPicPo.setCommodityPicUrl(picInfo.getPicUrl());
                uccCommodityPicPo.setCreateOperId(reqBo.getUsername());
                uccCommodityPicPo.setCreateTime(now);
                uccCommodityPicPo.setRemark(picInfo.getRemark());
                uccCommodityPicPo.setSupplierShopId(UccConstants.ATOUR_SUPPLIER_SHOP_ID);
                uccCommodityPicPo.setPicOrder(picInfo.getPicOrder());
                list.add(uccCommodityPicPo);
            }
        });
        if (!CollectionUtils.isEmpty(list) && !CollectionUtils.isEmpty((Map)(batchList = ListUtils.batchList(list, (int)200)))) {
            batchList.forEach((index, poList) -> {
                if (!CollectionUtils.isEmpty((Collection)poList)) {
                    this.uccCommodityPicMapper.batchInsert(poList);
                }
            });
        }
    }

    private void updateCommodityDetail(UccCommodityPicSyncBusiReqBO reqBo) {
        Map batchList;
        ArrayList commodityDetailPoList = new ArrayList();
        ArrayList skuDetailPoList = new ArrayList();
        Map<Long, List<UccCommodiytSyncPicBO>> collect = reqBo.getPicInfo().stream().collect(Collectors.groupingBy(UccCommodiytSyncPicBO::getCommodityId));
        if (!CollectionUtils.isEmpty(collect)) {
            collect.forEach((id, picInfoList) -> {
                List<UccCommodiytSyncPicBO> detailPicList;
                if (!CollectionUtils.isEmpty((Collection)picInfoList) && !CollectionUtils.isEmpty(detailPicList = picInfoList.stream().filter(picInfo -> picInfo.getPicType() == 0).sorted(Comparator.comparing(UccCommodiytSyncPicBO::getPicOrder)).collect(Collectors.toList()))) {
                    detailPicList.forEach(pic -> {
                        UccCommodityDetailPo commodityDetailPo = new UccCommodityDetailPo();
                        commodityDetailPo.setCommodityId(pic.getCommodityId());
                        commodityDetailPo.setCommodityPcDetailChar("<img src=\"" + pic.getPicUrl() + "\" alt=\"\" /><br/>");
                        commodityDetailPoList.add(commodityDetailPo);
                        UccSkuDetailPO skuDetailPo = new UccSkuDetailPO();
                        skuDetailPo.setCommodityId(pic.getCommodityId());
                        skuDetailPo.setSkuId(pic.getCommodityId());
                        skuDetailPo.setSkuPcDetailChar("<img src=\"" + pic.getPicUrl() + "\" alt=\"\" /><br/>");
                        skuDetailPoList.add(skuDetailPo);
                    });
                }
            });
        }
        if (!CollectionUtils.isEmpty(commodityDetailPoList) && !CollectionUtils.isEmpty((Map)(batchList = ListUtils.batchList(commodityDetailPoList, (int)50)))) {
            batchList.forEach((index, poList) -> {
                if (!CollectionUtils.isEmpty((Collection)poList)) {
                    this.uccCommodityDetailMapper.batchUpdate(poList);
                }
            });
        }
        if (!CollectionUtils.isEmpty(skuDetailPoList) && !CollectionUtils.isEmpty((Map)(batchList = ListUtils.batchList(skuDetailPoList, (int)50)))) {
            batchList.forEach((index, poList) -> {
                if (!CollectionUtils.isEmpty((Collection)poList)) {
                    this.uccSkuDetailMapper.batchUpdate(poList);
                }
            });
        }
    }

    private void dealOperRecord(List<Long> comIds, String username) {
        UccCreateUserOperRecordAtomReqBO uccCreateUserOperRecordAtomReqBo = new UccCreateUserOperRecordAtomReqBO();
        ArrayList userOperInfoCreateBoList = new ArrayList();
        comIds.forEach(comId -> {
            UccUserOperInfoCreateBO uccUserOperInfoCreateBo = new UccUserOperInfoCreateBO();
            uccUserOperInfoCreateBo.setCreateOper(username);
            uccUserOperInfoCreateBo.setCreateTime(new Date());
            uccUserOperInfoCreateBo.setOperType(SkuOperTypeEnum.SKU_PIC_SYNC.getOperType());
            uccUserOperInfoCreateBo.setCommodityId(comId);
            uccUserOperInfoCreateBo.setSkuId(comId);
            userOperInfoCreateBoList.add(uccUserOperInfoCreateBo);
        });
        uccCreateUserOperRecordAtomReqBo.setUserOperInfoList(userOperInfoCreateBoList);
        this.uccCreateUserOperRecordAtomService.createUserOperRecord(uccCreateUserOperRecordAtomReqBo);
    }
}

