/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl;

import com.google.common.collect.Lists;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.validate.ValidatorUtil;
import com.tydic.uccext.bo.CommodityRecommendIDListBO;
import com.tydic.uccext.bo.RecommendCategeryCommoIDBO;
import com.tydic.uccext.bo.UccCommodityRecommendIDListUpdateReqBO;
import com.tydic.uccext.bo.UccCommodityRecommendIDListUpdateRspBO;
import com.tydic.uccext.dao.UccCatalogRecommendAddMapper;
import com.tydic.uccext.dao.UccCommoRecommendMapper;
import com.tydic.uccext.dao.UccCommoRecommendTitleMapper;
import com.tydic.uccext.dao.po.UccCatalogRecommendAddPO;
import com.tydic.uccext.dao.po.UccCommoRecommendTitlePO;
import com.tydic.uccext.service.UccCommodityRecommendIdUpdateBusiService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccCommodityRecommendIdUpdateBusiService"})
public class UccCommodityRecommendIdUpdateBusiServiceImpl
implements UccCommodityRecommendIdUpdateBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCommodityRecommendIdUpdateBusiServiceImpl.class);
    @Autowired
    private UccCommoRecommendMapper commoRecommendMapper;
    @Autowired
    private UccCatalogRecommendAddMapper recommendAddMapper;
    @Autowired
    private UccCommoRecommendTitleMapper uccCommoRecommendTitleMapper;

    @PostMapping(value={"updateRecommendIDList"})
    public UccCommodityRecommendIDListUpdateRspBO updateRecommendIDList(@RequestBody UccCommodityRecommendIDListUpdateReqBO reqBO) {
        UccCommodityRecommendIDListUpdateRspBO rspBO = new UccCommodityRecommendIDListUpdateRspBO();
        ArrayList<Long> commodityIds = new ArrayList<Long>();
        List commodityIdList = reqBO.getCommodityRecommendIDListBOS().stream().map(CommodityRecommendIDListBO::getCommodityIds).collect(Collectors.toList());
        for (int i = 0; i < commodityIdList.size(); ++i) {
            List groupId = (List)commodityIdList.get(i);
            Iterator iterator = groupId.iterator();
            while (iterator.hasNext()) {
                RecommendCategeryCommoIDBO recommendCategeryCommoIDBO = (RecommendCategeryCommoIDBO)iterator.next();
                commodityIds.add(recommendCategeryCommoIDBO.getCommodityId());
            }
        }
        List<Long> ids = this.commoRecommendMapper.qryNumByCommdId(commodityIds, reqBO.getOrgIdIn());
        for (Long l : commodityIds) {
            if (ids.contains(l)) continue;
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5546\u54c1" + l + "\u4e0d\u662f\u5f53\u524d\u5546\u6237\u5546\u54c1");
            return rspBO;
        }
        try {
            ArrayList catalogRecommendAddPOS = Lists.newArrayList();
            for (CommodityRecommendIDListBO commodityRecommendIDListBO : reqBO.getCommodityRecommendIDListBOS()) {
                ValidatorUtil.validator((Object)commodityRecommendIDListBO);
                UccCatalogRecommendAddPO uccCommoRecommendPO = new UccCatalogRecommendAddPO();
                uccCommoRecommendPO.setSkuLocation(commodityRecommendIDListBO.getCatId());
                uccCommoRecommendPO.setColumnCode(commodityRecommendIDListBO.getColumnCode());
                uccCommoRecommendPO.setSupplierId(reqBO.getOrgIdIn());
                try {
                    this.commoRecommendMapper.deleteCommodityRecommendIdList(uccCommoRecommendPO);
                }
                catch (BusinessException e) {
                    LOGGER.error("\u5220\u9664\u7c7b\u76ee\u63a8\u8350\u5546\u54c1\u5931\u8d25" + (Object)((Object)e));
                    throw new BusinessException("8888", "\u5220\u9664\u7c7b\u76ee\u63a8\u8350\u5546\u54c1\u5931\u8d25");
                }
                UccCommoRecommendTitlePO commoRecommendTitlePO = new UccCommoRecommendTitlePO();
                commoRecommendTitlePO.setId(Long.valueOf(commodityRecommendIDListBO.getColumnCode()));
                commoRecommendTitlePO.setSupplierId(reqBO.getOrgIdIn());
                for (RecommendCategeryCommoIDBO recommendCategeryCommoIDBO : commodityRecommendIDListBO.getCommodityIds()) {
                    if (null == recommendCategeryCommoIDBO.getCommodityId()) {
                        LOGGER.error("\u7c7b\u76ee\u63a8\u8350\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a,\u7c7b\u76eeid" + commodityRecommendIDListBO.getCatId());
                        throw new BusinessException("8888", "\u7c7b\u76ee\u63a8\u8350\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    uccCommoRecommendPO = new UccCatalogRecommendAddPO();
                    uccCommoRecommendPO.setSkuLocation(commodityRecommendIDListBO.getCatId());
                    uccCommoRecommendPO.setColumnCode(commodityRecommendIDListBO.getColumnCode());
                    uccCommoRecommendPO.setSkuId(recommendCategeryCommoIDBO.getCommodityId().toString());
                    uccCommoRecommendPO.setSupplierId(reqBO.getOrgIdIn());
                    uccCommoRecommendPO.setColumnName(commodityRecommendIDListBO.getColumnName());
                    uccCommoRecommendPO.setSkuIndex(recommendCategeryCommoIDBO.getSkuIndex());
                    catalogRecommendAddPOS.add(uccCommoRecommendPO);
                }
            }
            try {
                this.recommendAddMapper.addCatalogRecommend(catalogRecommendAddPOS);
            }
            catch (Exception exception) {
                LOGGER.error("\u4fee\u6539-\u7c7b\u76ee\u5546\u54c1\u63a8\u8350\u5931\u8d25" + exception);
                throw new BusinessException("8888", "\u4fee\u6539-\u7c7b\u76ee\u5546\u54c1\u63a8\u8350\u5931\u8d25");
            }
        }
        catch (BusinessException e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.getMsgInfo());
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

