/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.atom.UccCreateUserOperRecordAtomService;
import com.tydic.commodity.atom.bo.UccCreateUserOperRecordAtomReqBO;
import com.tydic.commodity.atom.bo.UccUserOperInfoCreateBO;
import com.tydic.commodity.dao.UccCommodityDetailMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityMeasureMapper;
import com.tydic.commodity.dao.UccCommodityPackageMapper;
import com.tydic.commodity.dao.UccCommodityPicMapper;
import com.tydic.commodity.dao.UccLadderPriceMapper;
import com.tydic.commodity.dao.UccSaleNumMapper;
import com.tydic.commodity.dao.UccSkuDetailMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.po.UccCommodityDetailPo;
import com.tydic.commodity.dao.po.UccCommodityMeasurePo;
import com.tydic.commodity.dao.po.UccCommodityPackagePo;
import com.tydic.commodity.dao.po.UccCommodityPicPo;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.dao.po.UccLadderPricePO;
import com.tydic.commodity.dao.po.UccSaleNumPo;
import com.tydic.commodity.dao.po.UccSkuDetailPO;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.dao.po.UccSkuPricePo;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.util.MoneyUtils;
import com.tydic.uccext.bo.UccCreateCommodityBO;
import com.tydic.uccext.bo.UccCreateCommodityBusiReqBO;
import com.tydic.uccext.bo.UccCreateCommodityBusiRspBO;
import com.tydic.uccext.constant.UccConstants;
import com.tydic.uccext.dao.UccSceneSkuSubscribeMapper;
import com.tydic.uccext.dao.po.UccSceneSkuSubscribePO;
import com.tydic.uccext.service.UccCreateCommodityBusiService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccCreateCommodityBusiServiceImpl
implements UccCreateCommodityBusiService {
    private Sequence sequence = Sequence.getInstance();
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccLadderPriceMapper uccLadderPriceMapper;
    @Autowired
    private UccCommodityMeasureMapper uccCommodityMeasureMapper;
    @Autowired
    private UccSceneSkuSubscribeMapper uccSceneSkuSubscribeMapper;
    @Autowired
    private UccCommodityPicMapper uccCommodityPicMapper;
    @Autowired
    private UccCommodityDetailMapper uccCommodityDetailMapper;
    @Autowired
    private UccCommodityPackageMapper uccCommodityPackageMapper;
    @Autowired
    private UccSaleNumMapper uccSaleNumMapper;
    @Autowired
    private UccSkuDetailMapper uccSkuDetailMapper;
    @Autowired
    private UccCreateUserOperRecordAtomService uccCreateUserOperRecordAtomService;

    public UccCreateCommodityBusiRspBO createCommodity(UccCreateCommodityBusiReqBO reqBo) {
        UccCreateCommodityBusiRspBO rspBo = new UccCreateCommodityBusiRspBO();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getCreateInfoList())) {
            this.dealMeasure(reqBo.getCreateInfoList(), reqBo.getUsername());
            this.dealCommodity(reqBo.getCreateInfoList(), reqBo.getUsername());
            this.dealSku(reqBo.getCreateInfoList(), reqBo.getUsername());
            this.dealPackage(reqBo.getCreateInfoList(), reqBo.getUsername());
            this.dealPic(reqBo.getCreateInfoList(), reqBo.getUsername());
            this.dealPrice(reqBo.getCreateInfoList(), reqBo.getUsername());
            this.dealLadderPrice(reqBo.getCreateInfoList());
            this.dealSceneRel(reqBo.getCreateInfoList(), reqBo.getUsername());
            this.dealSaleNum(reqBo.getCreateInfoList(), reqBo.getUsername());
            this.dealOperRecord(reqBo.getCreateInfoList(), reqBo.getOperType(), reqBo.getUsername());
            HashMap commodityList = new HashMap(reqBo.getCreateInfoList().size());
            List commodityIdList = reqBo.getCreateInfoList().stream().map(UccCreateCommodityBO::getCommodityId).collect(Collectors.toList());
            commodityList.put(UccConstants.ATOUR_SUPPLIER_SHOP_ID, commodityIdList);
            rspBo.setCommodityList(commodityList);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void dealMeasure(List<UccCreateCommodityBO> createInfoList, String username) {
        List<String> measureNameList = createInfoList.stream().map(UccCreateCommodityBO::getMeasureName).collect(Collectors.toList());
        List commodityMeasures = this.uccCommodityMeasureMapper.batchQueryMeasureByName(measureNameList);
        ArrayList<String> needCreate = new ArrayList<String>();
        HashMap measureMap = new HashMap(measureNameList.size());
        if (!CollectionUtils.isEmpty((Collection)commodityMeasures)) {
            Map<String, List<UccCommodityMeasurePo>> collect = commodityMeasures.stream().collect(Collectors.groupingBy(UccCommodityMeasurePo::getMeasureName));
            measureNameList.forEach(name -> {
                if (collect.containsKey(name)) {
                    measureMap.put(name, ((UccCommodityMeasurePo)((List)collect.get(name)).get(0)).getMeasureId());
                } else {
                    needCreate.add((String)name);
                }
            });
        } else {
            needCreate.addAll(measureNameList);
        }
        ArrayList commodityMeasureInsert = new ArrayList();
        needCreate.forEach(need -> {
            UccCommodityMeasurePo uccCommodityMeasurePo = new UccCommodityMeasurePo();
            Long measureId = this.sequence.nextId();
            uccCommodityMeasurePo.setMeasureId(measureId);
            uccCommodityMeasurePo.setMeasureName(need);
            uccCommodityMeasurePo.setMeasureType(Integer.valueOf(0));
            uccCommodityMeasurePo.setCreateLoginId(username);
            uccCommodityMeasurePo.setCreateTime(new Date());
            uccCommodityMeasurePo.setIsDelete(Integer.valueOf(0));
            commodityMeasureInsert.add(uccCommodityMeasurePo);
            measureMap.put(need, measureId);
        });
        if (!CollectionUtils.isEmpty(needCreate) && CollectionUtils.isEmpty(commodityMeasureInsert)) {
            throw new BusinessException("8888", "\u7ec4\u88c5\u57fa\u672c\u5355\u4f4d\u4fe1\u606f\u5f02\u5e38");
        }
        if (!CollectionUtils.isEmpty(commodityMeasureInsert)) {
            this.uccCommodityMeasureMapper.insertBatch(commodityMeasureInsert);
        }
        createInfoList.forEach(info -> info.setMeasureId((Long)measureMap.get(info.getMeasureName())));
    }

    private void dealCommodity(List<UccCreateCommodityBO> createInfoList, String username) {
        ArrayList commodityPoList = new ArrayList();
        createInfoList.forEach(info -> {
            Long commodityId = this.sequence.nextId();
            UccCommodityPo uccCommodityPo = new UccCommodityPo();
            uccCommodityPo.setCommodityId(commodityId);
            uccCommodityPo.setCommodityCode(info.getCommodityCode());
            uccCommodityPo.setCommodityName(info.getCommodityName());
            uccCommodityPo.setCommodityTypeId(info.getCommodityTypeId());
            uccCommodityPo.setCommoditySource(info.getCommoditySource());
            uccCommodityPo.setCommodityStatus(info.getCommodityStatus());
            uccCommodityPo.setSupplierShopId(UccConstants.ATOUR_SUPPLIER_SHOP_ID);
            uccCommodityPo.setShopName("\u4e9a\u6735");
            uccCommodityPo.setCommodityBanner(info.getCommodityBanner());
            uccCommodityPo.setBrandId(info.getBrandId());
            uccCommodityPo.setBrandName(info.getBrandName());
            uccCommodityPo.setMaterialId(info.getMaterialId());
            uccCommodityPo.setCreateOperId(username);
            uccCommodityPo.setCreateTime(new Date());
            uccCommodityPo.setViewOrder(Integer.valueOf(0));
            uccCommodityPo.setFreeFhipping(UccConstants.YesOrNo.YES);
            uccCommodityPo.setExtSkuId(info.getExtSkuId());
            commodityPoList.add(uccCommodityPo);
            info.setCommodityId(commodityId);
        });
        if (CollectionUtils.isEmpty(commodityPoList)) {
            throw new BusinessException("8888", "\u7ec4\u88c5\u5546\u54c1\u4fe1\u606f\u5f02\u5e38");
        }
        this.uccCommodityMapper.insertBatch(commodityPoList);
        ArrayList uccCommodityDetailPos = new ArrayList();
        createInfoList.forEach(info -> {
            UccCommodityDetailPo uccCommodityDetailPo = new UccCommodityDetailPo();
            uccCommodityDetailPo.setCommodityId(info.getCommodityId());
            uccCommodityDetailPo.setSupplierShopId(UccConstants.ATOUR_SUPPLIER_SHOP_ID);
            uccCommodityDetailPo.setCommodityPcDetailUrl(info.getCommodityPcDetailUrl());
            uccCommodityDetailPo.setCommodityPcDetailChar(info.getCommodityPcDetailChar());
            uccCommodityDetailPos.add(uccCommodityDetailPo);
        });
        if (!CollectionUtils.isEmpty(uccCommodityDetailPos)) {
            this.uccCommodityDetailMapper.insertBatch(uccCommodityDetailPos);
        }
    }

    private void dealSku(List<UccCreateCommodityBO> createInfoList, String username) {
        ArrayList skuPoList = new ArrayList();
        createInfoList.forEach(info -> {
            UccSkuPo skuPo = new UccSkuPo();
            skuPo.setMaxoq(null == info.getMaxoq() ? null : BigDecimal.valueOf(info.getMaxoq().intValue()));
            skuPo.setLimitCount(null == info.getLimitCount() ? null : BigDecimal.valueOf(info.getLimitCount().intValue()));
            skuPo.setSalesUnitName(null == info.getCommodityPackageSpec() ? null : info.getCommodityPackageSpec().getSaleUnitName());
            skuPo.setSalesUnitRate(null == info.getCommodityPackageSpec() ? null : info.getCommodityPackageSpec().getUnitRate());
            skuPo.setIsShopSalesUnit(info.getIsShowSaleUnit());
            skuPo.setSkuId(info.getCommodityId());
            skuPo.setCommodityId(info.getCommodityId());
            skuPo.setSupplierShopId(UccConstants.ATOUR_SUPPLIER_SHOP_ID);
            skuPo.setShopName("\u4e9a\u6735");
            skuPo.setCommodityTypeId(info.getCommodityTypeId());
            skuPo.setSkuCode(info.getCommodityCode());
            skuPo.setSkuSource(info.getCommoditySource());
            skuPo.setSkuName(info.getCommodityName());
            skuPo.setSkuLongName(info.getCommodityName());
            skuPo.setSkuStatus(info.getSkuStatus());
            skuPo.setBrandId(info.getBrandId());
            skuPo.setBrandName(info.getBrandName());
            skuPo.setMeasureId(info.getMeasureId());
            skuPo.setMeasureName(info.getMeasureName());
            skuPo.setMaterialId(info.getMaterialId().toString());
            skuPo.setMoq(null == info.getMoq() ? null : BigDecimal.valueOf(info.getMoq().intValue()));
            skuPo.setMaterialId(info.getMaterialId().toString());
            skuPo.setCreateOperId(username);
            skuPo.setCreateTime(new Date());
            skuPo.setPackageSpec(null == info.getCommodityPackageSpec() ? null : info.getCommodityPackageSpec().getPackageSpec());
            skuPo.setSettlementUnit(null == info.getCommodityPackageSpec() ? null : info.getCommodityPackageSpec().getSettleUnit());
            skuPo.setExtSkuId(info.getExtSkuId());
            skuPoList.add(skuPo);
        });
        if (CollectionUtils.isEmpty(skuPoList)) {
            throw new BusinessException("8888", "\u7ec4\u88c5\u5355\u54c1\u4fe1\u606f\u5f02\u5e38");
        }
        this.uccSkuMapper.insertBatch(skuPoList);
        ArrayList skuDetailPoList = new ArrayList();
        createInfoList.forEach(info -> {
            UccSkuDetailPO uccSkuDetailPo = new UccSkuDetailPO();
            uccSkuDetailPo.setSkuId(info.getCommodityId());
            uccSkuDetailPo.setCommodityId(info.getCommodityId());
            uccSkuDetailPo.setSupplierShopId(UccConstants.ATOUR_SUPPLIER_SHOP_ID);
            uccSkuDetailPo.setSkuPcDetailUrl(info.getCommodityPcDetailUrl());
            uccSkuDetailPo.setSkuPcDetailChar(info.getCommodityPcDetailChar());
            skuDetailPoList.add(uccSkuDetailPo);
        });
        if (!CollectionUtils.isEmpty(skuDetailPoList)) {
            this.uccSkuDetailMapper.insertBatch(skuDetailPoList);
        }
    }

    private void dealPackage(List<UccCreateCommodityBO> createInfoList, String username) {
        ArrayList uccCommodityPackagePoList = new ArrayList();
        createInfoList.forEach(info -> {
            UccCommodityPackagePo uccCommodityPackagePo = new UccCommodityPackagePo();
            uccCommodityPackagePo.setPackageId(Long.valueOf(this.sequence.nextId()));
            uccCommodityPackagePo.setCommodityId(info.getCommodityId());
            uccCommodityPackagePo.setSupplierShopId(UccConstants.ATOUR_SUPPLIER_SHOP_ID);
            uccCommodityPackagePo.setPackParam(info.getPackParam());
            uccCommodityPackagePo.setAfterService(info.getAfterService());
            uccCommodityPackagePo.setInvoiceType(Integer.valueOf(1));
            uccCommodityPackagePo.setCreateOperId(username);
            uccCommodityPackagePo.setCreateTime(new Date());
            uccCommodityPackagePoList.add(uccCommodityPackagePo);
        });
        if (!CollectionUtils.isEmpty(uccCommodityPackagePoList)) {
            this.uccCommodityPackageMapper.batchInsert(uccCommodityPackagePoList);
        }
    }

    private void dealPic(List<UccCreateCommodityBO> createInfoList, String username) {
        ArrayList uccCommodityPicPoList = new ArrayList();
        createInfoList.forEach(info -> {
            if (!CollectionUtils.isEmpty((Collection)info.getCommdImages())) {
                info.getCommdImages().forEach(pic -> {
                    UccCommodityPicPo uccCommodityPicPo = new UccCommodityPicPo();
                    uccCommodityPicPo.setCommodityPicId(Long.valueOf(this.sequence.nextId()));
                    uccCommodityPicPo.setCommodityId(info.getCommodityId());
                    uccCommodityPicPo.setCommodityPicType(pic.getPicType());
                    uccCommodityPicPo.setCommodityPicUrl(pic.getPicUrl());
                    uccCommodityPicPo.setCreateOperId(username);
                    uccCommodityPicPo.setCreateTime(new Date());
                    uccCommodityPicPo.setSupplierShopId(UccConstants.ATOUR_SUPPLIER_SHOP_ID);
                    uccCommodityPicPo.setPicOrder(pic.getPicOrder());
                    uccCommodityPicPoList.add(uccCommodityPicPo);
                });
            }
        });
        if (!CollectionUtils.isEmpty(uccCommodityPicPoList)) {
            this.uccCommodityPicMapper.batchInsert(uccCommodityPicPoList);
        }
    }

    private void dealPrice(List<UccCreateCommodityBO> createInfoList, String username) {
        ArrayList skuPricePoList = new ArrayList();
        createInfoList.forEach(info -> {
            UccSkuPricePo uccSkuPricePo = new UccSkuPricePo();
            Long skuPriceId = this.sequence.nextId();
            uccSkuPricePo.setSkuPriceId(skuPriceId);
            uccSkuPricePo.setSkuId(info.getCommodityId());
            uccSkuPricePo.setSupplierShopId(UccConstants.ATOUR_SUPPLIER_SHOP_ID);
            if (UccConstants.YesOrNo.YES.equals(info.getIsShowSaleUnit()) && null != info.getCommodityPackageSpec()) {
                uccSkuPricePo.setAgreementPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)info.getCommodityPackageSpec().getAgreementPrice())));
                uccSkuPricePo.setSalePrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)info.getCommodityPackageSpec().getSalePrice())));
            } else {
                uccSkuPricePo.setAgreementPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)info.getSalePrice())));
                uccSkuPricePo.setSalePrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)info.getSalePrice())));
            }
            uccSkuPricePo.setCurrencyType(Integer.valueOf(0));
            uccSkuPricePo.setCreateOperId(username);
            uccSkuPricePo.setCreateTime(new Date());
            skuPricePoList.add(uccSkuPricePo);
            info.setSkuPriceId(skuPriceId);
        });
        if (CollectionUtils.isEmpty(skuPricePoList)) {
            throw new BusinessException("8888", "\u7ec4\u88c5\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u5f02\u5e38");
        }
        this.uccSkuPriceMapper.batchInsert(skuPricePoList);
    }

    private void dealLadderPrice(List<UccCreateCommodityBO> createInfoList) {
        ArrayList ladderPricePoList = new ArrayList();
        createInfoList.forEach(info -> {
            if (!CollectionUtils.isEmpty((Collection)info.getLadderPrice())) {
                info.getLadderPrice().forEach(ladder -> {
                    UccLadderPricePO uccLadderPricePo = new UccLadderPricePO();
                    uccLadderPricePo.setId(Long.valueOf(this.sequence.nextId()));
                    uccLadderPricePo.setSupplierShopId(UccConstants.ATOUR_SUPPLIER_SHOP_ID);
                    uccLadderPricePo.setSkuPriceId(info.getSkuPriceId());
                    uccLadderPricePo.setSkuId(info.getCommodityId());
                    uccLadderPricePo.setStart(ladder.getStart());
                    uccLadderPricePo.setStop((Long)(null != ladder.getStop() && 0L >= ladder.getStop() ? null : ladder.getStop()));
                    uccLadderPricePo.setPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)ladder.getPrice())));
                    uccLadderPricePo.setDiscount(ladder.getDiscount());
                    ladderPricePoList.add(uccLadderPricePo);
                });
            }
        });
        if (!CollectionUtils.isEmpty(ladderPricePoList)) {
            this.uccLadderPriceMapper.batchInsert(ladderPricePoList);
        }
    }

    private void dealSceneRel(List<UccCreateCommodityBO> createInfoList, String username) {
        ArrayList<UccSceneSkuSubscribePO> sceneSkuSubscribePoList = new ArrayList<UccSceneSkuSubscribePO>();
        createInfoList.forEach(info -> {
            if (CollectionUtils.isEmpty((Collection)info.getSceneIds())) {
                throw new BusinessException("8888", "\u9152\u5e97\u54c1\u724c\u5173\u8054\u4fe1\u606f\u4e3a\u7a7a");
            }
            info.getSceneIds().forEach(sceneId -> {
                UccSceneSkuSubscribePO uccSceneSkuSubscribePo = new UccSceneSkuSubscribePO();
                uccSceneSkuSubscribePo.setId(this.sequence.nextId());
                uccSceneSkuSubscribePo.setSceneId((Long)sceneId);
                uccSceneSkuSubscribePo.setCommodityId(info.getCommodityId());
                uccSceneSkuSubscribePo.setSubscribeType(0L);
                uccSceneSkuSubscribePo.setSkuId(info.getCommodityId());
                uccSceneSkuSubscribePo.setStatus(UccConstants.Status.VALID.longValue());
                uccSceneSkuSubscribePo.setCreateOperId(username);
                uccSceneSkuSubscribePo.setCreateTime(new Date());
                sceneSkuSubscribePoList.add(uccSceneSkuSubscribePo);
            });
        });
        if (CollectionUtils.isEmpty(sceneSkuSubscribePoList)) {
            throw new BusinessException("8888", "\u7ec4\u88c5\u9152\u5e97\u54c1\u724c\u5173\u8054\u4fe1\u606f\u5f02\u5e38");
        }
        this.uccSceneSkuSubscribeMapper.insertBatch(sceneSkuSubscribePoList);
    }

    private void dealSaleNum(List<UccCreateCommodityBO> createInfoList, String username) {
        ArrayList uccSaleNumPoList = new ArrayList();
        createInfoList.forEach(info -> {
            UccSaleNumPo uccSaleNumPo = new UccSaleNumPo();
            uccSaleNumPo.setSaleId(Long.valueOf(this.sequence.nextId()));
            uccSaleNumPo.setSkuId(info.getCommodityId());
            uccSaleNumPo.setSupplierShopId(UccConstants.ATOUR_SUPPLIER_SHOP_ID);
            uccSaleNumPo.setSoldNumber(BigDecimal.ZERO);
            uccSaleNumPo.setCreateOperId(username);
            uccSaleNumPo.setCreateTime(new Date());
            uccSaleNumPoList.add(uccSaleNumPo);
        });
        if (!CollectionUtils.isEmpty(uccSaleNumPoList)) {
            this.uccSaleNumMapper.insertBatch(uccSaleNumPoList);
        }
    }

    private void dealOperRecord(List<UccCreateCommodityBO> createInfoList, Integer operType, String username) {
        List<Long> commodityIdList = createInfoList.stream().map(UccCreateCommodityBO::getCommodityId).collect(Collectors.toList());
        UccCreateUserOperRecordAtomReqBO uccCreateUserOperRecordAtomReqBo = new UccCreateUserOperRecordAtomReqBO();
        ArrayList userOperInfoCreateBoList = new ArrayList();
        commodityIdList.forEach(id -> {
            UccUserOperInfoCreateBO uccUserOperInfoCreateBo = new UccUserOperInfoCreateBO();
            uccUserOperInfoCreateBo.setCreateOper(username);
            uccUserOperInfoCreateBo.setCreateTime(new Date());
            uccUserOperInfoCreateBo.setOperType(operType);
            uccUserOperInfoCreateBo.setCommodityId(id);
            uccUserOperInfoCreateBo.setSkuId(id);
            userOperInfoCreateBoList.add(uccUserOperInfoCreateBo);
        });
        uccCreateUserOperRecordAtomReqBo.setUserOperInfoList(userOperInfoCreateBoList);
        this.uccCreateUserOperRecordAtomService.createUserOperRecord(uccCreateUserOperRecordAtomReqBo);
    }
}

