/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.atom.UccCreateUserOperRecordAtomService;
import com.tydic.commodity.atom.bo.UccCreateUserOperRecordAtomReqBO;
import com.tydic.commodity.atom.bo.UccUserOperInfoCreateBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.enumType.SkuOperTypeEnum;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.util.DateUtils;
import com.tydic.uccext.bo.UccCreateGiftAndSkuRelAbilityReqBO;
import com.tydic.uccext.bo.UccCreateGiftAndSkuRelAbilityRspBO;
import com.tydic.uccext.dao.UccRelSkuGiftsMapper;
import com.tydic.uccext.dao.po.UccRelSkuGiftsPO;
import com.tydic.uccext.service.UccCreateGiftAndSkuRelBusiService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccCreateGiftAndSkuRelBusiServiceImpl
implements UccCreateGiftAndSkuRelBusiService {
    @Autowired
    private UccRelSkuGiftsMapper uccRelSkuGiftsMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    private Sequence sequence = Sequence.getInstance();
    @Autowired
    private UccCreateUserOperRecordAtomService uccCreateUserOperRecordAtomService;

    public UccCreateGiftAndSkuRelAbilityRspBO createGiftAndSkuRel(UccCreateGiftAndSkuRelAbilityReqBO reqBo) {
        this.doDelRel(reqBo);
        this.doAddRel(reqBo);
        this.dealOperRecord(reqBo);
        UccCreateGiftAndSkuRelAbilityRspBO rspBo = new UccCreateGiftAndSkuRelAbilityRspBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void dealOperRecord(UccCreateGiftAndSkuRelAbilityReqBO reqBo) {
        UccCreateUserOperRecordAtomReqBO uccCreateUserOperRecordAtomReqBo = new UccCreateUserOperRecordAtomReqBO();
        ArrayList<UccUserOperInfoCreateBO> userOperInfoCreateBoList = new ArrayList<UccUserOperInfoCreateBO>();
        UccUserOperInfoCreateBO uccUserOperInfoCreateBo = new UccUserOperInfoCreateBO();
        uccUserOperInfoCreateBo.setCreateOper(reqBo.getUsername());
        uccUserOperInfoCreateBo.setCreateTime(new Date());
        uccUserOperInfoCreateBo.setOperType(SkuOperTypeEnum.REL_GIFT.getOperType());
        uccUserOperInfoCreateBo.setCommodityId(reqBo.getCommodityId());
        uccUserOperInfoCreateBo.setSkuId(reqBo.getSkuId());
        userOperInfoCreateBoList.add(uccUserOperInfoCreateBo);
        uccCreateUserOperRecordAtomReqBo.setUserOperInfoList(userOperInfoCreateBoList);
        this.uccCreateUserOperRecordAtomService.createUserOperRecord(uccCreateUserOperRecordAtomReqBo);
    }

    private void doDelRel(UccCreateGiftAndSkuRelAbilityReqBO reqBo) {
        UccRelSkuGiftsPO uccRelSkuGiftsPo = new UccRelSkuGiftsPO();
        uccRelSkuGiftsPo.setCommodityId(reqBo.getCommodityId());
        uccRelSkuGiftsPo.setSkuId(reqBo.getSkuId());
        this.uccRelSkuGiftsMapper.deleteBy(uccRelSkuGiftsPo);
    }

    private void doAddRel(UccCreateGiftAndSkuRelAbilityReqBO reqBo) {
        ArrayList<UccRelSkuGiftsPO> insertListPO = new ArrayList<UccRelSkuGiftsPO>();
        List<UccSkuPo> skuList = this.doQrySku(reqBo);
        skuList.forEach(sku -> {
            UccRelSkuGiftsPO uccRelSkuGiftsPO = new UccRelSkuGiftsPO();
            insertListPO.add(uccRelSkuGiftsPO);
            BeanUtils.copyProperties((Object)reqBo, (Object)uccRelSkuGiftsPO);
            uccRelSkuGiftsPO.setRuleBuyCount(reqBo.getRuleBuyCount().longValue());
            uccRelSkuGiftsPO.setRulePresentCount(reqBo.getRulePresentCount().longValue());
            uccRelSkuGiftsPO.setSkuId(sku.getSkuId());
            uccRelSkuGiftsPO.setSkuName(sku.getSkuName());
            uccRelSkuGiftsPO.setCommodityId(sku.getCommodityId());
            uccRelSkuGiftsPO.setEffTime(DateUtils.strToDate((String)reqBo.getEffTime()));
            uccRelSkuGiftsPO.setExpTime(DateUtils.strToDate((String)reqBo.getExpTime()));
            uccRelSkuGiftsPO.setRelId(this.sequence.nextId());
            uccRelSkuGiftsPO.setCreateOperId(reqBo.getUsername());
            uccRelSkuGiftsPO.setCreateTime(new Date());
        });
        this.uccRelSkuGiftsMapper.insertBatch(insertListPO);
    }

    private List<UccSkuPo> doQrySku(UccCreateGiftAndSkuRelAbilityReqBO reqBo) {
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setCommodityId(reqBo.getCommodityId());
        uccSkuPo.setSkuId(reqBo.getSkuId());
        List skuList = this.uccSkuMapper.qerySku(uccSkuPo);
        if (CollectionUtils.isEmpty((Collection)skuList)) {
            throw new BusinessException("8888", "\u67e5\u8be2\u4e0d\u5230\u5546\u54c1\u6570\u636e\uff01");
        }
        return skuList;
    }
}

