/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.dao.UccCommodityMeasureMapper;
import com.tydic.commodity.dao.po.UccCommodityMeasurePo;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.uccext.bo.UccCreateGiftAbilityReqBO;
import com.tydic.uccext.bo.UccCreateGiftAbilityRspBO;
import com.tydic.uccext.constant.UccConstants;
import com.tydic.uccext.dao.UccGiftsMapper;
import com.tydic.uccext.dao.UccGiftsPicMapper;
import com.tydic.uccext.dao.po.UccGiftsPO;
import com.tydic.uccext.dao.po.UccGiftsPicPO;
import com.tydic.uccext.service.UccCreateGiftBusiService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccCreateGiftBusiServiceImpl
implements UccCreateGiftBusiService {
    @Autowired
    private UccGiftsMapper uccGiftsMapper;
    @Autowired
    private UccGiftsPicMapper uccGiftsPicMapper;
    @Autowired
    private UccCommodityMeasureMapper uccCommodityMeasureMapper;
    private Sequence sequence = Sequence.getInstance();

    public UccCreateGiftAbilityRspBO createGift(UccCreateGiftAbilityReqBO reqBo) {
        this.dealMeasure(reqBo);
        Long giftId = this.doInsertGifs(reqBo);
        this.doInsertGifsPic(reqBo, giftId);
        UccCreateGiftAbilityRspBO rspBo = new UccCreateGiftAbilityRspBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void dealMeasure(UccCreateGiftAbilityReqBO reqBo) {
        Long measureId;
        ArrayList<String> measureNameList = new ArrayList<String>(1);
        measureNameList.add(reqBo.getMeasureName());
        List commodityMeasures = this.uccCommodityMeasureMapper.batchQueryMeasureByName(measureNameList);
        if (!CollectionUtils.isEmpty((Collection)commodityMeasures)) {
            measureId = ((UccCommodityMeasurePo)commodityMeasures.get(0)).getMeasureId();
        } else {
            ArrayList<UccCommodityMeasurePo> commodityMeasureInsert = new ArrayList<UccCommodityMeasurePo>(1);
            UccCommodityMeasurePo uccCommodityMeasurePo = new UccCommodityMeasurePo();
            commodityMeasureInsert.add(uccCommodityMeasurePo);
            measureId = this.sequence.nextId();
            uccCommodityMeasurePo.setMeasureId(measureId);
            uccCommodityMeasurePo.setMeasureName(reqBo.getMeasureName());
            uccCommodityMeasurePo.setMeasureType(Integer.valueOf(0));
            uccCommodityMeasurePo.setCreateLoginId(reqBo.getName());
            uccCommodityMeasurePo.setIsDelete(Integer.valueOf(0));
            uccCommodityMeasurePo.setCreateTime(new Date());
            this.uccCommodityMeasureMapper.insertBatch(commodityMeasureInsert);
        }
        reqBo.setMeasureId(measureId);
    }

    private void doInsertGifsPic(UccCreateGiftAbilityReqBO reqBo, Long giftId) {
        ArrayList<UccGiftsPicPO> list = new ArrayList<UccGiftsPicPO>(reqBo.getGiftPics().size());
        reqBo.getGiftPics().forEach(pic -> {
            UccGiftsPicPO uccGiftsPicPO = new UccGiftsPicPO();
            list.add(uccGiftsPicPO);
            BeanUtils.copyProperties((Object)pic, (Object)uccGiftsPicPO);
            if (pic.getGiftPicType() == null) {
                uccGiftsPicPO.setGiftPicType(1);
            }
            uccGiftsPicPO.setGiftId(giftId);
            uccGiftsPicPO.setGiftPicId(this.sequence.nextId());
            uccGiftsPicPO.setCreateOperId(reqBo.getUsername());
            uccGiftsPicPO.setCreateTime(new Date());
        });
        this.uccGiftsPicMapper.insertBatch(list);
    }

    private Long doInsertGifs(UccCreateGiftAbilityReqBO reqBo) {
        UccGiftsPO qryExistPo = new UccGiftsPO();
        qryExistPo.setGiftCode(reqBo.getGiftCode());
        List<UccGiftsPO> list = this.uccGiftsMapper.getList(qryExistPo);
        if (!CollectionUtils.isEmpty(list)) {
            throw new BusinessException("8888", "\u6240\u8f93\u5165\u7684\u8d60\u54c1\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u6362\u4e00\u4e2a\u518d\u8bd5\uff01");
        }
        UccGiftsPO uccGiftsPo = new UccGiftsPO();
        BeanUtils.copyProperties((Object)reqBo, (Object)uccGiftsPo);
        uccGiftsPo.setGiftId(this.sequence.nextId());
        uccGiftsPo.setGiftStatus(UccConstants.Status.VALID);
        uccGiftsPo.setCreateOperId(reqBo.getUsername());
        uccGiftsPo.setCreateTime(new Date());
        int result = this.uccGiftsMapper.insert(uccGiftsPo);
        if (result != 1) {
            throw new BusinessException("8888", "\u521b\u5efa\u8d60\u54c1\u5931\u8d25\uff01");
        }
        return uccGiftsPo.getGiftId();
    }
}

