/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl;

import com.tydic.uccext.bo.UccDeleteGiftAbilityReqBO;
import com.tydic.uccext.bo.UccDeleteGiftAbilityRspBO;
import com.tydic.uccext.constant.UccConstants;
import com.tydic.uccext.dao.UccGiftsDeletedMapper;
import com.tydic.uccext.dao.UccGiftsMapper;
import com.tydic.uccext.dao.UccRelSkuGiftsMapper;
import com.tydic.uccext.dao.po.UccGiftsDeletedPO;
import com.tydic.uccext.dao.po.UccGiftsPO;
import com.tydic.uccext.service.UccDeleteGiftBusiService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccDeleteGiftBusiServiceImpl
implements UccDeleteGiftBusiService {
    @Autowired
    private UccGiftsMapper uccGiftsMapper;
    @Autowired
    private UccRelSkuGiftsMapper uccRelSkuGiftsMapper;
    @Autowired
    private UccGiftsDeletedMapper uccGiftsDeletedMapper;

    public UccDeleteGiftAbilityRspBO deleteGift(UccDeleteGiftAbilityReqBO reqBo) {
        this.doDelGifs(reqBo);
        this.doDelGifsSkuRel(reqBo.getGiftIdList());
        UccDeleteGiftAbilityRspBO rspBo = new UccDeleteGiftAbilityRspBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void doDelGifsSkuRel(List<Long> giftIdList) {
        if (!CollectionUtils.isEmpty(giftIdList)) {
            this.uccRelSkuGiftsMapper.batchDeleteByGiftIds(giftIdList);
        }
    }

    private void doDelGifs(UccDeleteGiftAbilityReqBO reqBo) {
        List<UccGiftsPO> giftsPoList;
        if (!CollectionUtils.isEmpty((Collection)reqBo.getGiftIdList()) && !CollectionUtils.isEmpty(giftsPoList = this.uccGiftsMapper.getListByIds(reqBo.getGiftIdList()))) {
            ArrayList<UccGiftsDeletedPO> uccGiftsDeletedPoList = new ArrayList<UccGiftsDeletedPO>();
            Date now = new Date();
            giftsPoList.forEach(po -> {
                UccGiftsDeletedPO uccGiftsDeletedPo = new UccGiftsDeletedPO();
                uccGiftsDeletedPo.setGiftId(po.getGiftId());
                uccGiftsDeletedPo.setGiftCode(po.getGiftCode());
                uccGiftsDeletedPo.setGiftName(po.getGiftName());
                uccGiftsDeletedPo.setGiftStatus(UccConstants.Status.INVALID);
                uccGiftsDeletedPo.setMeasureId(po.getMeasureId());
                uccGiftsDeletedPo.setMeasureName(po.getMeasureName());
                uccGiftsDeletedPo.setBrandId(po.getBrandId());
                uccGiftsDeletedPo.setBrandName(po.getBrandName());
                uccGiftsDeletedPo.setDetail(po.getDetail());
                uccGiftsDeletedPo.setRemark(po.getRemark());
                uccGiftsDeletedPo.setCreateOperId(po.getCreateOperId());
                uccGiftsDeletedPo.setCreateTime(po.getCreateTime());
                uccGiftsDeletedPo.setUpdateOperId(reqBo.getUsername());
                uccGiftsDeletedPo.setUpdateTime(now);
                uccGiftsDeletedPoList.add(uccGiftsDeletedPo);
            });
            if (!CollectionUtils.isEmpty(uccGiftsDeletedPoList)) {
                this.uccGiftsDeletedMapper.insertBatch(uccGiftsDeletedPoList);
                this.uccGiftsMapper.batchDeleteByIds(reqBo.getGiftIdList());
            }
        }
    }
}

