/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl;

import com.tydic.commodity.dao.UccMallBrandRelMapper;
import com.tydic.commodity.dao.po.UccMallBrandRelPO;
import com.tydic.uccext.bo.BrandESBO;
import com.tydic.uccext.bo.UccMallBrandUpdateAbilityBo;
import com.tydic.uccext.bo.UccMallBrandUpdateAbilityReqBo;
import com.tydic.uccext.bo.UccMallBrandUpdateAbilityRspBo;
import com.tydic.uccext.constant.UccConstants;
import com.tydic.uccext.dao.UccBrandExtMapper;
import com.tydic.uccext.service.UccMallBrandUpdateBusiService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccMallBrandUpdateBusiServiceImpl
implements UccMallBrandUpdateBusiService {
    @Autowired
    private UccBrandExtMapper uccBrandExtMapper;
    @Autowired
    private UccMallBrandRelMapper uccMallBrandRelMapper;

    public UccMallBrandUpdateAbilityRspBo updateBrandInfo(UccMallBrandUpdateAbilityReqBo reqBo) {
        Map<List<Long>, Map<Object, Object>> dealCreateRel;
        UccMallBrandUpdateAbilityRspBo rspBo = new UccMallBrandUpdateAbilityRspBo();
        ArrayList<BrandESBO> brandList = new ArrayList<BrandESBO>();
        Map<Integer, List<UccMallBrandUpdateAbilityBo>> collect = reqBo.getBrandInfo().stream().collect(Collectors.groupingBy(UccMallBrandUpdateAbilityBo::getType));
        List<Long> dealCancelRel = this.dealCancelRel(collect.get(UccConstants.BrandRelOperType.CANCEL));
        if (!CollectionUtils.isEmpty(dealCancelRel)) {
            BrandESBO brandEsBo = new BrandESBO();
            brandEsBo.setBrandIdList(dealCancelRel);
            HashMap<String, String> updateMap = new HashMap<String, String>(2);
            updateMap.put("brand_id", "ctx._source.origin_brand_id");
            updateMap.put("brand_name", "ctx._source.origin_brand_name");
            brandEsBo.setBrandMap(updateMap);
            brandList.add(brandEsBo);
        }
        if (!CollectionUtils.isEmpty(dealCreateRel = this.dealCreateRel(collect.get(UccConstants.BrandRelOperType.CREATE)))) {
            dealCreateRel.forEach((idList, brandMap) -> {
                BrandESBO brandEsBo = new BrandESBO();
                brandEsBo.setBrandIdList(idList);
                brandEsBo.setBrandMap(brandMap);
                brandList.add(brandEsBo);
            });
        }
        rspBo.setBrandList(brandList);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private List<Long> dealCancelRel(List<UccMallBrandUpdateAbilityBo> uccMallBrandUpdateAbilityBos) {
        Map<Long, List<UccMallBrandUpdateAbilityBo>> collect;
        ArrayList<Long> brandIdList = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty(uccMallBrandUpdateAbilityBos) && !CollectionUtils.isEmpty(collect = uccMallBrandUpdateAbilityBos.stream().collect(Collectors.groupingBy(UccMallBrandUpdateAbilityBo::getMallBrandId)))) {
            collect.forEach((mallBrandId, updateBrandList) -> {
                List<Long> idList;
                if (!CollectionUtils.isEmpty((Collection)updateBrandList) && !CollectionUtils.isEmpty(idList = this.uccBrandExtMapper.getBrandIdList((Long)mallBrandId, updateBrandList.stream().map(UccMallBrandUpdateAbilityBo::getBrandName).collect(Collectors.toList())))) {
                    this.uccBrandExtMapper.cancelBrandRel((Long)mallBrandId, ((UccMallBrandUpdateAbilityBo)updateBrandList.get(0)).getUpdateOperId(), idList);
                    this.uccMallBrandRelMapper.deleteRelByMallBrandIdAndBrandIds(mallBrandId, idList);
                    brandIdList.add((Long)mallBrandId);
                }
            });
        }
        return brandIdList;
    }

    private Map<List<Long>, Map<Object, Object>> dealCreateRel(List<UccMallBrandUpdateAbilityBo> uccMallBrandUpdateAbilityBos) {
        HashMap<List<Long>, Map<Object, Object>> brandMap = new HashMap<List<Long>, Map<Object, Object>>(1);
        if (!CollectionUtils.isEmpty(uccMallBrandUpdateAbilityBos)) {
            Map<String, List<UccMallBrandUpdateAbilityBo>> collect = uccMallBrandUpdateAbilityBos.stream().collect(Collectors.groupingBy(UccMallBrandUpdateAbilityBo::getMallBrandName));
            collect.forEach((mallBrandName, updateBrandList) -> {
                List<Long> idList;
                Long mallBrandId;
                if (!CollectionUtils.isEmpty((Collection)updateBrandList) && null != (mallBrandId = ((UccMallBrandUpdateAbilityBo)updateBrandList.get(0)).getMallBrandId()) && !CollectionUtils.isEmpty(idList = this.uccBrandExtMapper.getBrandIdList(null, updateBrandList.stream().map(UccMallBrandUpdateAbilityBo::getBrandName).collect(Collectors.toList())))) {
                    this.uccBrandExtMapper.updateBrandRel(mallBrandId, idList);
                    ArrayList uccMallBrandRelPoList = new ArrayList();
                    idList.forEach(id -> {
                        UccMallBrandRelPO uccMallBrandRelPo = new UccMallBrandRelPO();
                        uccMallBrandRelPo.setMallBrandId(mallBrandId);
                        uccMallBrandRelPo.setMallBrandName(mallBrandName);
                        uccMallBrandRelPo.setBrandId(id);
                        uccMallBrandRelPoList.add(uccMallBrandRelPo);
                    });
                    this.uccMallBrandRelMapper.insertBatch(uccMallBrandRelPoList);
                    HashMap<String, String> mallBrandMap = new HashMap<String, String>(2);
                    mallBrandMap.put("brand_id", mallBrandId + "L");
                    mallBrandMap.put("brand_name", "'" + mallBrandName + "'");
                    brandMap.put(idList, mallBrandMap);
                }
            });
        }
        return brandMap;
    }
}

