/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.bo.RspUccBo;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.uccext.bo.UccOrgCatalogListBO;
import com.tydic.uccext.bo.UccOrgCategoryAddReqBO;
import com.tydic.uccext.bo.UccOrgCategoryAddRspBO;
import com.tydic.uccext.constant.UccConstants;
import com.tydic.uccext.dao.UccOrgGuideCatalogSalesRestrictionMapper;
import com.tydic.uccext.dao.po.UccOrgGuideCatalogSalesRestrictionPO;
import com.tydic.uccext.service.OrgOnloadRedisSourceTypeService;
import com.tydic.uccext.service.UccOrgCategoryAddBusiService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccOrgCategoryAddBusiServiceImpl
implements UccOrgCategoryAddBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccOrgCategoryAddBusiServiceImpl.class);
    private Sequence uccBrandSequence = Sequence.getInstance();
    @Autowired
    private UccOrgGuideCatalogSalesRestrictionMapper uccOrgGuideCatalogSalesRestrictionMapper;
    @Autowired
    private OrgOnloadRedisSourceTypeService orgOnloadRedisSourceTypeService;

    public UccOrgCategoryAddRspBO dealUccOrgCategoryAdd(UccOrgCategoryAddReqBO reqBO) {
        UccOrgCategoryAddRspBO rspBO = new UccOrgCategoryAddRspBO();
        ArrayList<UccOrgCatalogListBO> uccOrgCatalogListBOS = new ArrayList<UccOrgCatalogListBO>();
        ArrayList<Long> updateIds = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getOrgCatalogList())) {
            List<Long> catalogIds = reqBO.getOrgCatalogList().stream().map(UccOrgCatalogListBO::getCatalogIdLv3Id).collect(Collectors.toList());
            List<Long> havaList = this.uccOrgGuideCatalogSalesRestrictionMapper.getListByIds(catalogIds, reqBO.getAuthType(), reqBO.getOrgId(), null);
            for (UccOrgCatalogListBO uccOrgCatalogListBO : reqBO.getOrgCatalogList()) {
                if (CollectionUtils.isEmpty((Collection)havaList)) {
                    uccOrgCatalogListBOS.add(uccOrgCatalogListBO);
                    continue;
                }
                if (!havaList.contains(uccOrgCatalogListBO.getCatalogIdLv3Id())) {
                    uccOrgCatalogListBOS.add(uccOrgCatalogListBO);
                    continue;
                }
                updateIds.add(uccOrgCatalogListBO.getCatalogIdLv3Id());
            }
        }
        ArrayList<UccOrgGuideCatalogSalesRestrictionPO> uccOrgGuideCatalogSalesRestrictionPOS = new ArrayList<UccOrgGuideCatalogSalesRestrictionPO>();
        if (!CollectionUtils.isEmpty(uccOrgCatalogListBOS)) {
            for (UccOrgCatalogListBO uccOrgCatalogListBO : uccOrgCatalogListBOS) {
                UccOrgGuideCatalogSalesRestrictionPO uccOrgGuideCatalogSalesRestrictionPO = new UccOrgGuideCatalogSalesRestrictionPO();
                BeanUtils.copyProperties((Object)uccOrgCatalogListBO, (Object)uccOrgGuideCatalogSalesRestrictionPO);
                uccOrgGuideCatalogSalesRestrictionPO.setGuideCatalogIdL1(uccOrgCatalogListBO.getCatalogIdLv1Id());
                uccOrgGuideCatalogSalesRestrictionPO.setGuideCatalogIdL2(uccOrgCatalogListBO.getCatalogIdLv2Id());
                uccOrgGuideCatalogSalesRestrictionPO.setGuideCatalogIdL3(uccOrgCatalogListBO.getCatalogIdLv3Id());
                uccOrgGuideCatalogSalesRestrictionPO.setCatalogNameL1(uccOrgCatalogListBO.getCatalogIdLv1Name());
                uccOrgGuideCatalogSalesRestrictionPO.setCatalogNameL2(uccOrgCatalogListBO.getCatalogIdLv2Name());
                uccOrgGuideCatalogSalesRestrictionPO.setCatalogNameL3(uccOrgCatalogListBO.getCatalogIdLv3Name());
                uccOrgGuideCatalogSalesRestrictionPO.setCreateOperId(reqBO.getUsername());
                uccOrgGuideCatalogSalesRestrictionPO.setCreateTime(new Date());
                uccOrgGuideCatalogSalesRestrictionPO.setUpdateOperId(reqBO.getUsername());
                uccOrgGuideCatalogSalesRestrictionPO.setUpdateTime(new Date());
                uccOrgGuideCatalogSalesRestrictionPO.setId(this.uccBrandSequence.nextId());
                uccOrgGuideCatalogSalesRestrictionPO.setRestrictionType(Long.valueOf(reqBO.getAuthType()));
                uccOrgGuideCatalogSalesRestrictionPO.setOrgId(reqBO.getOrgId());
                uccOrgGuideCatalogSalesRestrictionPO.setOrgTreePath(reqBO.getOrgPath());
                uccOrgGuideCatalogSalesRestrictionPO.setStatus((long)UccConstants.Status.VALID);
                uccOrgGuideCatalogSalesRestrictionPO.setChannelId(reqBO.getChannelId());
                uccOrgGuideCatalogSalesRestrictionPOS.add(uccOrgGuideCatalogSalesRestrictionPO);
            }
            try {
                this.uccOrgGuideCatalogSalesRestrictionMapper.insertBatch(uccOrgGuideCatalogSalesRestrictionPOS);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new BusinessException("8888", "\u64cd\u4f5c\u5931\u8d25");
            }
        }
        if (!CollectionUtils.isEmpty(updateIds)) {
            this.uccOrgGuideCatalogSalesRestrictionMapper.batchUpdate(updateIds, reqBO.getAuthType(), reqBO.getOrgId(), UccConstants.Status.VALID, reqBO.getUsername());
        }
        try {
            RspUccBo rspUccBo = reqBO.getAuthType() == 0 ? this.orgOnloadRedisSourceTypeService.dealCanCache(reqBO.getOrgId()) : this.orgOnloadRedisSourceTypeService.dealLimitCache(reqBO.getOrgPath());
            if (!"0000".equals(rspUccBo.getRespCode())) {
                log.error("\u66f4\u65b0\u53ef\u8d2d/\u9650\u552e\u7c7b\u76ee\u7f13\u5b58\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u53ef\u8d2d/\u9650\u552e\u7c7b\u76ee\u7f13\u5b58\u5931\u8d25\uff01");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

