/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl;

import com.tydic.commodity.bo.RspUccBo;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.uccext.bo.UccOrgCategoryDelReqBO;
import com.tydic.uccext.bo.UccOrgCategoryDelRspBO;
import com.tydic.uccext.constant.UccConstants;
import com.tydic.uccext.dao.UccExamineEditInfoMapper;
import com.tydic.uccext.dao.UccOrgGuideCatalogSalesRestrictionMapper;
import com.tydic.uccext.dao.UccOrgSkuSalesRestrictionMapper;
import com.tydic.uccext.service.OrgOnloadRedisSourceTypeService;
import com.tydic.uccext.service.UccOrgCategoryDelBusiService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Service
@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccOrgCategoryDelBusiService"})
public class UccOrgCategoryDelBusiServiceImpl
implements UccOrgCategoryDelBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccOrgCategoryDelBusiServiceImpl.class);
    @Autowired
    private UccOrgGuideCatalogSalesRestrictionMapper uccOrgGuideCatalogSalesRestrictionMapper;
    @Autowired
    private UccExamineEditInfoMapper uccExamineEditInfoMapper;
    @Autowired
    private OrgOnloadRedisSourceTypeService orgOnloadRedisSourceTypeService;
    @Autowired
    private UccOrgSkuSalesRestrictionMapper uccOrgSkuSalesRestrictionMapper;

    @PostMapping(value={"dealUccOrgCategory"})
    public UccOrgCategoryDelRspBO dealUccOrgCategory(@RequestBody UccOrgCategoryDelReqBO reqBO) {
        UccOrgCategoryDelRspBO rspBO = new UccOrgCategoryDelRspBO();
        try {
            int count = this.uccOrgGuideCatalogSalesRestrictionMapper.batchUpdate(reqBO.getCategoryIdL3List(), reqBO.getAuthType(), reqBO.getOrgId(), UccConstants.Status.INVALID, reqBO.getUsername());
            if (count == 0) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u60a8\u6240\u9009\u62e9\u7684\u7c7b\u76ee\u5c5e\u4e8e\u4e0a\u7ea7\u673a\u6784\u9650\u552e\u7c7b\u76ee\uff0c\u65e0\u6cd5\u8fdb\u884c\u89e3\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
                return rspBO;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
        if (reqBO.getAuthType() == UccConstants.CatalogSaleRestrictionAuthType.ORG_SALE_RESTRICTION_CATALOG.getAuthType().intValue()) {
            try {
                List<Long> skuIds = this.uccExamineEditInfoMapper.getSkuIdsByCatalog(reqBO.getCategoryIdL3List());
                this.uccOrgSkuSalesRestrictionMapper.updateStatusByOrgAndSkuList(reqBO.getOrgId(), skuIds, UccConstants.Status.INVALID);
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new BusinessException("8888", "\u5931\u8d25");
            }
        }
        try {
            RspUccBo rspUccBo = reqBO.getAuthType() == 0 ? this.orgOnloadRedisSourceTypeService.dealCanCache(reqBO.getOrgId()) : this.orgOnloadRedisSourceTypeService.dealLimitCache(reqBO.getOrgPath());
            if (!"0000".equals(rspUccBo.getRespCode())) {
                log.error("\u66f4\u65b0\u53ef\u8d2d/\u9650\u552e\u7c7b\u76ee\u7f13\u5b58\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            log.error("\u66f4\u65b0\u53ef\u8d2d/\u9650\u552e\u7c7b\u76ee\u7f13\u5b58\u5931\u8d25\uff01");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

