/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.uccext.bo.BannerModifyBO;
import com.tydic.uccext.bo.UccBannerModifyReqBo;
import com.tydic.uccext.bo.UccBannerModifyRspBo;
import com.tydic.uccext.dao.UccBannerConfigMapper;
import com.tydic.uccext.dao.UccCommoRecommendMapper;
import com.tydic.uccext.dao.UccPortalCmsSkuListMapper;
import com.tydic.uccext.dao.po.UccBannerConfigPO;
import com.tydic.uccext.dao.po.UccPortalCmsSkuListPO;
import com.tydic.uccext.service.UccPageHomeBannerModifyBusiService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccPageHomeBannerModifyBusiService"})
public class UccPageHomeBannerModifyBusiServiceImpl
implements UccPageHomeBannerModifyBusiService {
    private Sequence uccBannerSequence = Sequence.getInstance();
    @Autowired
    private UccBannerConfigMapper uccBannerConfigMapper;
    @Autowired
    private UccPortalCmsSkuListMapper uccPortalCmsSkuListMapper;
    @Autowired
    private UccCommoRecommendMapper commoRecommendMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccPageHomeBannerModifyBusiServiceImpl.class);

    @PostMapping(value={"modifyBanner"})
    public UccBannerModifyRspBo modifyBanner(@RequestBody UccBannerModifyReqBo reqBo) {
        UccBannerModifyRspBo rspBO = new UccBannerModifyRspBo();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u4fee\u6539\u6210\u529f");
        if (reqBo.getOrgIdIn() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u673a\u6784ID");
            return rspBO;
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getModifyInfos())) {
            UccBannerConfigPO uccBannerConfigPO = new UccBannerConfigPO();
            uccBannerConfigPO.setSupplierId(reqBo.getOrgIdIn());
            List<UccBannerConfigPO> uccBannerConfigPOS = this.uccBannerConfigMapper.qryList(uccBannerConfigPO);
            if (CollectionUtils.isEmpty(uccBannerConfigPOS)) {
                return rspBO;
            }
            List<Long> bannerIds = uccBannerConfigPOS.stream().map(UccBannerConfigPO::getBannerId).collect(Collectors.toList());
            this.deleteBanner(bannerIds);
            return rspBO;
        }
        for (BannerModifyBO bannerModifyBO : reqBo.getModifyInfos()) {
            if (org.apache.commons.lang.StringUtils.isEmpty((String)bannerModifyBO.getForwardUrl()) && bannerModifyBO.getCommodityId() == null) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u8df3\u8f6c\u5730\u5740\u4e0e\u5546\u54c1ID \u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
                return rspBO;
            }
            if (org.apache.commons.lang.StringUtils.isEmpty((String)bannerModifyBO.getBannerPicUrl())) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u8bf7\u8f93\u5165\u8f6e\u64ad\u56fe\u5730\u5740");
                return rspBO;
            }
            if (bannerModifyBO.getPicOrder() != null) continue;
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u8f93\u5165\u6392\u5e8f\u53f7");
            return rspBO;
        }
        List<Long> commodityIds = reqBo.getModifyInfos().stream().map(BannerModifyBO::getCommodityId).collect(Collectors.toList());
        List<Long> ids = this.commoRecommendMapper.qryNumByCommdId(commodityIds, reqBo.getOrgIdIn());
        for (Long commodityId : commodityIds) {
            if (ids.contains(commodityId) || commodityId == null) continue;
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5546\u54c1" + commodityId + "\u4e0d\u662f\u5f53\u524d\u5546\u6237\u5546\u54c1");
            return rspBO;
        }
        ArrayList<BannerModifyBO> insertBos = new ArrayList<BannerModifyBO>();
        ArrayList<Long> removeBos = new ArrayList<Long>();
        ArrayList<BannerModifyBO> modifyBos = new ArrayList<BannerModifyBO>();
        UccBannerConfigPO uccBannerConfigPO = new UccBannerConfigPO();
        uccBannerConfigPO.setSupplierId(reqBo.getOrgIdIn());
        List<UccBannerConfigPO> uccBannerConfigPOS = this.uccBannerConfigMapper.qryList(uccBannerConfigPO);
        if (CollectionUtils.isEmpty(uccBannerConfigPOS)) {
            insertBos.addAll(reqBo.getModifyInfos());
            if (CollectionUtils.isNotEmpty(insertBos)) {
                this.addBanner(insertBos, reqBo.getSupplierShopId(), reqBo.getOrgIdIn());
            }
            return rspBO;
        }
        List bannerIds = uccBannerConfigPOS.stream().map(UccBannerConfigPO::getBannerId).collect(Collectors.toList());
        List reqBannerIds = reqBo.getModifyInfos().stream().map(BannerModifyBO::getBannerId).collect(Collectors.toList());
        for (Long bannerId : bannerIds) {
            if (reqBannerIds.contains(bannerId)) continue;
            removeBos.add(bannerId);
        }
        for (BannerModifyBO bannerModifyBO : reqBo.getModifyInfos()) {
            if (bannerModifyBO.getBannerId() == null) {
                insertBos.add(bannerModifyBO);
                continue;
            }
            modifyBos.add(bannerModifyBO);
        }
        if (CollectionUtils.isNotEmpty(insertBos)) {
            this.addBanner(insertBos, reqBo.getSupplierShopId(), reqBo.getOrgIdIn());
        }
        if (CollectionUtils.isNotEmpty(removeBos)) {
            this.deleteBanner(removeBos);
        }
        if (CollectionUtils.isNotEmpty(modifyBos)) {
            this.modifyBanner(modifyBos, reqBo.getSupplierShopId(), reqBo.getOrgIdIn());
        }
        return rspBO;
    }

    private void modifyBanner(List<BannerModifyBO> bannerModifyBOS, Long supplierShopId, Long supplierId) {
        for (BannerModifyBO bannerModifyBO : bannerModifyBOS) {
            UccPortalCmsSkuListPO uccPortalCmsSkuListPO;
            List<UccBannerConfigPO> uccBannerConfigPOS;
            UccBannerConfigPO po = new UccBannerConfigPO();
            po.setBannerId(bannerModifyBO.getBannerId());
            try {
                uccBannerConfigPOS = this.uccBannerConfigMapper.qryList(po);
            }
            catch (Exception e) {
                LOGGER.error(e.toString());
                throw new BusinessException("8888", "\u6dfb\u52a0\u5931\u8d25");
            }
            String forwardUrl = uccBannerConfigPOS.get(0).getForwardUrl();
            if (org.apache.commons.lang.StringUtils.isNotEmpty((String)forwardUrl)) {
                if (bannerModifyBO.getCommodityId() != null) {
                    uccPortalCmsSkuListPO = new UccPortalCmsSkuListPO();
                    if (supplierShopId != null) {
                        uccPortalCmsSkuListPO.setSupplierId(supplierShopId);
                    } else {
                        uccPortalCmsSkuListPO.setSupplierId(supplierId);
                    }
                    uccPortalCmsSkuListPO.setColumnCode(bannerModifyBO.getBannerId().toString());
                    uccPortalCmsSkuListPO.setSkuLocation("banner");
                    uccPortalCmsSkuListPO.setSkuId(bannerModifyBO.getCommodityId());
                    try {
                        this.uccPortalCmsSkuListMapper.insertCms(uccPortalCmsSkuListPO);
                    }
                    catch (Exception e) {
                        LOGGER.error(e.toString());
                        throw new BusinessException("8888", "\u6dfb\u52a0CMS\u5f02\u5e38");
                    }
                }
            } else {
                if (bannerModifyBO.getCommodityId() != null) {
                    uccPortalCmsSkuListPO = new UccPortalCmsSkuListPO();
                    uccPortalCmsSkuListPO.setSkuId(bannerModifyBO.getCommodityId());
                    uccPortalCmsSkuListPO.setSkuLocation("banner");
                    uccPortalCmsSkuListPO.setColumnCode(bannerModifyBO.getBannerId().toString());
                    if (supplierId != null) {
                        uccPortalCmsSkuListPO.setSupplierId(supplierId);
                    } else {
                        uccPortalCmsSkuListPO.setSupplierId(supplierShopId);
                    }
                    try {
                        this.uccPortalCmsSkuListMapper.updateCms(uccPortalCmsSkuListPO);
                    }
                    catch (Exception e) {
                        LOGGER.error(e.toString());
                        throw new BusinessException("8888", "\u66f4\u65b0CMS\u5f02\u5e38");
                    }
                }
                uccPortalCmsSkuListPO = new UccPortalCmsSkuListPO();
                uccPortalCmsSkuListPO.setSkuLocation("banner");
                uccPortalCmsSkuListPO.setColumnCode(bannerModifyBO.getBannerId().toString());
                try {
                    this.uccPortalCmsSkuListMapper.deleteCms(uccPortalCmsSkuListPO);
                }
                catch (Exception e) {
                    LOGGER.error(e.toString());
                    throw new BusinessException("8888", "\u5220\u9664CMS\u5f02\u5e38");
                }
            }
            UccBannerConfigPO uccBannerConfigPO1 = new UccBannerConfigPO();
            BeanUtils.copyProperties((Object)bannerModifyBO, (Object)uccBannerConfigPO1);
            try {
                this.uccBannerConfigMapper.modifyBranner(uccBannerConfigPO1);
            }
            catch (Exception e) {
                LOGGER.error(e.toString());
                throw new BusinessException("8888", "\u66f4\u65b0BANNER\u5f02\u5e38");
            }
        }
    }

    private void addBanner(List<BannerModifyBO> bannerModifyBOS, Long supplierShopId, Long supplierId) {
        for (BannerModifyBO bannerModifyBO : bannerModifyBOS) {
            Long bannerId;
            UccBannerConfigPO uccBannerConfigPO = new UccBannerConfigPO();
            BeanUtils.copyProperties((Object)bannerModifyBO, (Object)uccBannerConfigPO);
            uccBannerConfigPO.setSupplierId(supplierId);
            uccBannerConfigPO.setSupplierShopId(supplierShopId);
            try {
                bannerId = this.uccBannerSequence.nextId();
                uccBannerConfigPO.setBannerId(bannerId);
                this.uccBannerConfigMapper.addBranner(uccBannerConfigPO);
            }
            catch (Exception e) {
                LOGGER.error(e.toString());
                throw new BusinessException("8888", "\u6dfb\u52a0NANNER\u5f02\u5e38");
            }
            if (!StringUtils.isEmpty((Object)bannerModifyBO.getForwardUrl())) continue;
            UccPortalCmsSkuListPO uccPortalCmsSkuListPO = new UccPortalCmsSkuListPO();
            uccPortalCmsSkuListPO.setColumnCode(bannerId.toString());
            uccPortalCmsSkuListPO.setSkuLocation("banner");
            uccPortalCmsSkuListPO.setSkuId(bannerModifyBO.getCommodityId());
            if (supplierId != null) {
                uccPortalCmsSkuListPO.setSupplierId(supplierId);
            } else {
                uccPortalCmsSkuListPO.setSupplierId(supplierShopId);
            }
            try {
                this.uccPortalCmsSkuListMapper.insertCms(uccPortalCmsSkuListPO);
            }
            catch (Exception e) {
                LOGGER.error(e.toString());
                throw new BusinessException("8888", "\u6dfb\u52a0CMS\u5f02\u5e38");
            }
        }
    }

    private void deleteBanner(List<Long> bannerIds) {
        try {
            this.uccBannerConfigMapper.batchDeleteBanner(bannerIds);
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
            throw new BusinessException("8888", "\u5220\u9664BANNER\u5f02\u5e38");
        }
        for (Long bannerId : bannerIds) {
            UccPortalCmsSkuListPO uccPortalCmsSkuListPO = new UccPortalCmsSkuListPO();
            uccPortalCmsSkuListPO.setSkuLocation("banner");
            uccPortalCmsSkuListPO.setColumnCode(bannerId.toString());
            try {
                this.uccPortalCmsSkuListMapper.deleteCms(uccPortalCmsSkuListPO);
            }
            catch (Exception e) {
                LOGGER.error(e.toString());
                throw new BusinessException("8888", "\u5220\u9664CMS\u5f02\u5e38");
            }
        }
    }
}

