/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.tydic.commodity.atom.UccSkuStatusUpdatesAtomService;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.enumType.SkuStatusEnum;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.validate.ValidatorUtil;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.UacQryAuditOrderAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.ability.bo.UacQryAuditOrderReqBO;
import com.tydic.uac.ability.bo.UacQryAuditOrderRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.uccext.bo.UccGoodsAgreementAndCommodityBO;
import com.tydic.uccext.bo.UccPreProcessAuditReqBO;
import com.tydic.uccext.bo.UccPreProcessAuditRspBO;
import com.tydic.uccext.service.UccPreProcessAuditBusiService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccPreProcessAuditBusiService"})
public class UccPreProcessAuditBusiServiceImpl
implements UccPreProcessAuditBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccPreProcessAuditBusiServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UacQryAuditOrderAbilityService qryAuditOrderAbilityService;
    @Autowired
    private UccSkuStatusUpdatesAtomService skuStatusUpdatesAtomService;
    @Autowired
    private UacNoTaskAuditCreateAbilityService auditCreateListAbilityService;

    @PostMapping(value={"dealPreProcessAudit"})
    public UccPreProcessAuditRspBO dealPreProcessAudit(@RequestBody UccPreProcessAuditReqBO reqBO) {
        Iterator iterator;
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO;
        UccPreProcessAuditRspBO preProcessAuditRspBO = new UccPreProcessAuditRspBO();
        ArrayList<UacNoTaskAuditCreateInfoReqBO> listBusiReqBOS = new ArrayList<UacNoTaskAuditCreateInfoReqBO>(reqBO.getSkuAndCommodity().size());
        for (UccGoodsAgreementAndCommodityBO po : reqBO.getSkuAndCommodity()) {
            ArrayList approvalObjBOS = Lists.newArrayList();
            ApprovalObjBO approvalObjBO = new ApprovalObjBO();
            approvalObjBO.setObjId(String.valueOf(po.getCommodityId()));
            approvalObjBO.setOrderId(po.getSupplierShopId());
            approvalObjBOS.add(approvalObjBO);
            UacNoTaskAuditCreateInfoReqBO auditOrderCreateListBusiReqBO = new UacNoTaskAuditCreateInfoReqBO();
            auditOrderCreateListBusiReqBO.setApprovalObjInfo((List)approvalObjBOS);
            auditOrderCreateListBusiReqBO.setObjNum(String.valueOf(approvalObjBOS.size()));
            auditOrderCreateListBusiReqBO.setObjType(reqBO.getObjType());
            auditOrderCreateListBusiReqBO.setOrderId(po.getSupplierShopId());
            listBusiReqBOS.add(auditOrderCreateListBusiReqBO);
        }
        UacNoTaskAuditCreateReqBO uocAuditAbiltyCreateListReqBO = new UacNoTaskAuditCreateReqBO();
        uocAuditAbiltyCreateListReqBO.setCreateBusiReqBO(listBusiReqBOS);
        uocAuditAbiltyCreateListReqBO.setProcDefKey(reqBO.getProcessDefId());
        uocAuditAbiltyCreateListReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        uocAuditAbiltyCreateListReqBO.setCreateOperName(reqBO.getUsername());
        try {
            LOGGER.info("\u4e13\u533a\u521b\u5efa\u5ba1\u6279\u5355\u6570\u636euocAuditAbiltyCreateListReqBO \uff1a" + JSON.toJSON((Object)uocAuditAbiltyCreateListReqBO));
            uacNoTaskAuditCreateRspBO = this.auditCreateListAbilityService.auditOrderCreate(uocAuditAbiltyCreateListReqBO);
        }
        catch (Exception e) {
            LOGGER.error("\u4e13\u533a\u521b\u5efa\u5ba1\u6279\u5355\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e);
            throw new BusinessException("8888", "\u521b\u5efa\u5ba1\u6279\u5355\u5931\u8d25");
        }
        if (uacNoTaskAuditCreateRspBO.getCustomAttributes() != null && uacNoTaskAuditCreateRspBO.getCustomAttributes().size() > 0 && (iterator = uacNoTaskAuditCreateRspBO.getCustomAttributes().entrySet().iterator()).hasNext()) {
            Map.Entry stringObjectEntry = iterator.next();
            preProcessAuditRspBO.setNextStationCode((String)stringObjectEntry.getKey());
        }
        preProcessAuditRspBO.setStepId(uacNoTaskAuditCreateRspBO.getStepId());
        preProcessAuditRspBO.setRespDesc("\u6210\u529f");
        preProcessAuditRspBO.setRespCode("0000");
        return preProcessAuditRspBO;
    }

    @PostMapping(value={"dealCheckParameters"})
    public UccPreProcessAuditRspBO dealCheckParameters(@RequestBody UccPreProcessAuditReqBO reqBO) {
        UccPreProcessAuditRspBO preProcessAuditRspBO = new UccPreProcessAuditRspBO();
        if (null == reqBO.getCurrentStatus()) {
            preProcessAuditRspBO.setRespDesc("\u6210\u529f");
            preProcessAuditRspBO.setRespCode("0000");
            return preProcessAuditRspBO;
        }
        try {
            ValidatorUtil.validator((Object)reqBO);
            if (CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
                throw new BusinessException("8888", "\u5355\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        catch (BusinessException e) {
            LOGGER.error("\u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e,\u539f\u56e0\uff1a" + e.getMsgInfo());
            throw new BusinessException("8888", e.getMsgInfo());
        }
        List skuPos = this.uccSkuMapper.batchQrySku(reqBO.getSkuIds(), reqBO.getSupplierShopId());
        if (CollectionUtils.isEmpty((Collection)skuPos)) {
            throw new BusinessException("8888", "\u5355\u54c1\u6570\u636e\u4e0d\u5b58\u5728");
        }
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<UccGoodsAgreementAndCommodityBO> uccGoodsAgreementAndCommodityBOS = new ArrayList<UccGoodsAgreementAndCommodityBO>(reqBO.getSkuIds().size());
        for (UccSkuPo po : skuPos) {
            boolean isBoolean;
            UccGoodsAgreementAndCommodityBO agreementAndCommodityBO = new UccGoodsAgreementAndCommodityBO();
            UacQryAuditOrderReqBO qryAuditOrderReqBO = new UacQryAuditOrderReqBO();
            qryAuditOrderReqBO.setObjId(po.getCommodityId().toString());
            qryAuditOrderReqBO.setObjType(reqBO.getObjType());
            qryAuditOrderReqBO.setIsToBeAudit(Boolean.valueOf(true));
            UacQryAuditOrderRspBO qryAuditOrderRspBO = this.qryAuditOrderAbilityService.qryAuditOrders(qryAuditOrderReqBO);
            if (CollectionUtils.isNotEmpty((Collection)qryAuditOrderRspBO.getApprovalOrders())) {
                LOGGER.error("\u5355\u54c1\u7f16\u53f7\u4e3a\uff1a[" + po.getSkuId() + "]\u7684\u5355\u54c1\u6b63\u5904\u4e8e\u5ba1\u6838\u4e2d");
                throw new BusinessException("8888", "\u5546\u54c1\u72b6\u6001\u6b63\u5904\u4e8e\u5ba1\u6838\u4e2d\uff0c\u8bf7\u7b49\u5f85\u5ba1\u6838\u7ed3\u679c");
            }
            boolean bl = isBoolean = reqBO.getCurrentStatus() != null && !reqBO.getCurrentStatus().isEmpty() && !reqBO.getCurrentStatus().containsKey((int)po.getSkuStatus());
            if (isBoolean) {
                for (Map.Entry integerSkuStatusEnumEntry : reqBO.getCurrentStatus().entrySet()) {
                    stringBuilder.append(((SkuStatusEnum)integerSkuStatusEnumEntry.getValue()).getStatusDesc()).append("\u6216");
                }
                LOGGER.error("\u5355\u54c1\u7f16\u53f7\u4e3a\uff1a[" + po.getSkuId() + "]\u7684\u5355\u54c1\u7684\u72b6\u6001\u5fc5\u987b\u4e3a" + stringBuilder.toString().substring(0, stringBuilder.toString().length() - 1));
                throw new BusinessException("8888", "\u6240\u9009\u5355\u54c1[" + po.getSkuId() + "]\uff0c\u72b6\u6001\u5fc5\u987b\u4e3a" + stringBuilder.toString().substring(0, stringBuilder.toString().length() - 1));
            }
            agreementAndCommodityBO.setSupplierShopId(po.getSupplierShopId());
            agreementAndCommodityBO.setCommodityId(po.getCommodityId());
            agreementAndCommodityBO.setSkuId(po.getSkuId());
            agreementAndCommodityBO.setAgreementDetailsId(po.getAgreementDetailsId() == null ? null : po.getAgreementDetailsId().toString());
            agreementAndCommodityBO.setAgreementId(po.getAgreementId() == null ? null : po.getAgreementId().toString());
            uccGoodsAgreementAndCommodityBOS.add(agreementAndCommodityBO);
        }
        preProcessAuditRspBO.setAgreementAndCommodityBOS(uccGoodsAgreementAndCommodityBOS);
        preProcessAuditRspBO.setRespDesc("\u6210\u529f");
        preProcessAuditRspBO.setRespCode("0000");
        return preProcessAuditRspBO;
    }
}

