/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.atom.UccSkuPutCirAtomService;
import com.tydic.commodity.atom.UccSkuStatusUpdatesAtomService;
import com.tydic.commodity.atom.bo.UccSkuPutCirReqBO;
import com.tydic.commodity.atom.bo.UccSkuStatusUpdatesAtomReqBO;
import com.tydic.commodity.bo.busi.CommodityBo;
import com.tydic.commodity.bo.busi.ProcessStepGroupReqBO;
import com.tydic.commodity.bo.busi.ProcessStepGroupRspBO;
import com.tydic.commodity.bo.busi.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.bo.busi.UccZoneGoodsAuditNotifyMessageBO;
import com.tydic.commodity.busi.api.BatchUpdateCommoStatusForMarketService;
import com.tydic.commodity.busi.api.UccApprovalPassService;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPutCirMapper;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.dao.po.UccSkuPutCirPo;
import com.tydic.commodity.enumType.ApprovalTypeEnum;
import com.tydic.commodity.enumType.AuditResultStatusEnum;
import com.tydic.commodity.enumType.SkuStatusEnum;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.external.util.PropertiesUtil;
import com.tydic.commodity.util.DateUtils;
import com.tydic.commodity.validate.ValidatorUtil;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.uac.busi.UacNoTaskAuditOrderAuditBusiService;
import com.tydic.uac.config.ProperticeVo;
import com.tydic.uccext.bo.UccGoodsAgreementAndCommodityBO;
import com.tydic.uccext.bo.UccGoodsUpdateAndPublishReqBO;
import com.tydic.uccext.bo.UccProcessAuditReqBO;
import com.tydic.uccext.bo.UccProcessAuditRspBO;
import com.tydic.uccext.dao.UccExamineEditInfoMapper;
import com.tydic.uccext.service.UccProcessAuditBusiService;
import com.tydic.uccext.service.UccZoneGoodsUpdateApprovalAbilityService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccProcessAuditBusiService"})
public class UccProcessAuditBusiServiceImpl
implements UccProcessAuditBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccProcessAuditBusiServiceImpl.class);
    @Autowired
    private UacNoTaskAuditOrderAuditBusiService uacNoTaskAuditOrderAuditBusiService;
    @Autowired
    private UccApprovalPassService approvalPassService;
    @Autowired
    private UccSkuStatusUpdatesAtomService skuStatusUpdatesAtomService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccZoneGoodsUpdateApprovalAbilityService uccZoneGoodsUpdateApprovalAbilityService;
    @Autowired
    private BatchUpdateCommoStatusForMarketService statusForMarketService;
    @Resource(name="zoneGoodsAuditMQ")
    private ProxyMessageProducer zoneGoodsAuditMQ;
    @Autowired
    private ProperticeVo properticeVo;
    @Autowired
    private UccSkuPutCirAtomService uccSkuPutCirAtomService;
    @Autowired
    private UccSkuPutCirMapper uccSkuPutCirMapper;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccExamineEditInfoMapper uccExamineEditInfoMapper;

    @PostMapping(value={"dealCheckParameters"})
    public UccProcessAuditRspBO dealCheckParameters(@RequestBody UccProcessAuditReqBO reqBO) {
        List skuPos;
        UccProcessAuditRspBO uccProcessAuditRspBO = new UccProcessAuditRspBO();
        try {
            ValidatorUtil.validator((Object)reqBO);
            if (CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
                throw new BusinessException("0000", "\u5355\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        catch (BusinessException e) {
            LOGGER.error("\u8bf7\u6c42\u53c2\u6570\u4e0d\u6b63\u786e,\u539f\u56e0\uff1a" + e.getMsgInfo());
            throw new BusinessException("8888", e.getMsgInfo());
        }
        List supplierShopPos = this.supplierShopMapper.selectSupplierShopBySupplierId(reqBO.getSupplierId());
        if (CollectionUtils.isNotEmpty((Collection)supplierShopPos)) {
            reqBO.setSupplierShopId(((SupplierShopPo)supplierShopPos.get(0)).getSupplierShopId());
        }
        if (CollectionUtils.isEmpty((Collection)(skuPos = this.uccSkuMapper.batchQrySku(reqBO.getSkuIds(), reqBO.getSupplierShopId())))) {
            throw new BusinessException("8888", "\u5ba1\u6279\u5931\u8d25,\u5355\u54c1\u6570\u636e\u4e0d\u5b58\u5728");
        }
        ArrayList<Long> commodityIds = new ArrayList<Long>(skuPos.size());
        for (UccSkuPo po : skuPos) {
            if (!ApprovalTypeEnum.APPROVAL_EDIT.equals((Object)reqBO.getObjType()) && po.getSkuStatus().intValue() != reqBO.getCurrentStatus().intValue()) {
                LOGGER.error("\u5355\u54c1\u7f16\u53f7\u4e3a\uff1a[" + po.getSkuId() + "]\u7684\u5355\u54c1\u7684\u72b6\u6001\u4e0d\u4e3a" + SkuStatusEnum.getStatusDesc((Integer)reqBO.getCurrentStatus()).getStatusDesc() + "");
                throw new BusinessException("8888", "\u6240\u9009\u5355\u54c1[" + po.getSkuId() + "]\uff0c\u72b6\u6001\u4e0d\u4e3a" + SkuStatusEnum.getStatusDesc((Integer)reqBO.getCurrentStatus()).getStatusDesc() + "");
            }
            commodityIds.add(po.getCommodityId());
        }
        uccProcessAuditRspBO.setOnShelveWay(((UccSkuPo)skuPos.get(0)).getOnShelveWay());
        uccProcessAuditRspBO.setCommodityIds(commodityIds);
        uccProcessAuditRspBO.setRespDesc("\u6210\u529f");
        uccProcessAuditRspBO.setRespCode("0000");
        return uccProcessAuditRspBO;
    }

    @PostMapping(value={"processAuditBusiService"})
    public UccProcessAuditRspBO processAuditBusiService(@RequestBody UccProcessAuditReqBO reqBO) {
        UccProcessAuditRspBO processAuditRspBO = new UccProcessAuditRspBO();
        UccProcessAuditRspBO rspBO = null;
        try {
            HashMap<String, String> ext = new HashMap<String, String>(1);
            switch (reqBO.getAuditResult()) {
                case 0: {
                    ext.put("dealStepName", "\u9a73\u56de");
                    reqBO.setSyncAdtFlag(Integer.valueOf(0));
                    rspBO = this.executeAudit(reqBO, ext);
                    break;
                }
                case 1: {
                    ext.put("dealStepName", "\u5ba1\u6838\u901a\u8fc7");
                    reqBO.setSyncAdtFlag(Integer.valueOf(0));
                    rspBO = this.executeAudit(reqBO, ext);
                }
            }
        }
        catch (BusinessException e) {
            throw new BusinessException("8888", e.getMsgInfo());
        }
        processAuditRspBO.setIsFinish(rspBO.getIsFinish());
        processAuditRspBO.setRespCode("0000");
        processAuditRspBO.setRespDesc("\u6210\u529f");
        return processAuditRspBO;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    UccProcessAuditRspBO executeAudit(UccProcessAuditReqBO reqBO, Map<String, String> ext) {
        UccProcessAuditRspBO rspBO = new UccProcessAuditRspBO();
        UccSkuStatusUpdatesAtomReqBO skuStatusUpdatesAtomReqBO = new UccSkuStatusUpdatesAtomReqBO();
        skuStatusUpdatesAtomReqBO.setSkuIds(reqBO.getSkuIds());
        skuStatusUpdatesAtomReqBO.setState(reqBO.getStatus());
        skuStatusUpdatesAtomReqBO.setSyncAdtFlag(reqBO.getSyncAdtFlag());
        skuStatusUpdatesAtomReqBO.setSupplierShopId(reqBO.getSupplierShopId());
        UacNoTaskAuditOrderAuditReqBO uocAuditAbilityAuditReqBO = null;
        ProcessStepGroupReqBO processStepGroupReqBO = new ProcessStepGroupReqBO();
        processStepGroupReqBO.setCommodityIds(reqBO.getCommodityIds());
        ProcessStepGroupRspBO processStepGroupRspBO = this.approvalPassService.processStepGroup(processStepGroupReqBO);
        if (null == processStepGroupRspBO.getCommodityIdMaps() || processStepGroupRspBO.getCommodityIdMaps().size() < 1) {
            throw new BusinessException("8888", "\u5546\u54c1\u7684\u5ba1\u6279\u72b6\u6001\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u64cd\u4f5c");
        }
        if ("8888".equals(processStepGroupRspBO.getRespCode())) {
            LOGGER.error("\u5904\u7406\u53d8\u66f4\u5546\u54c1\u5ba1\u6279\u8282\u70b9\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + processStepGroupRspBO.getRespDesc());
            throw new BusinessException("8888", processStepGroupRspBO.getRespDesc());
        }
        try {
            for (Map.Entry stringListEntry : processStepGroupRspBO.getCommodityIdMaps().entrySet()) {
                uocAuditAbilityAuditReqBO = new UacNoTaskAuditOrderAuditReqBO();
                uocAuditAbilityAuditReqBO.setObjType(Integer.valueOf(reqBO.getObjType().getStep()));
                uocAuditAbilityAuditReqBO.setObjId((List)stringListEntry.getValue());
                uocAuditAbilityAuditReqBO.setStepId((String)stringListEntry.getKey());
                uocAuditAbilityAuditReqBO.setAuditResult(reqBO.getAuditResult());
                uocAuditAbilityAuditReqBO.setOperId(reqBO.getUsername());
                uocAuditAbilityAuditReqBO.setUsername(reqBO.getUsername());
                uocAuditAbilityAuditReqBO.setAuditAdvice(reqBO.getApprovalRemark());
                uocAuditAbilityAuditReqBO.setExt(ext);
                LOGGER.info("\u5ba1\u6838\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)uocAuditAbilityAuditReqBO) + "");
                UacNoTaskAuditOrderAuditRspBO uocAuditAbilityAuditRspBO = this.uacNoTaskAuditOrderAuditBusiService.dealObjectAudit(uocAuditAbilityAuditReqBO);
                LOGGER.info("\u5ba1\u6838\u540c\u6b65\u54cd\u5e94\u6570\u636e\uff1a" + JSON.toJSON((Object)uocAuditAbilityAuditRspBO));
                if ("8888".equals(uocAuditAbilityAuditRspBO.getRespCode())) {
                    throw new BusinessException("8888", uocAuditAbilityAuditRspBO.getRespDesc());
                }
                boolean approvalFlag = ApprovalTypeEnum.APPROVAL_EDIT.code().equals(reqBO.getObjType().code()) && uocAuditAbilityAuditRspBO.getNoneInstanceBO().getFinish() != false && reqBO.getAuditResult() == 1;
                ArrayList<String> auditType = new ArrayList<String>();
                auditType.add(ApprovalTypeEnum.RESTORE_UP_SHELF.code());
                auditType.add(ApprovalTypeEnum.APPROVAL_DOWN_SHELF.code());
                boolean approvalResult = auditType.contains(reqBO.getObjType().code()) && uocAuditAbilityAuditRspBO.getNoneInstanceBO().getFinish() != false && reqBO.getAuditResult() == 1;
                boolean onlyUse = uocAuditAbilityAuditRspBO.getNoneInstanceBO().getFinish() != false && reqBO.getAuditResult() == 1;
                rspBO.setIsFinish(uocAuditAbilityAuditRspBO.getNoneInstanceBO().getFinish());
                UccGoodsUpdateAndPublishReqBO goodsUpdateAndPublishReqBO = new UccGoodsUpdateAndPublishReqBO();
                ArrayList<UccGoodsAgreementAndCommodityBO> uccGoodsAgreementAndCommodityBOS = new ArrayList<UccGoodsAgreementAndCommodityBO>(reqBO.getSkuIds().size());
                UccCommodityPo commodityPo = null;
                ArrayList<String> agreementDetailIds = new ArrayList<String>();
                try {
                    for (int i = 0; i < ((List)stringListEntry.getValue()).size(); ++i) {
                        CommodityBo commodityBo = new CommodityBo();
                        commodityPo = this.uccCommodityMapper.getCommodityById((Long)((List)stringListEntry.getValue()).get(i));
                        agreementDetailIds.add(commodityPo.getAgreementDetailsId());
                        BeanUtils.copyProperties((Object)commodityPo, (Object)commodityBo);
                        commodityBo.setCommodityStatus(null);
                        if (uocAuditAbilityAuditRspBO.getNoneInstanceBO().getFinish().booleanValue()) {
                            commodityBo.setApprovalStatus("0");
                        } else {
                            commodityBo.setApprovalStatus(uocAuditAbilityAuditRspBO.getNoneInstanceBO().getStepId());
                        }
                        this.statusForMarketService.updateCommoApprovalStatus(commodityBo, AuditResultStatusEnum.Audit_Pass);
                    }
                    if (approvalFlag) {
                        for (Object aLong : reqBO.getSkuIds()) {
                            UccGoodsAgreementAndCommodityBO uccGoodsAgreementAndCommodityBO = new UccGoodsAgreementAndCommodityBO();
                            uccGoodsAgreementAndCommodityBO.setSkuId((Long)aLong);
                            uccGoodsAgreementAndCommodityBOS.add(uccGoodsAgreementAndCommodityBO);
                        }
                    }
                    if (approvalFlag) {
                        goodsUpdateAndPublishReqBO.setGoodsAgreementAndCommodityBOS(uccGoodsAgreementAndCommodityBOS);
                        goodsUpdateAndPublishReqBO.setApprovalRemark(reqBO.getApprovalRemark());
                        this.uccZoneGoodsUpdateApprovalAbilityService.writeBackTempoToFormal(goodsUpdateAndPublishReqBO);
                        this.deleteTemp(reqBO.getSkuIds());
                    }
                    if (approvalResult) {
                        List skuIds = reqBO.getSkuIds();
                        try {
                            Object aLong;
                            aLong = skuIds.iterator();
                            while (aLong.hasNext()) {
                                Long skuId = (Long)aLong.next();
                                UccSkuPutCirReqBO uccSkuPutCirReqBO = new UccSkuPutCirReqBO();
                                uccSkuPutCirReqBO.setSkuId(skuId);
                                uccSkuPutCirReqBO.setSupplierShopId(reqBO.getSupplierShopId());
                                if (Objects.equals(ApprovalTypeEnum.RESTORE_UP_SHELF.getStep(), reqBO.getObjType().getStep())) {
                                    uccSkuPutCirReqBO.setUptype(Integer.valueOf(1));
                                    uccSkuPutCirReqBO.setRealUpTime(DateUtils.dateToStr((Date)new Date()));
                                    uccSkuPutCirReqBO.setRemark("\u6062\u590d\u4e0a\u67b6");
                                } else if (Objects.equals(ApprovalTypeEnum.APPROVAL_DOWN_SHELF.getStep(), reqBO.getObjType().getStep())) {
                                    uccSkuPutCirReqBO.setDownType(Integer.valueOf(1));
                                    uccSkuPutCirReqBO.setRealDownTime(DateUtils.dateToStr((Date)new Date()));
                                    uccSkuPutCirReqBO.setRemark("\u624b\u52a8\u4e0b\u67b6");
                                }
                                uccSkuPutCirReqBO.setCreateOperId(reqBO.getUsername());
                                this.uccSkuPutCirAtomService.dealSkuPutCir(uccSkuPutCirReqBO);
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error(e.getMessage());
                            throw new BusinessException("8888", "\u63d2\u5165\u4e0a\u4e0b\u67b6\u5468\u671f\u8868\u5931\u8d25");
                        }
                    }
                    for (int i = 0; i < ((List)stringListEntry.getValue()).size(); ++i) {
                        UccSkuPo skuPo = new UccSkuPo();
                        skuPo.setCommodityId((Long)((List)stringListEntry.getValue()).get(i));
                        List skuPos = this.uccSkuMapper.qerySku(skuPo);
                        if (!CollectionUtils.isNotEmpty((Collection)skuPos)) continue;
                        UccZoneGoodsAuditNotifyMessageBO notifyMessageBO = new UccZoneGoodsAuditNotifyMessageBO();
                        if (uocAuditAbilityAuditRspBO.getNoneInstanceBO().getCustomAttributes() != null && uocAuditAbilityAuditRspBO.getNoneInstanceBO().getCustomAttributes().size() > 0) {
                            for (Map.Entry stringObjectEntry : uocAuditAbilityAuditRspBO.getNoneInstanceBO().getCustomAttributes().entrySet()) {
                                notifyMessageBO.setStationCode((String)stringObjectEntry.getKey());
                            }
                        }
                        UccSkuPo uccSkuPo = (UccSkuPo)skuPos.get(0);
                        if (!uocAuditAbilityAuditRspBO.getNoneInstanceBO().getFinish().booleanValue()) {
                            notifyMessageBO.setAuditStatus("2");
                            notifyMessageBO.setAgreementSkuStatus(String.valueOf(uccSkuPo.getSkuStatus()));
                        } else {
                            notifyMessageBO.setAuditStatus(reqBO.getAuditResult().toString());
                        }
                        notifyMessageBO.setAgreementId(commodityPo.getAgreementId());
                        notifyMessageBO.setAgreementSkuIds((List)Lists.newArrayList((Object[])new String[]{String.valueOf(uccSkuPo.getAgreementDetailsId())}));
                        try {
                            if (reqBO.getAuditResult() == 0) {
                                if (ApprovalTypeEnum.APPROVAL_UP_SHELF == reqBO.getObjType()) {
                                    notifyMessageBO.setAgreementSkuStatus("4");
                                }
                                if (ApprovalTypeEnum.APPROVAL_DOWN_SHELF == reqBO.getObjType()) {
                                    notifyMessageBO.setAgreementSkuStatus("3");
                                }
                            } else if (ApprovalTypeEnum.APPROVAL_UP_SHELF == reqBO.getObjType()) {
                                Integer shelveWay = uccSkuPo.getOnShelveWay();
                                if (0 == shelveWay && uocAuditAbilityAuditRspBO.getNoneInstanceBO().getFinish().booleanValue()) {
                                    notifyMessageBO.setAgreementSkuStatus("2");
                                } else if (1 == shelveWay && uocAuditAbilityAuditRspBO.getNoneInstanceBO().getFinish().booleanValue()) {
                                    notifyMessageBO.setAgreementSkuStatus("3");
                                } else if (2 == shelveWay && uocAuditAbilityAuditRspBO.getNoneInstanceBO().getFinish().booleanValue()) {
                                    UccSkuPutCirPo skuPutCirPo = new UccSkuPutCirPo();
                                    skuPutCirPo.setSkuId(uccSkuPo.getSkuId());
                                    skuPutCirPo.setSupplierShopId(uccSkuPo.getSupplierShopId());
                                    List uccSkuPutCirPos = this.uccSkuPutCirMapper.querySkuPutCir(skuPutCirPo);
                                    if (CollectionUtils.isNotEmpty((Collection)uccSkuPutCirPos)) {
                                        if (null != ((UccSkuPutCirPo)uccSkuPutCirPos.get(0)).getPreUpTime() && DateUtils.compareDate((Date)new Date(), (Date)((UccSkuPutCirPo)uccSkuPutCirPos.get(0)).getPreUpTime()) > 0) {
                                            notifyMessageBO.setAgreementSkuStatus("3");
                                        }
                                    } else {
                                        notifyMessageBO.setAgreementSkuStatus("99");
                                    }
                                }
                            } else if (ApprovalTypeEnum.RESTORE_UP_SHELF == reqBO.getObjType() && uocAuditAbilityAuditRspBO.getNoneInstanceBO().getFinish().booleanValue()) {
                                notifyMessageBO.setAgreementSkuStatus("3");
                            } else if (ApprovalTypeEnum.APPROVAL_DOWN_SHELF == reqBO.getObjType() && uocAuditAbilityAuditRspBO.getNoneInstanceBO().getFinish().booleanValue()) {
                                notifyMessageBO.setAgreementSkuStatus("5");
                            } else if (ApprovalTypeEnum.APPROVAL_EDIT == reqBO.getObjType() && uocAuditAbilityAuditRspBO.getNoneInstanceBO().getFinish().booleanValue()) {
                                notifyMessageBO.setAgreementSkuStatus(String.valueOf(uccSkuPo.getSkuStatus()));
                            }
                            notifyMessageBO.setMemIdIn(reqBO.getUserId());
                            notifyMessageBO.setOperCode(reqBO.getObjType().code());
                            LOGGER.info("\u5ba1\u6279\u53d1\u9001\u534f\u8baeMQ,\u6d88\u606f\u5185\u5bb9:" + JSON.toJSONString((Object)notifyMessageBO));
                            this.zoneGoodsAuditMQ.send(new ProxyMessage(this.properticeVo.getProperty("UCC_AUDIT_NOTIFY_TOPIC"), this.properticeVo.getProperty("UCC_AUDIT_NOTIFY_TAG"), JSONObject.toJSONString((Object)notifyMessageBO)));
                            continue;
                        }
                        catch (Exception var16) {
                            LOGGER.error("\u5ba1\u6838\u6570\u636e\uff0c\u53d1\u9001\u534f\u8baeMQ\u5931\u8d25\uff1a" + var16);
                            throw new BusinessException("8888", "\u5ba1\u6838\u534f\u8bae\u6d88\u606f\u5931\u8d25");
                        }
                    }
                    SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                    syncSceneCommodityToEsReqBO.setSupplierId(reqBO.getSupplierShopId());
                    syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList((Iterable)reqBO.getSkuIds()));
                    if (approvalFlag) {
                        syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                        syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.OPER_ES_ADD_TYPE.intValue());
                        syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                    } else if (ApprovalTypeEnum.APPROVAL_UP_SHELF == reqBO.getObjType()) {
                        syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                        syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.OPER_ES_ADD_TYPE.intValue());
                        syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                    } else {
                        syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS);
                        syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS.intValue());
                        syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                    }
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("\u53d1\u9001\u6d88\u606f\u540c\u6b65es\u5165\u53c2\u5c55\u793a\uff1a" + JSON.toJSONString((Object)syncSceneCommodityToEsReqBO));
                    }
                    try {
                        this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                    }
                    catch (Exception e) {
                        LOGGER.error("\u6062\u590d\u4e0a\u67b6\uff0c\u53d1\u9001es MQ\u5931\u8d25\uff1a" + e);
                        throw new BusinessException("8888", "\u521b\u5efaes\u6d88\u606f\u5931\u8d25");
                    }
                }
                catch (Exception e) {
                    LOGGER.error("\u5904\u7406\u53d8\u66f4\u5546\u54c1\u5ba1\u6279\u8282\u70b9\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e);
                    throw new BusinessException("8888", "\u6d41\u7a0b\u5904\u7406\u5931\u8d25");
                    return rspBO;
                }
            }
        }
        catch (BusinessException e) {
            LOGGER.error("\u5ba1\u6838\u5546\u54c1\uff0c\u5904\u7406\u6d41\u7a0b\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + (Object)((Object)e));
            throw e;
        }
    }

    private void deleteTemp(List<Long> skuIds) {
        if (!CollectionUtils.isEmpty(skuIds)) {
            try {
                this.uccExamineEditInfoMapper.batchDeleteBySku(skuIds);
            }
            catch (Exception e) {
                LOGGER.error("\u5220\u9664\u4e34\u65f6\u8868\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
    }
}

