/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl;

import com.google.common.collect.Lists;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.uccext.bo.UccQueryDownReasonReqBO;
import com.tydic.uccext.bo.UccQueryDownReasonRspBO;
import com.tydic.uccext.service.UccQueryDownReasonBusiService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccQueryDownReasonBusiService"})
public class UccQueryDownReasonBusiServiceImpl
implements UccQueryDownReasonBusiService {
    @Autowired
    private UccCommodityMapper commodityMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;

    @PostMapping(value={"qryReason"})
    public UccQueryDownReasonRspBO qryReason(@RequestBody UccQueryDownReasonReqBO reqBO) {
        UccCommodityPo uccCommodityPo;
        UccQueryDownReasonRspBO rspBO = new UccQueryDownReasonRspBO();
        ArrayList reason = Lists.newArrayList();
        List uccCommodityPos = Lists.newArrayList();
        if (reqBO.getSupplierShopId() != null) {
            uccCommodityPo = new UccCommodityPo();
            uccCommodityPo.setSupplierShopId(reqBO.getSupplierShopId());
            uccCommodityPos = this.commodityMapper.qryCommodity(uccCommodityPo);
            if (CollectionUtils.isEmpty((Collection)uccCommodityPos)) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5931\u8d25");
                return rspBO;
            }
        } else {
            List supplierShopPos = this.supplierShopMapper.selectSupplierShopBySupplierId(reqBO.getSupplierId());
            if (CollectionUtils.isNotEmpty((Collection)supplierShopPos)) {
                for (SupplierShopPo supplierShopPo : supplierShopPos) {
                    uccCommodityPo = new UccCommodityPo();
                    uccCommodityPo.setSupplierShopId(supplierShopPo.getSupplierShopId());
                    List commodityPos = this.commodityMapper.qryCommodity(uccCommodityPo);
                    uccCommodityPos.addAll(commodityPos);
                }
                if (CollectionUtils.isEmpty((Collection)uccCommodityPos)) {
                    rspBO.setRespCode("8888");
                    rspBO.setRespDesc("\u5931\u8d25");
                    return rspBO;
                }
            } else {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5931\u8d25");
                return rspBO;
            }
        }
        List commodityPos = uccCommodityPos.stream().filter(commodityPo -> StringUtils.isNotBlank((String)commodityPo.getRemark())).collect(Collectors.toList());
        Map<String, List<UccCommodityPo>> uccCommodityPoMap = commodityPos.stream().collect(Collectors.groupingBy(UccCommodityPo::getRemark));
        for (Map.Entry<String, List<UccCommodityPo>> stringListEntry : uccCommodityPoMap.entrySet()) {
            reason.add(stringListEntry.getKey());
        }
        rspBO.setReason((List)reason);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

