/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.bo.ability.CommodityPackBO;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.util.MoneyUtils;
import com.tydic.uac.exception.BusinessException;
import com.tydic.uccext.bo.UccGoodsAgreementAndCommodityBO;
import com.tydic.uccext.bo.UccGoodsUpdateAndPublishAbilityRspBO;
import com.tydic.uccext.bo.UccGoodsUpdateAndPublishReqBO;
import com.tydic.uccext.dao.UccExamineEditInfoMapper;
import com.tydic.uccext.dao.po.UccExamineEditInfoPO;
import com.tydic.uccext.service.UccRecordEditDetailsService;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_PROD/1.0.0/com.tydic.uccext.service.UccRecordEditDetailsService"})
public class UccRecordEditDetailsServiceImpl
implements UccRecordEditDetailsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccRecordEditDetailsServiceImpl.class);
    @Autowired
    private UccExamineEditInfoMapper uccExamineEditInfoMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();

    @PostMapping(value={"saveEditRecord"})
    public UccGoodsUpdateAndPublishAbilityRspBO saveEditRecord(@RequestBody UccGoodsUpdateAndPublishReqBO reqBO) {
        UccExamineEditInfoPO po = null;
        try {
            for (UccGoodsAgreementAndCommodityBO goodsAgreementAndCommodityBO : reqBO.getGoodsAgreementAndCommodityBOS()) {
                UccSkuPo skuPo = new UccSkuPo();
                skuPo.setSupplierShopId(reqBO.getSupplierShopId());
                List uccSkuPos = null;
                if (null != goodsAgreementAndCommodityBO.getSkuId()) {
                    skuPo.setSkuId(goodsAgreementAndCommodityBO.getSkuId());
                    uccSkuPos = this.uccSkuMapper.qerySku(skuPo);
                }
                po = new UccExamineEditInfoPO();
                po.setShowPackUnit(reqBO.getShowPackUnit());
                po.setOnShelveWay(reqBO.getOnShelveWay());
                po.setShelveTime(reqBO.getShelveTime());
                po.setId(this.uccBatchSequence.nextId());
                po.setCommodityName(reqBO.getSkuName());
                po.setCommoditySource(reqBO.getSkuSource());
                if (CollectionUtils.isNotEmpty((Collection)reqBO.getLadderPrice())) {
                    po.setLadderPrice(JSON.toJSONString((Object)reqBO.getLadderPrice()));
                }
                if (reqBO.getMarketPrice() != null) {
                    po.setMarketPrice(MoneyUtils.yuanToHao((BigDecimal)reqBO.getMarketPrice()));
                }
                po.setMiniOrderNum(reqBO.getMiniOrderNum());
                po.setCommodityDesc(reqBO.getSkuDesc());
                po.setAgreementDetailsId(goodsAgreementAndCommodityBO.getAgreementDetailsId());
                po.setAgreementId(goodsAgreementAndCommodityBO.getAgreementId());
                if (CollectionUtils.isNotEmpty((Collection)uccSkuPos)) {
                    po.setCommodityId(((UccSkuPo)uccSkuPos.get(0)).getCommodityId());
                    po.setSkuId(((UccSkuPo)uccSkuPos.get(0)).getSkuId());
                    po.setSupplierShopId(((UccSkuPo)uccSkuPos.get(0)).getSupplierShopId());
                }
                if (CollectionUtils.isNotEmpty((Collection)reqBO.getCommodityPackInfo())) {
                    CommodityPackBO commodityPackBO = (CommodityPackBO)reqBO.getCommodityPackInfo().get(0);
                    po.setHeight(commodityPackBO.getHeight());
                    po.setLength(commodityPackBO.getLength());
                    po.setWidth(commodityPackBO.getWidth());
                    po.setWeight(commodityPackBO.getWeight());
                    po.setList(commodityPackBO.getList());
                }
                if (null != reqBO.getShowPackUnit() && 1 == reqBO.getShowPackUnit()) {
                    po.setPackagePurchaseUnitPrice(reqBO.getCommodityPackSpecBO().getPackagePurchaseUitPrice());
                    po.setPackageSaleUnitPrice(reqBO.getCommodityPackSpecBO().getPackageSaleUnitPrice());
                    po.setPackageSpec(reqBO.getCommodityPackSpecBO().getPackageSpec());
                    po.setPurchaseUnitPrice(reqBO.getCommodityPackSpecBO().getPurchaseUnitPrice());
                    po.setSaleUnit(reqBO.getCommodityPackSpecBO().getSaleUnit());
                    po.setSaleUnitPrice(reqBO.getCommodityPackSpecBO().getSaleUnitPrice());
                    po.setSettlementUnit(reqBO.getCommodityPackSpecBO().getSettlementUnit());
                    po.setUnitConversionValue(reqBO.getCommodityPackSpecBO().getUnitConversionValue());
                } else if (null != reqBO.getCommodityPackSpecBO()) {
                    po.setPurchaseUnitPrice(reqBO.getCommodityPackSpecBO().getPurchaseUnitPrice());
                    po.setSaleUnitPrice(reqBO.getCommodityPackSpecBO().getSaleUnitPrice());
                    po.setSettlementUnit(reqBO.getCommodityPackSpecBO().getSettlementUnit());
                }
                if (!CollectionUtils.isNotEmpty((Collection)reqBO.getCommodityPicInfo())) continue;
                po.setCommodityPicInfo(JSON.toJSONString((Object)reqBO.getCommodityPicInfo()));
            }
            po.setCreateTime(new Date());
        }
        catch (Exception e) {
            LOGGER.error("\u89e3\u6790\u4fdd\u5b58\u4e34\u65f6\u6570\u636e\u9519\u8bef,\u539f\u56e0:" + e);
            throw new BusinessException("8888", "\u89e3\u6790\u4fdd\u5b58\u4e34\u65f6\u6570\u636e\u9519\u8bef");
        }
        try {
            this.uccExamineEditInfoMapper.insertSelective(po);
        }
        catch (Exception e) {
            LOGGER.error("\u4fdd\u5b58\u5165\u5e93\u7f16\u8f91\u4e34\u65f6\u8868\u5931\u8d25,\u539f\u56e0:" + e);
            throw new BusinessException("8888", "\u4fdd\u5b58\u5165\u5e93\u7f16\u8f91\u4e34\u65f6\u8868\u5931\u8d25");
        }
        UccGoodsUpdateAndPublishAbilityRspBO rspBO = new UccGoodsUpdateAndPublishAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

