/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.atom.UccCreateUserOperRecordAtomService;
import com.tydic.commodity.atom.bo.UccCreateUserOperRecordAtomReqBO;
import com.tydic.commodity.atom.bo.UccUserOperInfoCreateBO;
import com.tydic.commodity.dao.UccCommodityDetailMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityPackageMapper;
import com.tydic.commodity.dao.UccCommodityPicMapper;
import com.tydic.commodity.dao.UccLadderPriceMapper;
import com.tydic.commodity.dao.UccSkuDetailMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.po.UccCommodityDetailPo;
import com.tydic.commodity.dao.po.UccCommodityPackagePo;
import com.tydic.commodity.dao.po.UccCommodityPicPo;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.dao.po.UccLadderPricePO;
import com.tydic.commodity.dao.po.UccSkuDetailPO;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.dao.po.UccSkuPricePo;
import com.tydic.commodity.enumType.SkuOperTypeEnum;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.util.MoneyUtils;
import com.tydic.uccext.bo.UccUpdateCommodityAbilityReqBO;
import com.tydic.uccext.bo.UccUpdateCommodityAbilityRspBO;
import com.tydic.uccext.constant.UccConstants;
import com.tydic.uccext.dao.StoreSkuSaleNumMapper;
import com.tydic.uccext.dao.UccSceneSkuSubscribeMapper;
import com.tydic.uccext.dao.po.StoreSkuSaleNumPO;
import com.tydic.uccext.dao.po.UccSceneSkuSubscribePO;
import com.tydic.uccext.service.UccUpdateCommodityBusiService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccUpdateCommodityBusiServiceImpl
implements UccUpdateCommodityBusiService {
    private Sequence sequence = Sequence.getInstance();
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccLadderPriceMapper uccLadderPriceMapper;
    @Autowired
    private UccSceneSkuSubscribeMapper uccSceneSkuSubscribeMapper;
    @Autowired
    private UccCommodityPicMapper uccCommodityPicMapper;
    @Autowired
    private UccCommodityDetailMapper uccCommodityDetailMapper;
    @Autowired
    private UccSkuDetailMapper uccSkuDetailMapper;
    @Autowired
    private UccCommodityPackageMapper uccCommodityPackageMapper;
    @Autowired
    private StoreSkuSaleNumMapper storeSkuSaleNumMapper;
    @Autowired
    private UccCreateUserOperRecordAtomService uccCreateUserOperRecordAtomService;

    public UccUpdateCommodityAbilityRspBO updateCommodity(UccUpdateCommodityAbilityReqBO reqBo) {
        UccUpdateCommodityAbilityRspBO rspBo = new UccUpdateCommodityAbilityRspBO();
        this.updateCommodityInfo(reqBo);
        this.updateSkuInfo(reqBo);
        Long skuPriceId = this.updateSkuPriceInfo(reqBo);
        this.updateLadderPrice(reqBo, skuPriceId);
        this.updatePicInfo(reqBo);
        this.updatePackageInfo(reqBo);
        this.updateSceneRelInfo(reqBo);
        this.dealOperRecord(reqBo);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void updateCommodityInfo(UccUpdateCommodityAbilityReqBO reqBo) {
        if (StringUtils.hasText((String)reqBo.getCommodityName()) || StringUtils.hasText((String)reqBo.getCommodityBanner())) {
            UccCommodityPo uccCommodityPo = new UccCommodityPo();
            uccCommodityPo.setCommodityName(reqBo.getCommodityName());
            uccCommodityPo.setCommodityBanner(reqBo.getCommodityBanner());
            uccCommodityPo.setUpdateOperId(reqBo.getUsername());
            uccCommodityPo.setCommodityId(reqBo.getCommodityId());
            this.uccCommodityMapper.updateCommodity(uccCommodityPo);
        }
        if (StringUtils.hasText((String)reqBo.getCommodityPcDetailChar()) || StringUtils.hasText((String)reqBo.getCommodityPcDetailUrl())) {
            UccCommodityDetailPo uccCommodityDetailPo = new UccCommodityDetailPo();
            uccCommodityDetailPo.setCommodityId(reqBo.getCommodityId());
            uccCommodityDetailPo.setCommodityPcDetailChar(reqBo.getCommodityPcDetailChar());
            uccCommodityDetailPo.setCommodityPcDetailUrl(reqBo.getCommodityPcDetailUrl());
            this.uccCommodityDetailMapper.updateCommodity(uccCommodityDetailPo);
        }
    }

    private void updateSkuInfo(UccUpdateCommodityAbilityReqBO reqBo) {
        if (null != reqBo.getCommodityPackageSpec() || null != reqBo.getLimitCount() || null != reqBo.getIsShowSaleUnit() || null != reqBo.getMaxoq() || null != reqBo.getMoq()) {
            UccSkuPo skuPo;
            UccSkuPo uccSkuPo = new UccSkuPo();
            uccSkuPo.setSkuId(reqBo.getCommodityId());
            List skuPoList = this.uccSkuMapper.qerySku(uccSkuPo);
            uccSkuPo.setSkuName(reqBo.getCommodityName());
            uccSkuPo.setSkuLongName(reqBo.getCommodityName());
            uccSkuPo.setCommodityId(reqBo.getCommodityId());
            uccSkuPo.setMaxoq(null == reqBo.getMaxoq() ? null : BigDecimal.valueOf(reqBo.getMaxoq().intValue()));
            uccSkuPo.setLimitCount(null == reqBo.getLimitCount() ? null : BigDecimal.valueOf(reqBo.getLimitCount().intValue()));
            uccSkuPo.setSalesUnitRate(null == reqBo.getCommodityPackageSpec() ? null : reqBo.getCommodityPackageSpec().getUnitRate());
            uccSkuPo.setIsShopSalesUnit(reqBo.getIsShowSaleUnit());
            uccSkuPo.setMoq(null == reqBo.getMoq() ? null : BigDecimal.valueOf(reqBo.getMoq().intValue()));
            uccSkuPo.setPackageSpec(null == reqBo.getCommodityPackageSpec() ? null : reqBo.getCommodityPackageSpec().getPackageSpec());
            uccSkuPo.setSettlementUnit(null == reqBo.getCommodityPackageSpec() ? null : reqBo.getCommodityPackageSpec().getSettleUnit());
            uccSkuPo.setUpdateOperId(reqBo.getUsername());
            this.uccSkuMapper.modifySku(uccSkuPo);
            if (null != reqBo.getLimitCount() && 0 >= reqBo.getLimitCount()) {
                StoreSkuSaleNumPO storeSkuSaleNumPo = new StoreSkuSaleNumPO();
                storeSkuSaleNumPo.setSkuId(reqBo.getCommodityId());
                this.storeSkuSaleNumMapper.deleteBy(storeSkuSaleNumPo);
            }
            if (!(CollectionUtils.isEmpty((Collection)skuPoList) || null != (skuPo = (UccSkuPo)skuPoList.get(0)).getLimitCount() && BigDecimal.ZERO.compareTo(skuPo.getLimitCount()) < 0 || null == reqBo.getLimitCount() || 0 >= reqBo.getLimitCount())) {
                StoreSkuSaleNumPO storeSkuSaleNumPo = new StoreSkuSaleNumPO();
                storeSkuSaleNumPo.setSkuId(reqBo.getCommodityId());
                this.storeSkuSaleNumMapper.deleteBy(storeSkuSaleNumPo);
            }
        }
        if (StringUtils.hasText((String)reqBo.getCommodityPcDetailChar()) || StringUtils.hasText((String)reqBo.getCommodityPcDetailUrl())) {
            UccSkuDetailPO uccSkuDetailPo = new UccSkuDetailPO();
            uccSkuDetailPo.setSkuId(reqBo.getCommodityId());
            uccSkuDetailPo.setCommodityId(reqBo.getCommodityId());
            uccSkuDetailPo.setSkuPcDetailUrl(reqBo.getCommodityPcDetailUrl());
            uccSkuDetailPo.setSkuPcDetailChar(reqBo.getCommodityPcDetailChar());
            this.uccSkuDetailMapper.modifySkuDetail(uccSkuDetailPo);
        }
    }

    private Long updateSkuPriceInfo(UccUpdateCommodityAbilityReqBO reqBo) {
        UccSkuPricePo uccSkuPricePo = new UccSkuPricePo();
        uccSkuPricePo.setSkuId(reqBo.getCommodityId());
        UccSkuPricePo skuPricePo = this.uccSkuPriceMapper.querySkuPrice(uccSkuPricePo);
        if (null != reqBo.getSalePrice() || null != reqBo.getCommodityPackageSpec() || null != reqBo.getIsShowSaleUnit()) {
            UccSkuPricePo pricePo = new UccSkuPricePo();
            pricePo.setSkuPriceId(skuPricePo.getSkuPriceId());
            pricePo.setSkuId(reqBo.getCommodityId());
            if (0 != reqBo.getIsShowSaleUnit() && null != reqBo.getCommodityPackageSpec()) {
                pricePo.setAgreementPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)reqBo.getCommodityPackageSpec().getAgreementPrice())));
                pricePo.setSalePrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)reqBo.getCommodityPackageSpec().getSalePrice())));
            } else {
                pricePo.setAgreementPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)reqBo.getSalePrice())));
                pricePo.setSalePrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)reqBo.getSalePrice())));
            }
            pricePo.setUpdateOperId(reqBo.getUsername());
            this.uccSkuPriceMapper.updateSkuPrice(pricePo);
        }
        return skuPricePo.getSkuPriceId();
    }

    private void updateLadderPrice(UccUpdateCommodityAbilityReqBO reqBo, Long skuPriceId) {
        UccLadderPricePO ladderPricePo = new UccLadderPricePO();
        ladderPricePo.setSkuId(reqBo.getCommodityId());
        ladderPricePo.setSkuPriceId(skuPriceId);
        this.uccLadderPriceMapper.deleteByExample(ladderPricePo);
        if (!CollectionUtils.isEmpty((Collection)reqBo.getLadderPrice())) {
            ArrayList ladderPricePoList = new ArrayList();
            reqBo.getLadderPrice().forEach(ladder -> {
                UccLadderPricePO uccLadderPricePo = new UccLadderPricePO();
                uccLadderPricePo.setId(Long.valueOf(this.sequence.nextId()));
                uccLadderPricePo.setSupplierShopId(UccConstants.ATOUR_SUPPLIER_SHOP_ID);
                uccLadderPricePo.setSkuPriceId(skuPriceId);
                uccLadderPricePo.setSkuId(reqBo.getCommodityId());
                uccLadderPricePo.setStart(ladder.getStart());
                uccLadderPricePo.setStop((Long)(null != ladder.getStop() && 0L >= ladder.getStop() ? null : ladder.getStop()));
                uccLadderPricePo.setPrice(Long.valueOf(MoneyUtils.yuanToHaoToLong((BigDecimal)ladder.getPrice())));
                uccLadderPricePo.setDiscount(ladder.getDiscount());
                ladderPricePoList.add(uccLadderPricePo);
            });
            if (!CollectionUtils.isEmpty(ladderPricePoList)) {
                this.uccLadderPriceMapper.batchInsert(ladderPricePoList);
            }
        }
    }

    private void updatePicInfo(UccUpdateCommodityAbilityReqBO reqBo) {
        if (!CollectionUtils.isEmpty((Collection)reqBo.getCommdImages())) {
            this.uccCommodityPicMapper.deleteByCommodityId(reqBo.getCommodityId(), UccConstants.ATOUR_SUPPLIER_SHOP_ID);
            ArrayList uccCommodityPicPoList = new ArrayList();
            reqBo.getCommdImages().forEach(pic -> {
                UccCommodityPicPo uccCommodityPicPo = new UccCommodityPicPo();
                uccCommodityPicPo.setCommodityPicId(Long.valueOf(this.sequence.nextId()));
                uccCommodityPicPo.setCommodityId(reqBo.getCommodityId());
                uccCommodityPicPo.setCommodityPicType(pic.getPicType());
                uccCommodityPicPo.setCommodityPicUrl(pic.getPicUrl());
                uccCommodityPicPo.setCreateOperId(reqBo.getUsername());
                uccCommodityPicPo.setCreateTime(new Date());
                uccCommodityPicPo.setSupplierShopId(UccConstants.ATOUR_SUPPLIER_SHOP_ID);
                uccCommodityPicPo.setPicOrder(pic.getPicOrder());
                uccCommodityPicPoList.add(uccCommodityPicPo);
            });
            if (!CollectionUtils.isEmpty(uccCommodityPicPoList)) {
                this.uccCommodityPicMapper.batchInsert(uccCommodityPicPoList);
            }
        }
    }

    private void updatePackageInfo(UccUpdateCommodityAbilityReqBO reqBo) {
        if (StringUtils.hasText((String)reqBo.getAfterService()) || StringUtils.hasText((String)reqBo.getPackParam())) {
            UccCommodityPackagePo uccCommodityPackagePo = new UccCommodityPackagePo();
            uccCommodityPackagePo.setCommodityId(reqBo.getCommodityId());
            uccCommodityPackagePo.setAfterService(reqBo.getAfterService());
            uccCommodityPackagePo.setPackParam(reqBo.getPackParam());
            uccCommodityPackagePo.setUpdateOperId(reqBo.getUsername());
            this.uccCommodityPackageMapper.updateBy(uccCommodityPackagePo);
        }
    }

    private void updateSceneRelInfo(UccUpdateCommodityAbilityReqBO reqBo) {
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSceneIds())) {
            UccSceneSkuSubscribePO sceneSkuSubscribePo = new UccSceneSkuSubscribePO();
            sceneSkuSubscribePo.setSkuId(reqBo.getCommodityId());
            this.uccSceneSkuSubscribeMapper.deleteBy(sceneSkuSubscribePo);
            ArrayList<UccSceneSkuSubscribePO> sceneSkuSubscribePoList = new ArrayList<UccSceneSkuSubscribePO>();
            reqBo.getSceneIds().forEach(sceneId -> {
                UccSceneSkuSubscribePO uccSceneSkuSubscribePo = new UccSceneSkuSubscribePO();
                uccSceneSkuSubscribePo.setId(this.sequence.nextId());
                uccSceneSkuSubscribePo.setSceneId((Long)sceneId);
                uccSceneSkuSubscribePo.setCommodityId(reqBo.getCommodityId());
                uccSceneSkuSubscribePo.setSubscribeType(0L);
                uccSceneSkuSubscribePo.setSkuId(reqBo.getCommodityId());
                uccSceneSkuSubscribePo.setStatus(UccConstants.Status.VALID.longValue());
                uccSceneSkuSubscribePo.setCreateOperId(reqBo.getUsername());
                uccSceneSkuSubscribePo.setCreateTime(new Date());
                sceneSkuSubscribePoList.add(uccSceneSkuSubscribePo);
            });
            if (CollectionUtils.isEmpty(sceneSkuSubscribePoList)) {
                throw new BusinessException("8888", "\u7ec4\u88c5\u9152\u5e97\u54c1\u724c\u5173\u8054\u4fe1\u606f\u5f02\u5e38");
            }
            this.uccSceneSkuSubscribeMapper.insertBatch(sceneSkuSubscribePoList);
        }
    }

    private void dealOperRecord(UccUpdateCommodityAbilityReqBO reqBo) {
        UccCreateUserOperRecordAtomReqBO uccCreateUserOperRecordAtomReqBo = new UccCreateUserOperRecordAtomReqBO();
        ArrayList<UccUserOperInfoCreateBO> userOperInfoCreateBoList = new ArrayList<UccUserOperInfoCreateBO>();
        UccUserOperInfoCreateBO uccUserOperInfoCreateBo = new UccUserOperInfoCreateBO();
        uccUserOperInfoCreateBo.setCreateOper(reqBo.getUsername());
        uccUserOperInfoCreateBo.setCreateTime(new Date());
        uccUserOperInfoCreateBo.setOperType(SkuOperTypeEnum.UPDATE_SKU.getOperType());
        uccUserOperInfoCreateBo.setCommodityId(reqBo.getCommodityId());
        uccUserOperInfoCreateBo.setSkuId(reqBo.getCommodityId());
        userOperInfoCreateBoList.add(uccUserOperInfoCreateBo);
        uccCreateUserOperRecordAtomReqBo.setUserOperInfoList(userOperInfoCreateBoList);
        this.uccCreateUserOperRecordAtomService.createUserOperRecord(uccCreateUserOperRecordAtomReqBo);
    }
}

