/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.atom.UccCreateUserOperRecordAtomService;
import com.tydic.commodity.atom.bo.UccCreateUserOperRecordAtomReqBO;
import com.tydic.commodity.atom.bo.UccUserOperInfoCreateBO;
import com.tydic.commodity.enumType.SkuOperTypeEnum;
import com.tydic.uccext.bo.UccSceneRelBO;
import com.tydic.uccext.bo.UccUpdateCommoditySceneRelAbilityReqBO;
import com.tydic.uccext.bo.UccUpdateCommoditySceneRelAbilityRspBO;
import com.tydic.uccext.constant.UccConstants;
import com.tydic.uccext.dao.UccSceneSkuSubscribeMapper;
import com.tydic.uccext.dao.po.UccSceneSkuSubscribePO;
import com.tydic.uccext.service.UccUpdateCommoditySceneRelBusiService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccUpdateCommoditySceneRelBusiServiceImpl
implements UccUpdateCommoditySceneRelBusiService {
    @Autowired
    private UccSceneSkuSubscribeMapper uccSceneSkuSubscribeMapper;
    @Autowired
    private UccCreateUserOperRecordAtomService uccCreateUserOperRecordAtomService;
    private Sequence sequence = Sequence.getInstance();

    public UccUpdateCommoditySceneRelAbilityRspBO updateCommoditySceneRel(UccUpdateCommoditySceneRelAbilityReqBO reqBo) {
        UccUpdateCommoditySceneRelAbilityRspBO rspBo = new UccUpdateCommoditySceneRelAbilityRspBO();
        Integer operTypeCancel = 0;
        Integer operTypeCreate = 1;
        Map<Integer, List<UccSceneRelBO>> collect = reqBo.getSceneRelList().stream().collect(Collectors.groupingBy(UccSceneRelBO::getOperType));
        this.deleteSceneRel(collect.get(operTypeCancel), reqBo.getCommodityId());
        this.createSceneRel(collect.get(operTypeCreate), reqBo.getCommodityId(), reqBo.getUsername());
        this.dealOperRecord(reqBo);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void deleteSceneRel(List<UccSceneRelBO> uccSceneRelList, Long commodityId) {
        List<Long> sceneIdList;
        if (!CollectionUtils.isEmpty(uccSceneRelList) && !CollectionUtils.isEmpty(sceneIdList = uccSceneRelList.stream().map(UccSceneRelBO::getSceneId).collect(Collectors.toList()))) {
            UccSceneSkuSubscribePO uccSceneSkuSubscribePo = new UccSceneSkuSubscribePO();
            uccSceneSkuSubscribePo.setCommodityId(commodityId);
            uccSceneSkuSubscribePo.setSkuId(commodityId);
            this.uccSceneSkuSubscribeMapper.deleteBySceneIdList(uccSceneSkuSubscribePo, sceneIdList);
        }
    }

    private void createSceneRel(List<UccSceneRelBO> uccSceneRelList, Long commodityId, String username) {
        if (!CollectionUtils.isEmpty(uccSceneRelList)) {
            UccSceneSkuSubscribePO sceneSkuSubscribePo = new UccSceneSkuSubscribePO();
            sceneSkuSubscribePo.setSkuId(commodityId);
            sceneSkuSubscribePo.setStatus(UccConstants.Status.VALID.longValue());
            List<UccSceneSkuSubscribePO> sceneSkuSubscribeList = this.uccSceneSkuSubscribeMapper.getList(sceneSkuSubscribePo);
            List relSceneIdList = sceneSkuSubscribeList.stream().map(UccSceneSkuSubscribePO::getSceneId).collect(Collectors.toList());
            List<Long> sceneIdList = uccSceneRelList.stream().map(UccSceneRelBO::getSceneId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(sceneIdList)) {
                ArrayList<UccSceneSkuSubscribePO> uccSceneSkuSubscribePoList = new ArrayList<UccSceneSkuSubscribePO>();
                sceneIdList.forEach(sceneId -> {
                    if (!relSceneIdList.contains(sceneId)) {
                        UccSceneSkuSubscribePO uccSceneSkuSubscribePo = new UccSceneSkuSubscribePO();
                        uccSceneSkuSubscribePo.setId(this.sequence.nextId());
                        uccSceneSkuSubscribePo.setSceneId((Long)sceneId);
                        uccSceneSkuSubscribePo.setCommodityId(commodityId);
                        uccSceneSkuSubscribePo.setSubscribeType(0L);
                        uccSceneSkuSubscribePo.setSkuId(commodityId);
                        uccSceneSkuSubscribePo.setStatus(UccConstants.Status.VALID.longValue());
                        uccSceneSkuSubscribePo.setCreateOperId(username);
                        uccSceneSkuSubscribePo.setCreateTime(new Date());
                        uccSceneSkuSubscribePoList.add(uccSceneSkuSubscribePo);
                    }
                });
                if (!CollectionUtils.isEmpty(uccSceneSkuSubscribePoList)) {
                    this.uccSceneSkuSubscribeMapper.insertBatch(uccSceneSkuSubscribePoList);
                }
            }
        }
    }

    private void dealOperRecord(UccUpdateCommoditySceneRelAbilityReqBO reqBo) {
        UccCreateUserOperRecordAtomReqBO uccCreateUserOperRecordAtomReqBo = new UccCreateUserOperRecordAtomReqBO();
        ArrayList<UccUserOperInfoCreateBO> userOperInfoCreateBoList = new ArrayList<UccUserOperInfoCreateBO>();
        UccUserOperInfoCreateBO uccUserOperInfoCreateBo = new UccUserOperInfoCreateBO();
        uccUserOperInfoCreateBo.setCreateOper(reqBo.getUsername());
        uccUserOperInfoCreateBo.setCreateTime(new Date());
        uccUserOperInfoCreateBo.setOperType(SkuOperTypeEnum.UPDATE_SKU_SCENE.getOperType());
        uccUserOperInfoCreateBo.setCommodityId(reqBo.getCommodityId());
        uccUserOperInfoCreateBo.setSkuId(reqBo.getCommodityId());
        userOperInfoCreateBoList.add(uccUserOperInfoCreateBo);
        uccCreateUserOperRecordAtomReqBo.setUserOperInfoList(userOperInfoCreateBoList);
        this.uccCreateUserOperRecordAtomService.createUserOperRecord(uccCreateUserOperRecordAtomReqBo);
    }
}

