/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.uccext.bo.UccUpdateGiftAbilityReqBO;
import com.tydic.uccext.bo.UccUpdateGiftAbilityRspBO;
import com.tydic.uccext.constant.UccConstants;
import com.tydic.uccext.dao.UccGiftsMapper;
import com.tydic.uccext.dao.UccGiftsPicMapper;
import com.tydic.uccext.dao.po.UccGiftsPO;
import com.tydic.uccext.dao.po.UccGiftsPicPO;
import com.tydic.uccext.service.UccUpdateGiftBusiService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccUpdateGiftBusiServiceImpl
implements UccUpdateGiftBusiService {
    @Autowired
    private UccGiftsMapper uccGiftsMapper;
    @Autowired
    private UccGiftsPicMapper uccGiftsPicMapper;
    private Sequence sequence = Sequence.getInstance();

    public UccUpdateGiftAbilityRspBO updateGift(UccUpdateGiftAbilityReqBO reqBo) {
        UccGiftsPO uccGiftsPo = this.doCheckExistGift(reqBo);
        this.doCheckDuplicateCode(reqBo.getGiftCode(), uccGiftsPo.getGiftCode());
        this.doModifyGift(reqBo);
        this.doInsertGifsPic(reqBo);
        UccUpdateGiftAbilityRspBO rspBo = new UccUpdateGiftAbilityRspBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void doModifyGift(UccUpdateGiftAbilityReqBO reqBo) {
        UccGiftsPO set = new UccGiftsPO();
        BeanUtils.copyProperties((Object)reqBo, (Object)set);
        set.setUpdateOperId(reqBo.getName());
        set.setUpdateTime(new Date());
        set.setGiftId(null);
        UccGiftsPO where = new UccGiftsPO();
        where.setGiftId(reqBo.getGiftId());
        this.uccGiftsMapper.updateBy(set, where);
    }

    private UccGiftsPO doCheckExistGift(UccUpdateGiftAbilityReqBO reqBo) {
        UccGiftsPO uccGiftsPo = new UccGiftsPO();
        uccGiftsPo.setGiftId(reqBo.getGiftId());
        uccGiftsPo.setGiftStatus(UccConstants.Status.VALID);
        uccGiftsPo = this.uccGiftsMapper.getModelBy(uccGiftsPo);
        if (uccGiftsPo == null) {
            throw new BusinessException("8888", "\u8d60\u54c1\u4e0d\u5b58\u5728\uff01");
        }
        return uccGiftsPo;
    }

    private void doCheckDuplicateCode(String newGiftCode, String oldGiftCode1) {
        if (StringUtils.hasText((String)newGiftCode) && !newGiftCode.equals(oldGiftCode1)) {
            UccGiftsPO qryExistPo = new UccGiftsPO();
            qryExistPo.setGiftCode(newGiftCode);
            List<UccGiftsPO> list = this.uccGiftsMapper.getList(qryExistPo);
            if (!CollectionUtils.isEmpty(list)) {
                throw new BusinessException("8888", "\u6240\u8f93\u5165\u7684\u8d60\u54c1\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u6362\u4e00\u4e2a\u518d\u8bd5\uff01");
            }
        }
    }

    private void doInsertGifsPic(UccUpdateGiftAbilityReqBO reqBo) {
        if (CollectionUtils.isEmpty((Collection)reqBo.getGiftPics())) {
            return;
        }
        UccGiftsPicPO picDelPO = new UccGiftsPicPO();
        picDelPO.setGiftId(reqBo.getGiftId());
        this.uccGiftsPicMapper.deleteBy(picDelPO);
        ArrayList<UccGiftsPicPO> list = new ArrayList<UccGiftsPicPO>(reqBo.getGiftPics().size());
        reqBo.getGiftPics().forEach(pic -> {
            UccGiftsPicPO uccGiftsPicPO = new UccGiftsPicPO();
            BeanUtils.copyProperties((Object)pic, (Object)uccGiftsPicPO);
            if (pic.getGiftPicType() == null) {
                uccGiftsPicPO.setGiftPicType(1);
            }
            if (pic.getGiftPicOrder() == null) {
                uccGiftsPicPO.setPicOrder(0);
            }
            uccGiftsPicPO.setUpdateOperId(reqBo.getUsername());
            uccGiftsPicPO.setGiftId(reqBo.getGiftId());
            uccGiftsPicPO.setCreateOperId(reqBo.getUsername());
            uccGiftsPicPO.setGiftPicId(this.sequence.nextId());
            uccGiftsPicPO.setCreateTime(new Date());
            uccGiftsPicPO.setUpdateTime(new Date());
            list.add(uccGiftsPicPO);
        });
        this.uccGiftsPicMapper.insertBatch(list);
    }
}

