/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl;

import com.tydic.uccext.bo.StoreSkuSaleNumBO;
import com.tydic.uccext.bo.UccUpdateStoreSkuSaleNumAbilityReqBO;
import com.tydic.uccext.bo.UccUpdateStoreSkuSaleNumAbilityRspBO;
import com.tydic.uccext.dao.StoreSkuSaleNumMapper;
import com.tydic.uccext.dao.po.StoreSkuSaleNumPO;
import com.tydic.uccext.service.UccUpdateStoreSkuSaleNumBusiService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccUpdateStoreSkuSaleNumBusiServiceImpl
implements UccUpdateStoreSkuSaleNumBusiService {
    @Autowired
    private StoreSkuSaleNumMapper storeSkuSaleNumMapper;

    public UccUpdateStoreSkuSaleNumAbilityRspBO updateStoreSkuSaleNum(UccUpdateStoreSkuSaleNumAbilityReqBO reqBo) {
        UccUpdateStoreSkuSaleNumAbilityRspBO rspBo = new UccUpdateStoreSkuSaleNumAbilityRspBO();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSkuSaleNumList())) {
            List<Long> skuIdList = reqBo.getSkuSaleNumList().stream().map(StoreSkuSaleNumBO::getSkuId).distinct().collect(Collectors.toList());
            List<StoreSkuSaleNumPO> listSaleNum = null;
            if (!CollectionUtils.isEmpty(skuIdList)) {
                listSaleNum = this.storeSkuSaleNumMapper.getListBySku(skuIdList, reqBo.getStoreId());
            }
            if (CollectionUtils.isEmpty(listSaleNum)) {
                this.dealBatchInsert(reqBo.getStoreId(), reqBo.getSkuSaleNumList());
            } else {
                ArrayList<StoreSkuSaleNumBO> insertList = new ArrayList<StoreSkuSaleNumBO>();
                ArrayList<StoreSkuSaleNumBO> updateList = new ArrayList<StoreSkuSaleNumBO>();
                for (StoreSkuSaleNumBO skuSaleNum : reqBo.getSkuSaleNumList()) {
                    boolean isNotExist = true;
                    for (StoreSkuSaleNumPO po : listSaleNum) {
                        if (!skuSaleNum.getSkuId().equals(po.getSkuId())) continue;
                        isNotExist = false;
                        updateList.add(skuSaleNum);
                        break;
                    }
                    if (!isNotExist) continue;
                    insertList.add(skuSaleNum);
                }
                if (!CollectionUtils.isEmpty(insertList)) {
                    this.dealBatchInsert(reqBo.getStoreId(), insertList);
                }
                if (!CollectionUtils.isEmpty(updateList)) {
                    this.storeSkuSaleNumMapper.batchUpdateBySku(updateList, reqBo.getStoreId());
                }
            }
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void dealBatchInsert(String storeId, List<StoreSkuSaleNumBO> skuSaleNumList) {
        ArrayList<StoreSkuSaleNumPO> insertList = new ArrayList<StoreSkuSaleNumPO>();
        skuSaleNumList.forEach(skuSaleNum -> {
            StoreSkuSaleNumPO insertStoreSkuSaleNumPo = new StoreSkuSaleNumPO();
            insertStoreSkuSaleNumPo.setSkuId(skuSaleNum.getSkuId());
            insertStoreSkuSaleNumPo.setStoreId(storeId);
            insertStoreSkuSaleNumPo.setSaleNum(skuSaleNum.getSaleNum());
            insertList.add(insertStoreSkuSaleNumPo);
        });
        if (!CollectionUtils.isEmpty(insertList)) {
            this.storeSkuSaleNumMapper.insertBatch(insertList);
        }
    }
}

