/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl.supply;

import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.enumType.SkuStatusEnum;
import com.tydic.uccext.bo.supply.UccCancelAllSupplyAbilityReqBO;
import com.tydic.uccext.bo.supply.UccCancelAllSupplyAbilityRspBO;
import com.tydic.uccext.dao.UccRelSkuSupskuMapper;
import com.tydic.uccext.dao.UccSupplyInfoMapper;
import com.tydic.uccext.dao.po.UccRelSkuSupskuPO;
import com.tydic.uccext.service.supply.UccCancelAllSupplyBusiService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccCancelAllSupplyBusiServiceImpl
implements UccCancelAllSupplyBusiService {
    @Autowired
    private UccRelSkuSupskuMapper uccRelSkuSupskuMapper;
    @Autowired
    private UccSupplyInfoMapper uccSupplyInfoMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    public UccCancelAllSupplyAbilityRspBO cancelAllSupply(UccCancelAllSupplyAbilityReqBO reqBo) {
        UccCancelAllSupplyAbilityRspBO rspBo = new UccCancelAllSupplyAbilityRspBO();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSupplierIdList())) {
            ArrayList<Long> supplySkuList = new ArrayList<Long>();
            List<UccRelSkuSupskuPO> listBySkuIds = this.uccRelSkuSupskuMapper.getBySuppliers(reqBo.getSupplierIdList());
            if (!CollectionUtils.isEmpty(listBySkuIds)) {
                supplySkuList.addAll(listBySkuIds.stream().map(UccRelSkuSupskuPO::getSupplySkuId).collect(Collectors.toList()));
                rspBo.setCommodityIdList(listBySkuIds.stream().map(UccRelSkuSupskuPO::getSkuId).distinct().collect(Collectors.toList()));
            }
            if (!CollectionUtils.isEmpty(supplySkuList)) {
                this.uccRelSkuSupskuMapper.batchDeleteBy(supplySkuList);
                this.uccSupplyInfoMapper.batchDeleteBySupsku(supplySkuList);
                List commodityIdList = rspBo.getCommodityIdList();
                List uccSkuPos = this.uccSkuMapper.qeryBatchSkus(commodityIdList);
                List<Long> skuList = uccSkuPos.stream().filter(sku -> SkuStatusEnum.ON_SHELVES_STATUS.getStatus().equals(sku.getSkuStatus())).map(UccSkuPo::getSkuId).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(skuList)) {
                    List<Long> relSkuIds = this.uccRelSkuSupskuMapper.getRelSkuBySkus(skuList);
                    ArrayList skuIds = new ArrayList();
                    if (!CollectionUtils.isEmpty(relSkuIds)) {
                        commodityIdList.forEach(comId -> {
                            if (!relSkuIds.contains(comId)) {
                                skuIds.add(comId);
                            }
                        });
                    } else {
                        skuIds.addAll(commodityIdList);
                    }
                    if (!CollectionUtils.isEmpty(skuIds)) {
                        UccSkuPo uccSkuPo = new UccSkuPo();
                        uccSkuPo.setSkuStatus(SkuStatusEnum.PENDING_SHELF_STATUS.getStatus());
                        this.uccSkuMapper.batchUpdateById(skuIds, uccSkuPo);
                    }
                }
            }
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

