/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl.supply;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.enumType.SkuStatusEnum;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.util.MoneyUtils;
import com.tydic.uccext.bo.supply.UccCommoditySyncSupplierInfoBO;
import com.tydic.uccext.bo.supply.UccDealCommoditySupplierSyncAbilityReqBO;
import com.tydic.uccext.bo.supply.UccDealCommoditySupplierSyncAbilityRspBO;
import com.tydic.uccext.dao.UccRelSkuSupskuMapper;
import com.tydic.uccext.dao.UccSupplyInfoMapper;
import com.tydic.uccext.dao.po.UccRelSkuSupskuPO;
import com.tydic.uccext.dao.po.UccSupplyInfoPO;
import com.tydic.uccext.service.supply.UccDealCommoditySupplierSyncBusiService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccDealCommoditySupplierSyncBusiServiceImpl
implements UccDealCommoditySupplierSyncBusiService {
    @Autowired
    private UccRelSkuSupskuMapper uccRelSkuSupskuMapper;
    @Autowired
    private UccSupplyInfoMapper uccSupplyInfoMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    private Sequence sequence = Sequence.getInstance();

    public UccDealCommoditySupplierSyncAbilityRspBO dealCommoditySupplierSync(UccDealCommoditySupplierSyncAbilityReqBO reqBo) {
        UccDealCommoditySupplierSyncAbilityRspBO rspBo = new UccDealCommoditySupplierSyncAbilityRspBO();
        Map<Integer, List<UccCommoditySyncSupplierInfoBO>> collectByOperType = reqBo.getSyncInfoList().stream().collect(Collectors.groupingBy(UccCommoditySyncSupplierInfoBO::getOperType));
        Integer operTypeCreate = 0;
        Integer operTypeCancel = 1;
        this.dealCancel(collectByOperType.get(operTypeCancel));
        this.dealCreate(collectByOperType.get(operTypeCreate));
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void dealCancel(List<UccCommoditySyncSupplierInfoBO> syncSupplierInfo) {
        Map<String, List<UccCommoditySyncSupplierInfoBO>> collectBySupplierId;
        if (!CollectionUtils.isEmpty(syncSupplierInfo) && !CollectionUtils.isEmpty(collectBySupplierId = syncSupplierInfo.stream().collect(Collectors.groupingBy(UccCommoditySyncSupplierInfoBO::getSupplierId)))) {
            ArrayList<Long> supplySkuList = new ArrayList<Long>();
            collectBySupplierId.forEach((supplierId, infoList) -> {
                List<Long> commodityIdList = infoList.stream().map(UccCommoditySyncSupplierInfoBO::getCommodityId).collect(Collectors.toList());
                List<UccRelSkuSupskuPO> listBySkuIds = this.uccRelSkuSupskuMapper.getListBySkuIds(commodityIdList, (String)supplierId);
                if (!CollectionUtils.isEmpty(listBySkuIds)) {
                    supplySkuList.addAll(listBySkuIds.stream().map(UccRelSkuSupskuPO::getSupplySkuId).collect(Collectors.toList()));
                }
            });
            if (!CollectionUtils.isEmpty(supplySkuList)) {
                this.uccRelSkuSupskuMapper.batchDeleteBy(supplySkuList);
                this.uccSupplyInfoMapper.batchDeleteBySupsku(supplySkuList);
                collectBySupplierId.forEach((supplierId, infoList) -> {
                    List<Long> commodityIdList = infoList.stream().map(UccCommoditySyncSupplierInfoBO::getCommodityId).collect(Collectors.toList());
                    List uccSkuPos = this.uccSkuMapper.qeryBatchSkus(commodityIdList);
                    List<Long> skuList = uccSkuPos.stream().filter(sku -> SkuStatusEnum.ON_SHELVES_STATUS.getStatus().equals(sku.getSkuStatus())).map(UccSkuPo::getSkuId).collect(Collectors.toList());
                    if (!CollectionUtils.isEmpty(skuList)) {
                        List<Long> relSkuIds = this.uccRelSkuSupskuMapper.getRelSkuBySkus(skuList);
                        ArrayList<Long> skuIds = new ArrayList<Long>();
                        if (!CollectionUtils.isEmpty(relSkuIds)) {
                            commodityIdList.forEach(comId -> {
                                if (!relSkuIds.contains(comId)) {
                                    skuIds.add((Long)comId);
                                }
                            });
                        } else {
                            skuIds.addAll(commodityIdList);
                        }
                        if (!CollectionUtils.isEmpty(skuIds)) {
                            UccSkuPo uccSkuPo = new UccSkuPo();
                            uccSkuPo.setSkuStatus(SkuStatusEnum.PENDING_SHELF_STATUS.getStatus());
                            this.uccSkuMapper.batchUpdateById(skuIds, uccSkuPo);
                        }
                    }
                });
            }
        }
    }

    private void dealCreate(List<UccCommoditySyncSupplierInfoBO> syncSupplierInfo) {
        if (!CollectionUtils.isEmpty(syncSupplierInfo)) {
            ArrayList<UccRelSkuSupskuPO> relSkuSupskuList = new ArrayList<UccRelSkuSupskuPO>();
            ArrayList<UccSupplyInfoPO> supplyInfoList = new ArrayList<UccSupplyInfoPO>();
            syncSupplierInfo.forEach(info -> {
                Long supplySkuId = this.sequence.nextId();
                UccRelSkuSupskuPO uccRelSkuSupskuPo = new UccRelSkuSupskuPO();
                uccRelSkuSupskuPo.setSkuId(info.getCommodityId());
                uccRelSkuSupskuPo.setSupplySkuId(supplySkuId);
                relSkuSupskuList.add(uccRelSkuSupskuPo);
                UccSupplyInfoPO uccSupplyInfoPo = new UccSupplyInfoPO();
                uccSupplyInfoPo.setSupplySkuId(supplySkuId);
                uccSupplyInfoPo.setSupplierName(info.getSupplierName());
                uccSupplyInfoPo.setSupplierId(info.getSupplierId());
                uccSupplyInfoPo.setSupplyPrice(MoneyUtils.yuanToHaoToLong((BigDecimal)info.getSupplyPrice()));
                uccSupplyInfoPo.setRebate(info.getRebate());
                uccSupplyInfoPo.setPrepayment(info.getPrepayment());
                uccSupplyInfoPo.setAgreementId(info.getAgreementId());
                uccSupplyInfoPo.setAgreementCreaterId(info.getAgreementCreaterId());
                supplyInfoList.add(uccSupplyInfoPo);
            });
            if (!CollectionUtils.isEmpty(relSkuSupskuList) && !CollectionUtils.isEmpty(supplyInfoList)) {
                this.uccRelSkuSupskuMapper.insertBatch(relSkuSupskuList);
                this.uccSupplyInfoMapper.insertBatch(supplyInfoList);
                List skuIds = syncSupplierInfo.stream().map(UccCommoditySyncSupplierInfoBO::getCommodityId).collect(Collectors.toList());
                List uccSkuPos = this.uccSkuMapper.qeryBatchSkus(skuIds);
                List skuList = uccSkuPos.stream().filter(sku -> SkuStatusEnum.PENDING_SHELF_STATUS.getStatus().equals(sku.getSkuStatus())).map(UccSkuPo::getSkuId).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(skuList)) {
                    UccSkuPo uccSkuPo = new UccSkuPo();
                    uccSkuPo.setSkuStatus(SkuStatusEnum.ON_SHELVES_STATUS.getStatus());
                    this.uccSkuMapper.batchUpdateById(skuList, uccSkuPo);
                }
            } else {
                throw new BusinessException("8888", "\u7ec4\u88c5\u5546\u54c1-\u4f9b\u5e94\u5546\u4fe1\u606f\u5931\u8d25");
            }
        }
    }
}

