/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.comb.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.bo.busi.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.external.bo.UccCallUmcRemoveSceneReqBO;
import com.tydic.commodity.external.bo.UccCallUmcRemoveSceneRspBO;
import com.tydic.commodity.external.service.UccCallUmcRemoveSceneService;
import com.tydic.commodity.external.util.PropertiesUtil;
import com.tydic.commodity.util.ListUtils;
import com.tydic.uccext.bo.UccBatchImportSceneAbilityReqBO;
import com.tydic.uccext.bo.UccBatchImportSceneBusiReqBO;
import com.tydic.uccext.bo.UccBatchImportSceneBusiRspBO;
import com.tydic.uccext.bo.UccSceneBO;
import com.tydic.uccext.constant.UccConstants;
import com.tydic.uccext.dao.UccSceneMapper;
import com.tydic.uccext.dao.po.UccScenePO;
import com.tydic.uccext.service.UccBatchImportSceneBusiService;
import com.tydic.uccext.service.UccBatchImportSceneCombService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccBatchImportSceneCombServiceImpl
implements UccBatchImportSceneCombService {
    private static final Logger log = LoggerFactory.getLogger(UccBatchImportSceneCombServiceImpl.class);
    @Autowired
    private UccSceneMapper uccSceneMapper;
    @Autowired
    private UccBatchImportSceneBusiService uccBatchImportSceneBusiService;
    @Autowired
    private UccCallUmcRemoveSceneService uccCallUmcRemoveSceneService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    @Async(value="sceneSyncThreadPool")
    public void dealSceneImport(UccBatchImportSceneAbilityReqBO reqBo) {
        ArrayList<UccSceneBO> needDealInsert = new ArrayList<UccSceneBO>();
        ArrayList<UccSceneBO> needDealUpdate = new ArrayList<UccSceneBO>();
        UccScenePO uccScenePo = new UccScenePO();
        uccScenePo.setSceneStatus(UccConstants.Status.VALID.longValue());
        List<UccScenePO> uccScenePoList = this.uccSceneMapper.getList(uccScenePo);
        if (CollectionUtils.isEmpty(uccScenePoList)) {
            needDealInsert.addAll(reqBo.getSceneInfoList());
        } else {
            Map<String, List<UccScenePO>> sceneMapByCode = uccScenePoList.stream().collect(Collectors.groupingBy(UccScenePO::getSceneCode));
            Map<String, List<UccScenePO>> sceneMapByName = uccScenePoList.stream().collect(Collectors.groupingBy(UccScenePO::getSceneName));
            for (UccSceneBO bo : reqBo.getSceneInfoList()) {
                UccSceneBO sceneBo;
                UccScenePO scenePo;
                boolean code = true;
                boolean name = true;
                List<UccScenePO> sceneListByCode = sceneMapByCode.get(bo.getSceneCode());
                List<UccScenePO> sceneListByName = sceneMapByName.get(bo.getSceneName());
                if (!CollectionUtils.isEmpty(sceneListByName)) {
                    name = false;
                    scenePo = sceneListByName.get(0);
                    if (!scenePo.getSceneCode().equals(bo.getSceneCode())) {
                        sceneBo = new UccSceneBO();
                        BeanUtils.copyProperties((Object)bo, (Object)sceneBo);
                        sceneBo.setSceneId(scenePo.getSceneId());
                        sceneBo.setOldSceneCode(scenePo.getSceneCode());
                        sceneBo.setOldSceneName(scenePo.getSceneName());
                        needDealUpdate.add(sceneBo);
                    }
                }
                if (!CollectionUtils.isEmpty(sceneListByCode)) {
                    code = false;
                    scenePo = sceneListByCode.get(0);
                    if (!scenePo.getSceneName().equals(bo.getSceneName())) {
                        sceneBo = new UccSceneBO();
                        BeanUtils.copyProperties((Object)bo, (Object)sceneBo);
                        sceneBo.setSceneId(scenePo.getSceneId());
                        sceneBo.setOldSceneCode(scenePo.getSceneCode());
                        sceneBo.setOldSceneName(scenePo.getSceneName());
                        needDealUpdate.add(sceneBo);
                    }
                }
                if (!code || !name) continue;
                needDealInsert.add(bo);
            }
        }
        UccBatchImportSceneBusiReqBO busiReqBo = new UccBatchImportSceneBusiReqBO();
        BeanUtils.copyProperties((Object)reqBo, (Object)busiReqBo);
        busiReqBo.setInsertList(needDealInsert.stream().distinct().collect(Collectors.toList()));
        busiReqBo.setUpdateList(needDealUpdate.stream().distinct().collect(Collectors.toList()));
        UccBatchImportSceneBusiRspBO busiRspBo = this.uccBatchImportSceneBusiService.dealSceneImport(busiReqBo);
        if ("0000".equals(busiRspBo.getRespCode())) {
            this.syncEs(busiRspBo.getCommodityList());
            if (!CollectionUtils.isEmpty((Collection)busiReqBo.getUpdateList())) {
                this.callUmcRemoveScene(busiReqBo.getUpdateList());
            }
        }
    }

    private void syncEs(Map<Long, List<Long>> commodityList) {
        if (!CollectionUtils.isEmpty(commodityList)) {
            commodityList.forEach((supplierShopId, commodityIdList) -> {
                Map batchList;
                if (null != supplierShopId && !CollectionUtils.isEmpty((Collection)commodityIdList) && !CollectionUtils.isEmpty((Map)(batchList = ListUtils.batchList((List)commodityIdList, (int)200)))) {
                    batchList.forEach((index, list) -> {
                        SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBo = new SyncSceneCommodityToEsReqBO();
                        syncSceneCommodityToEsReqBo.setCommodityIds(list);
                        syncSceneCommodityToEsReqBo.setSupplierId(supplierShopId);
                        syncSceneCommodityToEsReqBo.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                        syncSceneCommodityToEsReqBo.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
                        syncSceneCommodityToEsReqBo.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                        this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBo)));
                    });
                }
            });
        }
    }

    private void callUmcRemoveScene(List<UccSceneBO> updateList) {
        UccCallUmcRemoveSceneReqBO uccCallUmcRemoveSceneReqBo = new UccCallUmcRemoveSceneReqBO();
        uccCallUmcRemoveSceneReqBo.setNames(updateList.stream().map(UccSceneBO::getOldSceneName).distinct().collect(Collectors.toList()));
        uccCallUmcRemoveSceneReqBo.setCodes(updateList.stream().map(UccSceneBO::getOldSceneCode).distinct().collect(Collectors.toList()));
        UccCallUmcRemoveSceneRspBO uccCallUmcRemoveSceneRspBo = this.uccCallUmcRemoveSceneService.callUmcRemoveScene(uccCallUmcRemoveSceneReqBo);
        if (!"0000".equals(uccCallUmcRemoveSceneRspBo.getRespCode())) {
            log.error("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u79fb\u9664\u573a\u666f\u5931\u8d25\uff1a{}", (Object)JSON.toJSONString((Object)uccCallUmcRemoveSceneRspBo));
        }
    }
}

