/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.comb.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.FileClientFactory;
import com.ohaotian.plugin.file.constant.FileType;
import com.ohaotian.plugin.file.ftp.FtpConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.bo.busi.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.external.util.PropertiesUtil;
import com.tydic.commodity.util.ListUtils;
import com.tydic.uccext.bo.UccCommodityPicSyncBusiReqBO;
import com.tydic.uccext.bo.UccCommodityPicSyncBusiRspBO;
import com.tydic.uccext.bo.UccCommodityPicSyncCombReqBO;
import com.tydic.uccext.bo.UccCommodiytSyncPicBO;
import com.tydic.uccext.constant.UccConstants;
import com.tydic.uccext.dao.UccCommodityExtMapper;
import com.tydic.uccext.service.UccCommodityPicSyncBusiService;
import com.tydic.uccext.service.UccCommodityPicSyncCombService;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccCommodityPicSyncCombServiceImpl
implements UccCommodityPicSyncCombService {
    private static final Logger log = LoggerFactory.getLogger(UccCommodityPicSyncCombServiceImpl.class);
    @Value(value="${PIC_DIR_PATH:}")
    private String picDirPath;
    @Value(value="${fastdfs.downloadUrl:}")
    private String fastdfsDownloadUrl;
    @Value(value="${oss.fileUrl}")
    private String ossFileUrl;
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Autowired
    private FtpConfig ftpConfig;
    @Autowired
    private FileClient fileClient;
    @Autowired
    private UccCommodityExtMapper uccCommodityExtMapper;
    @Autowired
    private UccCommodityPicSyncBusiService uccCommodityPicSyncBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    private final Pattern pattern = Pattern.compile("^\\d{3}$");
    private final String mainPicSuffix = "001";
    private final List<String> detailPicSuffixs = Arrays.asList("002", "003", "004", "005");

    @Async(value="picSyncThreadPool")
    public void dealCommodityPicSync(UccCommodityPicSyncCombReqBO reqBo) {
        Map<String, List<String>> commodityPicMap = this.groupFileNameList(reqBo.getFileNameList());
        List<UccCommodityPo> commodityList = this.uccCommodityExtMapper.checkSyncPicCommodity(new ArrayList<String>(commodityPicMap.keySet()));
        if (CollectionUtils.isEmpty(commodityList)) {
            log.debug("\u56fe\u7247\u540c\u6b65-\u65e0\u5f85\u5904\u7406\u5546\u54c1\u6570\u636e");
            return;
        }
        List commodityCodeList = commodityList.stream().map(UccCommodityPo::getCommodityCode).filter(StringUtils::hasText).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(commodityCodeList)) {
            HashSet needRemoveCode = new HashSet();
            commodityPicMap.keySet().forEach(code -> {
                if (!commodityCodeList.contains(code)) {
                    needRemoveCode.add(code);
                }
            });
            if (!CollectionUtils.isEmpty(needRemoveCode)) {
                needRemoveCode.forEach(commodityPicMap::remove);
            }
        }
        List<UccCommodiytSyncPicBO> picInfoList = null;
        if (!CollectionUtils.isEmpty(commodityPicMap)) {
            picInfoList = this.dealDownLoadThenUpload(commodityPicMap, reqBo.getFtpPath());
            this.transPicMap(commodityList, picInfoList);
        }
        if (!CollectionUtils.isEmpty(picInfoList)) {
            Map batchList;
            List commodityIdList;
            UccCommodityPicSyncBusiReqBO busiReqBo = new UccCommodityPicSyncBusiReqBO();
            BeanUtils.copyProperties((Object)reqBo, (Object)busiReqBo);
            busiReqBo.setPicInfo(picInfoList);
            UccCommodityPicSyncBusiRspBO busiRspBo = this.uccCommodityPicSyncBusiService.dealCommodityPicSync(busiReqBo);
            if ("0000".equals(busiRspBo.getRespCode()) && !CollectionUtils.isEmpty(commodityIdList = picInfoList.stream().map(UccCommodiytSyncPicBO::getCommodityId).distinct().collect(Collectors.toList())) && !CollectionUtils.isEmpty((Map)(batchList = ListUtils.batchList(commodityIdList, (int)100)))) {
                batchList.forEach((index, list) -> {
                    if (!CollectionUtils.isEmpty((Collection)list)) {
                        SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBo = new SyncSceneCommodityToEsReqBO();
                        syncSceneCommodityToEsReqBo.setCommodityIds(list);
                        syncSceneCommodityToEsReqBo.setSupplierId(UccConstants.ATOUR_SUPPLIER_SHOP_ID);
                        syncSceneCommodityToEsReqBo.setOperType(ModelRuleConstant.OPER_ES_ADD_TYPE);
                        syncSceneCommodityToEsReqBo.setSyncType(ModelRuleConstant.SYNC_ES_BY_COMMODITY_ID);
                        syncSceneCommodityToEsReqBo.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_ALL.intValue());
                        this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty((String)"LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBo)));
                    }
                });
            }
        }
    }

    private Map<String, List<String>> groupFileNameList(List<String> fileNameList) {
        HashMap<String, List<String>> commodityPicMap = new HashMap<String, List<String>>(16);
        fileNameList.forEach(fileName -> {
            String commodityCode = fileName.split("-")[0];
            if (commodityPicMap.containsKey(commodityCode)) {
                ((List)commodityPicMap.get(commodityCode)).add(fileName);
            } else {
                ArrayList<String> fileNames = new ArrayList<String>();
                fileNames.add((String)fileName);
                commodityPicMap.put(commodityCode, fileNames);
            }
        });
        return commodityPicMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<UccCommodiytSyncPicBO> dealDownLoadThenUpload(Map<String, List<String>> commodityPicMap, String ftpPath) {
        ArrayList<UccCommodiytSyncPicBO> syncPicList = new ArrayList<UccCommodiytSyncPicBO>();
        FileClient ftpClient = FileClientFactory.getFtpClient((FtpConfig)this.ftpConfig);
        block11: for (Map.Entry<String, List<String>> entry : commodityPicMap.entrySet()) {
            List checkNameSuffix;
            String commodityCode = entry.getKey();
            List<String> fileNameList = entry.getValue();
            List checkMain = fileNameList.stream().filter(fileName -> fileName.contains("-001.")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(checkMain) || (checkNameSuffix = fileNameList.stream().filter(fileName -> {
                String nameSuffix = fileName.split("[.]")[0].split("[-]")[1];
                Matcher is3Digit = this.pattern.matcher(nameSuffix);
                return is3Digit.matches();
            }).collect(Collectors.toList())).size() != fileNameList.size()) continue;
            for (String fileName2 : fileNameList) {
                String filePath;
                String[] nameSplit = fileName2.split("[.]");
                String nameSuffix = nameSplit[0].split("[-]")[1];
                Integer picType = "001".equals(nameSuffix) ? ModelRuleConstant.COMMD_IMG_MAIN : (this.detailPicSuffixs.contains(nameSuffix) ? ModelRuleConstant.COMMD_IMG_DETAIL : Integer.valueOf(0));
                String fileNameNew = nameSplit[0] + "-" + System.currentTimeMillis() + "." + nameSplit[1];
                InputStream inputStream = null;
                try {
                    inputStream = ftpClient.downLoadToInputStream(ftpPath + "/" + fileName2);
                    filePath = this.fileClient.uploadFileByInputStream(this.picDirPath, fileNameNew, inputStream);
                }
                catch (Exception e) {
                    log.error("\u4e0b\u8f7d\u5e76\u4e0a\u4f20\u56fe\u7247\u5f02\u5e38\uff0c\u8df3\u8fc7\u8be5\u56fe\u7247[" + fileName2 + "]", (Throwable)e);
                    continue block11;
                }
                finally {
                    try {
                        if (null == inputStream) continue block11;
                        inputStream.close();
                    }
                    catch (IOException e) {
                        log.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5f02\u5e38", (Throwable)e);
                    }
                    continue block11;
                }
                if (!StringUtils.hasText((String)filePath)) {
                    log.error("\u4e0a\u4f20\u672a\u8fd4\u56de\u56fe\u7247\u8def\u5f84\uff0c\u8df3\u8fc7\u8be5\u56fe\u7247[{}]", (Object)fileName2);
                    continue block11;
                }
                if (FileType.isOss((String)this.fileType)) {
                    filePath = "https://" + this.ossFileUrl + filePath;
                } else if (FileType.isFastdfs((String)this.fileType)) {
                    String[] split = filePath.split("[,]");
                    if (split.length != 2) {
                        log.error("\u4e0a\u4f20\u8fd4\u56de\u7684\u56fe\u7247\u8def\u5f84\u7ec4\u6210\u90e8\u5206\u5f02\u5e38\uff0c\u8df3\u8fc7\u8be5\u56fe\u7247[{}]\uff0c\u8def\u5f84[{}]", (Object)fileName2, (Object)filePath);
                        continue block11;
                    }
                    if ("null".equals(split[0]) || "null".equals(split[1])) {
                        log.error("\u4e0a\u4f20\u8fd4\u56de\u7684\u56fe\u7247\u8def\u5f84\u4e2d\u5b58\u5728null\uff0c\u8df3\u8fc7\u8be5\u56fe\u7247[{}]\uff0c\u8def\u5f84[{}]", (Object)fileName2, (Object)filePath);
                        continue block11;
                    }
                    filePath = this.fastdfsDownloadUrl + "/" + filePath.replace(",", "/");
                }
                UccCommodiytSyncPicBO uccCommodiytSyncPicBo = new UccCommodiytSyncPicBO();
                uccCommodiytSyncPicBo.setCommodityCode(commodityCode);
                uccCommodiytSyncPicBo.setPicType(picType);
                uccCommodiytSyncPicBo.setPicUrl(filePath);
                uccCommodiytSyncPicBo.setPicOrder(Integer.valueOf(nameSuffix));
                uccCommodiytSyncPicBo.setRemark(fileName2);
                syncPicList.add(uccCommodiytSyncPicBo);
            }
        }
        return syncPicList;
    }

    private void transPicMap(List<UccCommodityPo> commodityList, List<UccCommodiytSyncPicBO> picList) {
        picList.forEach(syncPicBo -> {
            for (UccCommodityPo com : commodityList) {
                if (!syncPicBo.getCommodityCode().equals(com.getCommodityCode())) continue;
                syncPicBo.setCommodityId(com.getCommodityId());
                break;
            }
        });
    }
}

