/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.constant;

import com.tydic.uccext.bo.UccGoodsAgreementAndCommodityBO;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelUtils {
    private static final Logger log = LoggerFactory.getLogger(ExcelUtils.class);
    private static final String EXCEL_XLS = "xls";
    private static final String EXCEL_XLSX = "xlsx";

    public static void getExcelDate(String path, List<List<String>> data, Integer readLine) throws Exception {
        URL url = new URL(path);
        File file = new File(url.getFile());
        InputStream inputStream = url.openStream();
        ExcelUtils.checkExcelVaild(file);
        Workbook workbook = ExcelUtils.getWorkbok(file, inputStream);
        int count = 1;
        Sheet sheet = workbook.getSheetAt(0);
        for (Row row : sheet) {
            ArrayList<String> c = new ArrayList<String>();
            int end = row.getLastCellNum();
            if ("".equals(row.getCell(0).toString())) continue;
            for (int i = 0; i < end; ++i) {
                Cell cell = row.getCell(i);
                if (cell == null) {
                    c.add("");
                    continue;
                }
                Object obj = ExcelUtils.getValue(cell);
                if (count < readLine) continue;
                c.add(String.valueOf(obj).trim());
            }
            ++count;
            if (c.size() <= 0) continue;
            data.add(c);
        }
    }

    private static void checkExcelVaild(File file) throws Exception {
        if (!file.getName().endsWith(EXCEL_XLS) && !file.getName().endsWith(EXCEL_XLSX)) {
            throw new Exception("\u6587\u4ef6\u4e0d\u662fExcel");
        }
    }

    private static Workbook getWorkbok(File file, InputStream inputStream) throws IOException {
        HSSFWorkbook wb = null;
        if (file.getName().endsWith(EXCEL_XLS)) {
            wb = new HSSFWorkbook(inputStream);
        } else if (file.getName().endsWith(EXCEL_XLSX)) {
            wb = new XSSFWorkbook(inputStream);
        }
        return wb;
    }

    private static Object getValue(Cell cell) {
        Object obj = null;
        cell.setCellType(CellType.STRING);
        switch (cell.getCellTypeEnum()) {
            case BOOLEAN: {
                obj = cell.getBooleanCellValue();
                break;
            }
            case ERROR: {
                obj = cell.getErrorCellValue();
                break;
            }
            case NUMERIC: {
                obj = cell.getNumericCellValue();
                break;
            }
            case STRING: {
                obj = cell.getStringCellValue();
                break;
            }
        }
        return obj;
    }

    public static void main(String[] args) {
        ArrayList<UccGoodsAgreementAndCommodityBO> uccGoodsAgreementAndCommodityBOS = new ArrayList<UccGoodsAgreementAndCommodityBO>();
        UccGoodsAgreementAndCommodityBO uccGoodsAgreementAndCommodityBO = new UccGoodsAgreementAndCommodityBO();
        uccGoodsAgreementAndCommodityBO.setCatalogId(Long.valueOf(1001L));
        uccGoodsAgreementAndCommodityBOS.add(uccGoodsAgreementAndCommodityBO);
        UccGoodsAgreementAndCommodityBO uccGoodsAgreementAndCommodityBO1 = new UccGoodsAgreementAndCommodityBO();
        uccGoodsAgreementAndCommodityBO1.setCatalogId(Long.valueOf(1002L));
        uccGoodsAgreementAndCommodityBOS.add(uccGoodsAgreementAndCommodityBO1);
        UccGoodsAgreementAndCommodityBO uccGoodsAgreementAndCommodityBO2 = new UccGoodsAgreementAndCommodityBO();
        uccGoodsAgreementAndCommodityBO2.setCatalogId(null);
        uccGoodsAgreementAndCommodityBOS.add(uccGoodsAgreementAndCommodityBO2);
        List<Object> catalogIds = new ArrayList();
        if (!CollectionUtils.isEmpty(uccGoodsAgreementAndCommodityBOS)) {
            catalogIds = uccGoodsAgreementAndCommodityBOS.stream().filter(UccGoodsAgreementAndCommodityBO2 -> UccGoodsAgreementAndCommodityBO2.getCatalogId() != null).map(UccGoodsAgreementAndCommodityBO::getCatalogId).collect(Collectors.toList());
        }
        System.out.println(catalogIds);
    }
}

