/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.controller.busi;

import com.tydic.commodity.bo.busi.CommodityInfoCheckReqBO;
import com.tydic.commodity.bo.busi.CommodityInfoCheckRspBO;
import com.tydic.commodity.bo.busi.SendNextCommoDealDetail;
import com.tydic.commodity.bo.busi.UccExaminationApprovalReqBO;
import com.tydic.commodity.bo.busi.UccExaminationApprovalRspBO;
import com.tydic.commodity.bo.busi.UccRestoreShelfReqBO;
import com.tydic.commodity.bo.busi.UccRestoreShelfRspBO;
import com.tydic.commodity.busi.api.UccCommodityInfoCheckBusiService;
import com.tydic.commodity.busi.api.UccExaminationApprovalBusiService;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.validate.ValidatorUtil;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ucc/elcmarket/busi"})
public class RestoreShelfeController {
    @Reference(interfaceClass=UccCommodityInfoCheckBusiService.class, version="1.0.0", group="UCC_GROUP_TEST")
    private UccCommodityInfoCheckBusiService uccCommodityInfoCheckBusiService;
    @Reference(interfaceClass=UccExaminationApprovalBusiService.class, version="1.0.0", group="UCC_GROUP_TEST")
    private UccExaminationApprovalBusiService uccExaminationApprovalBusiService;

    @RequestMapping(value={"/shelves"}, method={RequestMethod.POST})
    public UccRestoreShelfRspBO shelves(@RequestBody UccRestoreShelfReqBO reqBO) {
        UccRestoreShelfRspBO rspUccBo = new UccRestoreShelfRspBO();
        try {
            ValidatorUtil.validator((Object)reqBO);
        }
        catch (BusinessException e) {
            rspUccBo.setRespCode("8888");
            rspUccBo.setRespDesc(e.getMsgInfo());
            return rspUccBo;
        }
        if (reqBO.getBusinessId() == null || reqBO.getBusinessId().length < 1) {
            rspUccBo.setRespCode("8888");
            rspUccBo.setRespDesc("\u4e1a\u52a1ID\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return rspUccBo;
        }
        UccRestoreShelfRspBO uccRestoreShelfRspBO = this.uccCommodityInfoCheckBusiService.repeatedProcessingCheck(reqBO.getBusinessId());
        if ("8888".equals(uccRestoreShelfRspBO.getRespCode())) {
            return uccRestoreShelfRspBO;
        }
        CommodityInfoCheckReqBO commodityInfoCheckReqBO = new CommodityInfoCheckReqBO();
        commodityInfoCheckReqBO.setViewIsTrue(Boolean.valueOf(true));
        commodityInfoCheckReqBO.setCommodityId(reqBO.getBusinessId());
        commodityInfoCheckReqBO.setSupplierId(reqBO.getSupplierId());
        commodityInfoCheckReqBO.setOperId(reqBO.getUsername());
        CommodityInfoCheckRspBO commodityInfoCheckRspBO = this.uccCommodityInfoCheckBusiService.dealCommodityInfoCheck(commodityInfoCheckReqBO);
        rspUccBo.setRespDesc(commodityInfoCheckRspBO.getRespDesc());
        rspUccBo.setRespCode(commodityInfoCheckRspBO.getRespCode());
        try {
            if (CollectionUtils.isNotEmpty((Collection)commodityInfoCheckRspBO.getSendNextCommoDealDetails())) {
                Long[] business = new Long[commodityInfoCheckRspBO.getSendNextCommoDealDetails().size()];
                for (int i = 0; i < commodityInfoCheckRspBO.getSendNextCommoDealDetails().size(); ++i) {
                    business[i] = ((SendNextCommoDealDetail)commodityInfoCheckRspBO.getSendNextCommoDealDetails().get(i)).getCommodityId();
                }
                UccExaminationApprovalReqBO uccExaminationApprovalReqBO = new UccExaminationApprovalReqBO();
                uccExaminationApprovalReqBO.setBusinessId(business);
                uccExaminationApprovalReqBO.setSupplierId(reqBO.getSupplierId());
                uccExaminationApprovalReqBO.setOperId(reqBO.getUsername());
                uccExaminationApprovalReqBO.setRestoreShelfe(Boolean.valueOf(true));
                uccExaminationApprovalReqBO.setReason(reqBO.getReason());
                UccExaminationApprovalRspBO uccExaminationApprovalRspBO = this.uccExaminationApprovalBusiService.dealExaminationApproval(uccExaminationApprovalReqBO);
                rspUccBo.setRespDesc(uccExaminationApprovalRspBO.getRespDesc());
                rspUccBo.setRespCode(uccExaminationApprovalRspBO.getRespCode());
            }
        }
        catch (BusinessException e) {
            rspUccBo.setRespCode("8888");
            rspUccBo.setRespDesc(e.getMsgInfo());
            return rspUccBo;
        }
        return rspUccBo;
    }

    private void RepeatedProcessingCheck(Long[] commodityIds) {
    }
}

