/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.controller.busi;

import com.tydic.commodity.bo.busi.Rsp;
import com.tydic.commodity.bo.busi.TaskReqBo;
import com.tydic.commodity.bo.busi.TaskRspBo;
import com.tydic.commodity.bo.busi.UccCurrentStockQryReqBO;
import com.tydic.commodity.bo.busi.UccCurrentStockQryRspBO;
import com.tydic.commodity.bo.busi.UccSkuStockManagerReqBO;
import com.tydic.commodity.bo.busi.UccSkuStockManagerRspBO;
import com.tydic.commodity.bo.comb.UccStockControlReqBO;
import com.tydic.commodity.bo.comb.UccStockControlRspBO;
import com.tydic.commodity.busi.api.UccCommdStockQryBusiService;
import com.tydic.commodity.busi.api.UccSkuStockManagerBusiService;
import com.tydic.commodity.comb.api.UccStockControlCombService;
import java.math.BigDecimal;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ucc/busi"})
public class UccSkuStockUpdateController {
    @Reference(interfaceClass=UccSkuStockManagerBusiService.class, version="1.0.0", group="UCC_GROUP_TEST")
    private UccSkuStockManagerBusiService uccSkuStockManagerBusiService;
    @Reference(interfaceClass=UccCommdStockQryBusiService.class, version="1.0.0", group="UCC_GROUP_TEST")
    private UccCommdStockQryBusiService uccCommdStockQryBusiService;
    @Reference(interfaceClass=UccStockControlCombService.class, version="1.0.0", group="UCC_GROUP_TEST")
    private UccStockControlCombService uccStockControlCombService;

    @ResponseBody
    @RequestMapping(value={"skuStock"}, method={RequestMethod.POST})
    public UccSkuStockManagerRspBO selectCatalogTest(@RequestBody UccSkuStockManagerReqBO reqBO) {
        return this.uccSkuStockManagerBusiService.dealSkuStockManager(reqBO);
    }

    @ResponseBody
    @RequestMapping(value={"/commdCurrentStock/qry"}, method={RequestMethod.POST})
    public UccCurrentStockQryRspBO selectCatalogTest(@RequestBody UccCurrentStockQryReqBO reqBO) {
        return this.uccCommdStockQryBusiService.qryStock(reqBO);
    }

    @RequestMapping(value={"/stock/update"})
    public TaskRspBo transPortToEs(@RequestBody TaskReqBo reqBO) {
        TaskRspBo rspBo = new TaskRspBo();
        UccStockControlReqBO uccStockControlReqBO = new UccStockControlReqBO();
        String[] params = reqBO.getShardingParameter().split("&");
        if (StringUtils.isNotEmpty((String)params[0])) {
            uccStockControlReqBO.setSupplierId(Long.valueOf(Long.parseLong(params[0])));
        }
        if (StringUtils.isNotEmpty((String)params[1])) {
            uccStockControlReqBO.setStockNum(new BigDecimal(params[1]));
        }
        if (StringUtils.isNotEmpty((String)params[2])) {
            uccStockControlReqBO.setAreaId(Long.valueOf(Long.parseLong(params[2])));
        }
        UccStockControlRspBO rspBaseBO = this.uccStockControlCombService.updateStock(uccStockControlReqBO);
        rspBo.setRsp(new Rsp(rspBaseBO.getRespCode()));
        return rspBo;
    }

    @ResponseBody
    @RequestMapping(value={"skuStock/localDeal"}, method={RequestMethod.POST})
    public UccStockControlRspBO updateStockLocal(@RequestBody UccStockControlReqBO reqBO) {
        return this.uccStockControlCombService.updateStock(reqBO);
    }
}

