/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.controller.busi.abstractfilestandarcomtroller;

import com.alibaba.fastjson.JSON;
import com.tydic.commodity.bo.busi.Entityable;
import com.tydic.commodity.controller.busi.abstractfilestandarcomtroller.QueryInfo;
import com.tydic.commodity.enumType.WebRequestParameterEnum;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.util.Reflections;
import com.tydic.commodity.util.Utils;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public abstract class AbstractFileOperationController<T extends Entityable> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractFileOperationController.class);
    private int defaultExportBatchSize = 1000;

    protected void doExportExcel(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.doExportExcelHeader(request, response);
        this.doExportExcelBody(request, response, this.getExportBatchSize());
    }

    protected void doExportExcelHeader(HttpServletRequest request, HttpServletResponse response) {
        String fileName = this.getExportFileName(request);
        response.setContentType("application/vnd.ms-excel;charset=utf-8");
        response.setHeader("Content-Disposition", "attachment");
        try {
            response.setHeader("Content-Disposition", "filename=\"" + new String(fileName.getBytes("UTF-8"), "ISO8859-1") + ".xlsx\"");
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u6587\u4ef6\u4e0a\u4f20\u4e0d\u652f\u6301\u8be5\u7c7b\u578b");
        }
    }

    protected String getExportFileName(HttpServletRequest request) {
        String fileName = this.exportFileName();
        String exportFileName = request.getParameter(WebRequestParameterEnum.exportFileName.code());
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)exportFileName)) {
            fileName = exportFileName;
        }
        return fileName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doExportExcelBody(HttpServletRequest request, HttpServletResponse response, int batchSize) {
        SXSSFWorkbook workbook = null;
        ServletOutputStream out = null;
        try {
            List<String> headerNames = this.getExportTitles();
            workbook = new SXSSFWorkbook(batchSize);
            workbook.setCompressTempFiles(true);
            SXSSFSheet sheet = workbook.createSheet();
            int rowNum = 0;
            Row row = sheet.createRow(rowNum);
            if (headerNames != null) {
                for (int cellnum = 0; cellnum < headerNames.size(); ++cellnum) {
                    row.createCell(cellnum).setCellValue(headerNames.get(cellnum));
                }
                ++rowNum;
            }
            QueryInfo<Entityable> pageInfo = this.queryForExport();
            this.doExportExcelPage(pageInfo.getQueryResults(), rowNum, (Sheet)sheet);
            out = response.getOutputStream();
            workbook.write((OutputStream)out);
            out.flush();
        }
        catch (Exception var17) {
            try {
                logger.warn("do export excel failure -> " + var17.getMessage(), (Throwable)var17);
                throw new BusinessException("8888", "\u6267\u884c\u5bfc\u51fa\u8fc7\u7a0b\u5931\u8d25[" + var17.getMessage() + "]");
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(out);
                IOUtils.closeQuietly(workbook);
                try {
                    if (workbook == null) throw throwable;
                    workbook.dispose();
                    throw throwable;
                }
                catch (Exception e) {
                    logger.error("do export excel failure -> ", (Throwable)e);
                }
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)out);
        IOUtils.closeQuietly((Closeable)workbook);
        try {
            if (workbook == null) return;
            workbook.dispose();
            return;
        }
        catch (Exception e) {
            logger.error("do export excel failure -> ", (Throwable)e);
            return;
        }
    }

    protected int doExportExcelPage(List<Entityable> list, int startRow, Sheet sheet) throws Exception {
        int rowNum = startRow;
        for (Entityable entity : list) {
            List<String> entityData = this.doExportEntity(entity);
            Row row = sheet.createRow(rowNum);
            for (int cellNum = 0; cellNum < entityData.size(); ++cellNum) {
                String value = Utils.trimToEmpty((String)entityData.get(cellNum));
                Cell cell = row.createCell(cellNum);
                cell.setCellValue(value);
            }
            ++rowNum;
        }
        return rowNum;
    }

    protected List<String> doExportEntity(Entityable entity) {
        Set simplePropertyNames = Reflections.getSimpleFieldNames(entity.getClass());
        String[] propertyNames = simplePropertyNames.toArray(new String[0]);
        return Reflections.invokeGetterToString((Object)entity, (String[])propertyNames);
    }

    protected abstract QueryInfo<Entityable> queryForExport();

    protected abstract String exportFileName();

    protected abstract List<String> getExportTitles();

    public int getExportBatchSize() {
        return this.defaultExportBatchSize;
    }

    public List<List<String>> doImportExcel(String path, int startReadLine) {
        FileInputStream is;
        if (StringUtils.isEmpty((Object)path)) {
            throw new BusinessException("8888", "\u4f20\u5165\u8def\u5f84\u9519\u8bef");
        }
        try {
            File url = new File(path);
            is = new FileInputStream(url);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u6587\u4ef6\u8def\u5f84\u8bfb\u53d6\u9519\u8bef");
        }
        ArrayList<List<String>> lines = new ArrayList<List<String>>();
        try {
            Workbook workbook = WorkbookFactory.create((InputStream)is);
            Sheet sheet = workbook.getSheetAt(0);
            int i = 1;
            if (sheet != null) {
                for (Row row : sheet) {
                    if (i >= startReadLine && row != null) {
                        ArrayList<String> rows = new ArrayList<String>(row.getLastCellNum());
                        for (Cell cell : row) {
                            cell.setCellType(CellType.STRING);
                            rows.add(cell.getStringCellValue());
                        }
                        logger.info(JSON.toJSONString(rows));
                        lines.add(rows);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new BusinessException("8888", "\u5904\u7406\u5931\u8d25");
        }
        return lines;
    }
}

