/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.controller;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.fastjson.JSON;
import com.tydic.commodity.bo.busi.Rsp;
import com.tydic.commodity.bo.busi.TaskReqBo;
import com.tydic.commodity.bo.busi.TaskRspBo;
import com.tydic.uccext.bo.UccCommdStatusManageCombReqBO;
import com.tydic.uccext.bo.UccCommdStatusManageCombRspBO;
import com.tydic.uccext.bo.UccCommdThreadReqBO;
import com.tydic.uccext.bo.UccCommdThreadRspBO;
import com.tydic.uccext.bo.UccGetLmAllComByPageReqBO;
import com.tydic.uccext.bo.UccGetLmAllComByPageRspBO;
import com.tydic.uccext.bo.UccSyncCommodityInfoReqBO;
import com.tydic.uccext.bo.UccSyncCommodityInfoRspBO;
import com.tydic.uccext.service.UccCommdStatusManageCombService;
import com.tydic.uccext.service.UccCommdThreadCombService;
import com.tydic.uccext.service.UccGetLmAllComByPageAbilityService;
import com.tydic.uccext.service.UccSyncCommodityInfoAbilityService;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"ucc/busi/commodity"})
public class UccCommdStatusManageController {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCommdStatusManageController.class);
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="service")
    private UccCommdStatusManageCombService uccCommdStatusManageCombService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="service")
    private UccCommdThreadCombService uccCommdThreadCombService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="service")
    private UccGetLmAllComByPageAbilityService uccGetLmAllComByPageAbilityService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="service")
    private UccSyncCommodityInfoAbilityService uccSyncCommodityInfoAbilityService;

    @RequestMapping(value={"status/local"}, method={RequestMethod.POST})
    public UccCommdStatusManageCombRspBO statusDeal(@RequestBody UccCommdStatusManageCombReqBO reqBO) {
        return this.uccCommdStatusManageCombService.manageCommd(reqBO);
    }

    @RequestMapping(value={"updateAll"}, method={RequestMethod.POST})
    public TaskRspBo batchUpdateComInfo(@RequestBody TaskReqBo reqBo) {
        LOGGER.info("\u8c03\u7528\u5546\u54c1\u53ef\u552e\u6821\u9a8c\u53ca\u4fe1\u606f\u4fee\u6539\u5b9a\u65f6\u4efb\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        TaskRspBo rspBo = new TaskRspBo();
        UccSyncCommodityInfoReqBO uccCommdThreadReqBo = new UccSyncCommodityInfoReqBO();
        String[] params = reqBo.getShardingParameter().split("&");
        if (StringUtils.isNotEmpty((String)params[0])) {
            uccCommdThreadReqBo.setSupplierShopId(Long.valueOf(params[0]));
        }
        if (StringUtils.isNotEmpty((String)params[1])) {
            uccCommdThreadReqBo.setTotalThread(Integer.valueOf(params[1]));
        }
        UccSyncCommodityInfoRspBO uccSyncCommodityInfoRspBo = this.uccSyncCommodityInfoAbilityService.dealSyncCommodity(uccCommdThreadReqBo);
        rspBo.setRsp(new Rsp(uccSyncCommodityInfoRspBo.getRespCode()));
        return rspBo;
    }

    @RequestMapping(value={"batchUpdate"}, method={RequestMethod.POST})
    public TaskRspBo statusDt(@RequestBody TaskReqBo reqBO) throws Exception {
        LOGGER.info("\u8c03\u7528\u5546\u54c1\u53ef\u552e\u6821\u9a8c\u53ca\u4ef7\u683c\u5b9a\u65f6\u4efb\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBO));
        TaskRspBo rspBo = new TaskRspBo();
        UccCommdThreadReqBO uccCommdThreadReqBO = new UccCommdThreadReqBO();
        String[] params = reqBO.getShardingParameter().split("&");
        if (StringUtils.isNotEmpty((String)params[0])) {
            uccCommdThreadReqBO.setSupplierShopId(Long.valueOf(Long.parseLong(params[0])));
        }
        if (StringUtils.isNotEmpty((String)params[1])) {
            uccCommdThreadReqBO.setShardNum(Integer.valueOf(Integer.parseInt(params[1])));
        }
        if (StringUtils.isNotEmpty((String)params[2])) {
            uccCommdThreadReqBO.setNowShard(Integer.valueOf(params[2]));
        }
        if (StringUtils.isNotEmpty((String)params[3])) {
            uccCommdThreadReqBO.setTotal(Integer.valueOf(params[3]));
        }
        UccCommdThreadRspBO uccCommdThreadRspBO = this.uccCommdThreadCombService.commdManage(uccCommdThreadReqBO);
        rspBo.setRsp(new Rsp(uccCommdThreadRspBO.getRespCode()));
        return rspBo;
    }

    @PostMapping(value={"/getLmAll"})
    public TaskRspBo getLmAll(@RequestBody TaskReqBo reqBo) {
        LOGGER.info("\u62c9\u53d6LinkedMall\u5168\u91cf\u5546\u54c1\u5b9a\u65f6\u4efb\u52a1\u5165\u53c2\uff1a" + JSON.toJSONString((Object)reqBo));
        TaskRspBo rspBo = new TaskRspBo();
        UccGetLmAllComByPageReqBO uccGetLmAllComByPageReqBo = new UccGetLmAllComByPageReqBO();
        String[] params = reqBo.getShardingParameter().split("&");
        uccGetLmAllComByPageReqBo.setTotalThread(Integer.valueOf(params[0]));
        UccGetLmAllComByPageRspBO uccGetLmAllComByPageRspBo = this.uccGetLmAllComByPageAbilityService.getLmAllComByPage(uccGetLmAllComByPageReqBo);
        rspBo.setRsp(new Rsp(uccGetLmAllComByPageRspBo.getRespCode()));
        return rspBo;
    }
}

