/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.udp.log.plugin.config;

import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.RedisCacheStore;
import com.ohaotian.plugin.mq.proxy.impl.ProxyProducerFactoryBean;
import com.ohaotian.plugin.mq.proxy.internal.ProxyMessageConfig;
import com.tydic.udp.log.plugin.intercepter.LogInterceptor;
import com.tydic.udp.log.plugin.properties.UdpLogPluginProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Order(value=-1)
@Configuration
@ConditionalOnProperty(prefix="udp.log.plugin", name={"enable"}, havingValue="true")
@EnableConfigurationProperties(value={UdpLogPluginProperties.class})
public class UdpLogPluginConfiguration
implements WebMvcConfigurer {
    private static final Logger log = LoggerFactory.getLogger(UdpLogPluginConfiguration.class);
    @Autowired
    private UdpLogPluginProperties properties;
    @Autowired
    private CacheClient cacheClient;

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new LogInterceptor(this.cacheClient, this.properties)).addPathPatterns(new String[]{"/**"});
        log.info("UDP\u65e5\u5fd7\u62e6\u622a\u751f\u6548");
    }

    @Bean(value={"pluginProvider"}, initMethod="startup", destroyMethod="shutdown")
    @ConditionalOnMissingBean(value={ProxyProducerFactoryBean.class})
    public ProxyProducerFactoryBean proxyProducerFactoryBean() {
        DefaultProxyMessageConfig config = new DefaultProxyMessageConfig();
        config.setId(this.properties.getPid());
        ProxyProducerFactoryBean proxyProducerFactoryBean = new ProxyProducerFactoryBean();
        proxyProducerFactoryBean.setMessageConfig((ProxyMessageConfig)config);
        log.info("pid:{}", (Object)config.getId());
        return proxyProducerFactoryBean;
    }

    @Bean
    @ConditionalOnMissingBean(value={RedisCacheStore.class})
    public RedisCacheStore redisCacheStore() {
        RedisCacheStore redisCacheStore = new RedisCacheStore();
        return redisCacheStore;
    }
}

