/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.udp.log.plugin.intercepter;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.udp.log.plugin.properties.UdpLogPluginProperties;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.ContentCachingResponseWrapper;

public class LogInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(LogInterceptor.class);
    private final CacheClient cacheClient;
    private final UdpLogPluginProperties properties;

    public LogInterceptor(CacheClient cacheClient, UdpLogPluginProperties properties) {
        this.cacheClient = cacheClient;
        this.properties = properties;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) {
        String requestURI = request.getRequestURI();
        log.info("preHandle\u6267\u884c,uri:{}", (Object)requestURI);
        String cacheKey = this.properties.getUdpLogPrefix() + requestURI;
        Object logInfo = this.cacheClient.get(cacheKey);
        return !ObjectUtils.isEmpty((Object)logInfo);
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        String responseBody = this.extractResponseBody(response);
        log.info("\u63d0\u53d6\u5230\u7684\u54cd\u5e94\u62a5\u6587" + responseBody);
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        super.afterCompletion(request, response, handler, ex);
    }

    private String extractResponseBody(HttpServletResponse response) throws IOException {
        if (response instanceof ContentCachingResponseWrapper) {
            ContentCachingResponseWrapper cachingResponseWrapper = (ContentCachingResponseWrapper)response;
            byte[] content = cachingResponseWrapper.getContentAsByteArray();
            return new String(content, cachingResponseWrapper.getCharacterEncoding());
        }
        return "";
    }
}

