/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.security.controller;

import com.alibaba.fastjson.JSON;
import com.ohaotian.authority.application.bo.ApplicationBO;
import com.ohaotian.authority.application.bo.SelectApplicationByUserReqBO;
import com.ohaotian.authority.application.bo.SelectApplicationByUserRspBO;
import com.ohaotian.authority.application.bo.SelectByApplicationCodeReqBO;
import com.ohaotian.authority.application.bo.SelectByApplicationCodeRspBO;
import com.ohaotian.authority.application.service.SelectApplicationByUserBusiService;
import com.ohaotian.authority.application.service.SelectByApplicationCodeBusiService;
import com.ohaotian.authority.dic.bo.SelectDicByAllReqBO;
import com.ohaotian.authority.dic.bo.SelectDicBypDicValRspBO;
import com.ohaotian.authority.dic.bo.SelectDicRspBO;
import com.ohaotian.authority.dic.service.SelectDicBypDicValBusiService;
import com.ohaotian.authority.menu.service.SelectAccessMenuService;
import com.ohaotian.authority.menu.service.SelectAuthoritysMenuService;
import com.ohaotian.authority.role.service.SelectRoleAuthoritysService;
import com.ohaotian.authority.user.service.SelectUserByLoginNameService;
import com.ohaotian.authority.user.service.SelectUserInfoService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.bo.RspMapInfoBO;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.IPUtils;
import com.tydic.umc.ability.UmcQryRelationUnionAbilityService;
import com.tydic.umc.ability.bo.UmcMemAuthenticationAbilityReqBO;
import com.tydic.umc.ability.bo.UmcMemInfoAbilityRspBO;
import com.tydic.umc.ability.bo.UmcQryRelationUnionAbilityReqBO;
import com.tydic.umc.ability.bo.UmcQryRelationUnionAbilityRspBO;
import com.tydic.umc.ability.user.UmcCheckSubMemAbilityService;
import com.tydic.umc.ability.user.UmcMemAuthenticationAbilityService;
import com.tydic.umc.security.base.UmcMemInfoBO;
import com.tydic.umc.security.base.UmcMemInfoHelper;
import com.tydic.umc.security.entity.MenuInfo;
import com.tydic.umc.security.entity.UserInfo;
import com.tydic.umc.security.jwt.UmcJwt;
import com.tydic.umc.security.service.AutzQueryService;
import com.tydic.umc.security.utils.AesUtil;
import com.tydic.umcext.ability.login.UmcLoginAbilityService;
import com.tydic.umcext.ability.login.bo.UmcLoginExpTimeAbilityReqBO;
import com.tydic.umcext.ability.login.bo.UmcLoginExpTimeAbilityRspBO;
import com.tydic.umcext.ability.login.bo.UmcPartLoginAbilityReqBO;
import com.tydic.umcext.ability.member.UmcQueryAtourUserInfoByTokenAbilityService;
import com.tydic.umcext.ability.member.UmcThirdPartMemRegistAbilityService;
import com.tydic.umcext.ability.member.bo.UmcQueryAtourUserInfoByTokenReqBO;
import com.tydic.umcext.ability.member.bo.UmcQueryAtourUserInfoByTokenRspBO;
import com.tydic.umcext.ability.member.bo.UmcThirdPartMemRegistAbilityReqBO;
import com.tydic.umcext.ability.member.bo.UmcThirdPartMemRegistAbilityRspBO;
import com.tydic.umcext.perf.ability.login.UmcGetPicVfCodeAbilityService;
import com.tydic.umcext.perf.ability.login.UmcMemLoginAuthorityAbilityService;
import com.tydic.umcext.perf.ability.login.bo.UmcGetPicVfCodeAbilityReqBO;
import com.tydic.umcext.perf.ability.login.bo.UmcGetPicVfCodeAbilityRspBO;
import com.tydic.umcext.perf.ability.login.bo.UmcGetUserMenusReqBO;
import com.tydic.umcext.perf.ability.login.bo.UmcMemLoginAuthorityAbilityReqBO;
import com.tydic.umcext.perf.ability.login.bo.UmcMemLoginAuthorityAbilityRspBO;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PermissionsController {
    private static final Logger LOGGER = LoggerFactory.getLogger(PermissionsController.class);
    @Autowired
    private SelectApplicationByUserBusiService selectApplicationByUserBusiService;
    @Autowired
    private SelectByApplicationCodeBusiService selectByApplicationCodeBusiService;
    @Autowired
    private SelectRoleAuthoritysService selectRoleAuthoritysService;
    @Autowired
    private SelectUserByLoginNameService selectUserByLoginNameService;
    @Autowired
    private UmcLoginAbilityService umcLoginAbilityService;
    @Autowired
    private SelectAuthoritysMenuService selectAuthoritysMenuService;
    @Autowired
    private SelectAccessMenuService selectAccessMenuService;
    @Autowired
    private SelectUserInfoService selectUserInfoService;
    @Autowired
    private UmcMemLoginAuthorityAbilityService umcMemLoginAuthorityAbilityService;
    @Autowired
    private UmcGetPicVfCodeAbilityService umcGetPicVfCodeAbilityService;
    @Autowired
    private UmcCheckSubMemAbilityService umcCheckSubMemAbilityService;
    @Autowired
    private AutzQueryService autzQueryService;
    @Autowired
    private UmcMemAuthenticationAbilityService umcMemAuthenticationAbilityService;
    @Autowired
    private CacheClient cacheService;
    @Value(value="${login.expTime:7200}")
    private int expTime;
    @Value(value="${login.loginNum:12}")
    private Integer loginNum;
    @Value(value="${login.lockTime:86400}")
    private int loginLockTime;
    @Value(value="${login.vfType:2}")
    private int vfType;
    @Value(value="${login.defaultVfFlag:true}")
    private Boolean defaultVfFlag;
    @Value(value="${login.defaultVfCode:1111}")
    private String defaultVfCode;
    @Value(value="${login.topDomainCookieFlag:false}")
    private Boolean topDomainCookieFlag;
    @Value(value="${login.topDomain:a.com}")
    private String topDomain;
    @Value(value="${login.originalKey:1234567890123456}")
    private String ORIGINAL_KEY;
    private static final int OFFSET = 8;
    @Autowired
    private SelectDicBypDicValBusiService selectDicBypDicValBusiService;
    @Value(value="${login.center:1}")
    private int loginCenter;
    @Value(value="${sendVfCode.rate:60}")
    private int vfCodeRate;
    @Autowired
    private UmcThirdPartMemRegistAbilityService umcThirdPartMemRegistAbilityService;
    @Autowired
    private UmcQryRelationUnionAbilityService umcQryRelationUnionAbilityService;
    @Autowired
    private UmcQueryAtourUserInfoByTokenAbilityService umcQueryAtourUserInfoByTokenAbilityService;

    @RequestMapping(value={"/auth/getUserMenus"}, method={RequestMethod.POST})
    @BusiResponseBody
    public Object getUserMenus(@RequestBody UmcGetUserMenusReqBO reqBO) {
        UmcMemInfoBO user = UmcMemInfoHelper.getCurrentUser();
        if (user != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            LOGGER.debug("getUserMenus:" + reqBO.getAppCode());
            if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{reqBO.getAppCode()})) {
                Map<String, List<MenuInfo>> menus = user.getMenus();
                SelectByApplicationCodeReqBO selectByApplicationCodeReqBO = new SelectByApplicationCodeReqBO();
                selectByApplicationCodeReqBO.setApplicationCode(reqBO.getAppCode());
                SelectByApplicationCodeRspBO application = this.selectByApplicationCodeBusiService.selectByApplicationCode(selectByApplicationCodeReqBO);
                map.put("menus", menus.get(reqBO.getAppCode()));
                if (application != null) {
                    map.put("appName", application.getApplicationBO().getApplicationName());
                }
            } else {
                SelectApplicationByUserReqBO applicationByUserReqBO = new SelectApplicationByUserReqBO();
                applicationByUserReqBO.setUserId(user.getUserId());
                applicationByUserReqBO.setOrgPath(user.getOrgPath());
                SelectApplicationByUserRspBO applicationByUserRspBO = this.selectApplicationByUserBusiService.selectApplicationByUser(applicationByUserReqBO);
                List applicationBOS = applicationByUserRspBO.getApplicationBOS();
                if (applicationBOS != null && applicationBOS.size() > 0) {
                    ApplicationBO applicationBO = (ApplicationBO)applicationBOS.get(0);
                    map.put("appName", applicationBO.getApplicationName());
                    map.put("isExt", applicationBO.getIsExt());
                    String appCode = applicationBO.getApplicationCode();
                    Map<String, List<MenuInfo>> menus = user.getMenus();
                    map.put("menus", menus.get(appCode));
                }
            }
            RspMapInfoBO rspMapInfoBO = new RspMapInfoBO();
            rspMapInfoBO.setData(map);
            return rspMapInfoBO;
        }
        throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u83dc\u5355");
    }

    @RequestMapping(value={"/auth/havePerms"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object havePerms(@RequestParam String[] authority) {
        UmcMemInfoBO user = UmcMemInfoHelper.getCurrentUser();
        if (user != null) {
            RspMapInfoBO rspMapInfoBO = new RspMapInfoBO();
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            for (String auth : authority) {
                map.put(auth, user.hasAuthority(auth));
            }
            rspMapInfoBO.setData(map);
            return rspMapInfoBO;
        }
        throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u83dc\u5355");
    }

    @RequestMapping(value={"/auth/getUserPerms"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object getUserPerms(HttpServletResponse response) {
        UmcMemInfoBO user = UmcMemInfoHelper.getCurrentUser();
        if (user != null) {
            HashSet permission = new HashSet();
            user.getPermission().forEach(perm -> permission.add(perm.getKey()));
            return permission;
        }
        throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u5bf9\u5e94\u83dc\u5355");
    }

    @RequestMapping(value={"/auth/getUserInfo"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object getUserInfo() {
        UmcMemInfoBO userInfo = UmcMemInfoHelper.getCurrentUser();
        LOGGER.debug(JSON.toJSONString((Object)userInfo));
        if (userInfo != null) {
            UmcMemInfoBO result = new UmcMemInfoBO();
            BeanUtils.copyProperties((Object)userInfo, (Object)result);
            if (userInfo != null) {
                HashSet<String> permission = new HashSet<String>();
                userInfo.getPermission().forEach(perm -> permission.add(perm.getKey()));
                result.setAuthPermission(permission);
            }
            return result;
        }
        throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u767b\u5f55\u4fe1\u606f");
    }

    @RequestMapping(value={"/auth/getFullUserInfo"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object getFullUserInfo() {
        UmcMemInfoBO userInfo = UmcMemInfoHelper.getCurrentUser();
        if (userInfo != null) {
            return userInfo;
        }
        throw new ZTBusinessException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u7528\u6237\u767b\u5f55\u4fe1\u606f");
    }

    /*
     * Enabled aggressive block sorting
     */
    @RequestMapping(value={"/umc/users/signup/login"}, method={RequestMethod.POST})
    @BusiResponseBody
    public Object getIToken(HttpServletRequest request, HttpServletResponse response, @RequestBody UmcMemLoginAuthorityAbilityReqBO reqBO) {
        UserInfo userInfo;
        Date date;
        HashMap<String, Object> payload;
        UmcMemLoginAuthorityAbilityRspBO rspBO;
        block20: {
            rspBO = new UmcMemLoginAuthorityAbilityRspBO();
            payload = new HashMap<String, Object>();
            date = new Date();
            LOGGER.debug("\u767b\u5f55\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqBO));
            Cookie[] cookies = request.getCookies();
            String sessionId = null;
            if (cookies != null) {
                for (int i = 0; i < cookies.length; ++i) {
                    if (!cookies[i].getName().equals("VF_CODE_SESSION_ID")) continue;
                    sessionId = cookies[i].getValue();
                }
            }
            userInfo = new UserInfo();
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{reqBO.getLoginName()}) && StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{reqBO.getPassWord()})) {
                Integer num = (Integer)this.cacheService.get("cas" + reqBO.getLoginName());
                if (num != null && num.equals(this.loginNum)) {
                    throw new ZTBusinessException("\u60a8\u5df2\u8fde\u7eed\u8f93\u5165\u9519\u8bef" + this.loginNum + "\u6b21\uff0c\u7981\u6b62\u5f53\u524d\u7528\u6237\u767b\u5f55");
                }
                if (num == null) {
                    num = 0;
                }
                UmcGetPicVfCodeAbilityReqBO umcGetPicVfCodeAbilityReqBO = new UmcGetPicVfCodeAbilityReqBO();
                umcGetPicVfCodeAbilityReqBO.setIp(sessionId);
                umcGetPicVfCodeAbilityReqBO.setVfCode(reqBO.getVfCode());
                if (!(this.vfType != 1 || this.defaultVfCode.equals(reqBO.getVfCode()) && this.defaultVfFlag.booleanValue())) {
                    UmcGetPicVfCodeAbilityRspBO umcGetPicVfCodeAbilityRspBO = this.umcGetPicVfCodeAbilityService.checkVfCode(umcGetPicVfCodeAbilityReqBO);
                    if (!"0000".equals(umcGetPicVfCodeAbilityRspBO.getRespCode())) {
                        throw new ZTBusinessException(umcGetPicVfCodeAbilityRspBO.getRespDesc());
                    }
                } else if (!(this.vfType != 2 || this.defaultVfCode.equals(reqBO.getVfCode()) && this.defaultVfFlag.booleanValue())) {
                    Integer veriCode = this.autzQueryService.getCurrentIdCaptcha(sessionId);
                    if (!(Float.parseFloat(reqBO.getVfCode()) < (float)(veriCode + 8))) throw new ZTBusinessException("\u6388\u6743\u5931\u8d25\uff0c\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570");
                    if (!(Float.parseFloat(reqBO.getVfCode()) > (float)(veriCode - 8))) throw new ZTBusinessException("\u6388\u6743\u5931\u8d25\uff0c\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570");
                    String string = this.autzQueryService.putCurrentIpCode(sessionId);
                } else if (this.vfType != 2 && this.vfType != 1 && this.vfType != 3 && this.vfType != 0) {
                    throw new ZTBusinessException("\u65e0\u6548\u9a8c\u8bc1\u6a21\u5f0f\uff0c\u65e0\u6cd5\u767b\u5f55");
                }
                reqBO.setAgent(request.getHeader("user-agent").trim().replaceAll("; ", ";").replaceAll("like", ""));
                reqBO.setIp(IPUtils.getIp((HttpServletRequest)request));
                LOGGER.debug("\u5bc6\u6587:{}", (Object)reqBO.getPassWord());
                LOGGER.debug("\u5bc6\u94a5:{}", (Object)this.ORIGINAL_KEY);
                String pwd = AesUtil.decryptStr(reqBO.getPassWord(), this.ORIGINAL_KEY);
                LOGGER.debug("\u660e\u6587:{}", (Object)pwd);
                reqBO.setPassWord(pwd);
                rspBO = this.loginCenter == 2 ? this.umcMemLoginAuthorityAbilityService.dealMemLogin(reqBO) : this.umcMemLoginAuthorityAbilityService.dealMemAuthLogin(reqBO);
                if ("0000".equals(rspBO.getRespCode())) {
                    payload.put("userId", rspBO.getUserId());
                    payload.put("partOrgId", rspBO.getOrgId());
                    BeanUtils.copyProperties((Object)rspBO, (Object)userInfo);
                    userInfo.setUsername(rspBO.getLoginName());
                    this.cacheService.delete("cas" + reqBO.getLoginName());
                    this.cacheService.delete("verificationCode" + sessionId);
                    break block20;
                } else {
                    String errorMessage;
                    if (!"4001".equals(rspBO.getRespCode())) throw new ZTBusinessException(rspBO.getRespDesc());
                    num = num + 1;
                    this.cacheService.set("cas" + reqBO.getLoginName(), (Object)num, this.loginLockTime);
                    Integer residualTimes = this.loginNum - num;
                    if (residualTimes > 0) {
                        errorMessage = "\u7528\u6237\u6216\u5bc6\u7801\u9519\u8bef,\u60a8\u8fd8\u6709" + residualTimes + "\u6b21\u673a\u4f1a\uff01";
                        throw new ZTBusinessException(errorMessage);
                    }
                    errorMessage = "\u60a8\u5df2\u8fde\u7eed\u8f93\u5165\u9519\u8bef" + this.loginNum + "\u6b21\uff0c\u7981\u6b62\u5f53\u524d\u7528\u6237\u767b\u5f55";
                    throw new ZTBusinessException(errorMessage);
                }
            }
            if (reqBO.getUserId() == null) throw new ZTBusinessException("\u6388\u6743\u5931\u8d25\uff0c\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570");
            if (reqBO.getUserId() == 0L) throw new ZTBusinessException("\u6388\u6743\u5931\u8d25\uff0c\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570");
            if (!this.defaultVfCode.equals(reqBO.getVfCode()) || !this.defaultVfFlag.booleanValue()) {
                String vfCode = (String)this.cacheService.get("loginVfCode" + reqBO.getUserId());
                if (StringUtils.isEmpty((CharSequence)vfCode)) {
                    throw new ZTBusinessException("\u9a8c\u8bc1\u7801\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
                }
                if (!vfCode.equals(reqBO.getVfCode())) throw new ZTBusinessException("\u9a8c\u8bc1Id\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
                payload.put("userId", reqBO.getUserId());
                this.cacheService.delete("loginVfCode" + reqBO.getUserId());
            } else {
                payload.put("userId", reqBO.getUserId());
            }
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{reqBO.getAppCode()})) {
            payload.put("appCode", reqBO.getAppCode());
        }
        payload.put("iat", date.getTime());
        String loginSource = null;
        loginSource = !StringUtils.isEmpty((CharSequence)reqBO.getLoginSource()) ? reqBO.getLoginSource() : "defaltSource";
        payload.put("loginSource", loginSource);
        String token = UmcJwt.createToken(payload);
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new ZTBusinessException("\u6388\u6743\u5931\u8d25");
        }
        UmcLoginExpTimeAbilityReqBO abilityReq = new UmcLoginExpTimeAbilityReqBO();
        abilityReq.setToken(token);
        abilityReq.setUserId(userInfo.getUserId());
        abilityReq.setLoginSource(loginSource);
        this.umcLoginAbilityService.uniqueLogin(abilityReq);
        this.umcLoginAbilityService.updateLoginExpTime(abilityReq);
        rspBO.setToken(token);
        Cookie cookie = new Cookie("auth-token", token);
        if (this.topDomainCookieFlag.booleanValue()) {
            cookie.setDomain(this.topDomain);
        }
        cookie.setPath("/");
        response.addCookie(cookie);
        return rspBO;
    }

    @RequestMapping(value={"/umc/users/signup/getVfcode"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object getPicVfCode(HttpServletRequest request, @RequestBody UmcGetPicVfCodeAbilityReqBO reqBO) {
        String sessionId = request.getSession().getId();
        reqBO.setIp(sessionId);
        return this.umcGetPicVfCodeAbilityService.getPicVfCode(reqBO);
    }

    @RequestMapping(value={"/umc/users/signup/logout"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object logout(HttpServletRequest request, HttpServletResponse response, @RequestBody UmcGetPicVfCodeAbilityReqBO reqBO) {
        String token = request.getHeader("auth-token");
        UmcLoginExpTimeAbilityReqBO abilityReq = new UmcLoginExpTimeAbilityReqBO();
        abilityReq.setToken(token);
        UmcLoginExpTimeAbilityRspBO rspBO = this.umcLoginAbilityService.logOut(abilityReq);
        Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (Cookie c : cookies) {
                if (!c.getName().equals("auth-token")) continue;
                c = new Cookie(c.getName(), null);
                if (this.topDomainCookieFlag.booleanValue()) {
                    c.setDomain(this.topDomain);
                }
                c.setPath("/");
                c.setMaxAge(0);
                response.addCookie(c);
            }
        }
        return rspBO;
    }

    @RequestMapping(value={"/umc/login/checkSubMem"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object checkSubMem(HttpServletRequest request, HttpServletResponse response, @RequestBody UmcPartLoginAbilityReqBO reqBO) {
        if (null == reqBO.getOrgIdWeb()) {
            throw new ZTBusinessException("\u6388\u6743\u5931\u8d25\uff0c\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570");
        }
        UmcQryRelationUnionAbilityReqBO umcQryRelationUnionAbilityReqBO = new UmcQryRelationUnionAbilityReqBO();
        umcQryRelationUnionAbilityReqBO.setMemId(reqBO.getMemIdIn());
        umcQryRelationUnionAbilityReqBO.setRelationId(reqBO.getOrgIdWeb());
        umcQryRelationUnionAbilityReqBO.setType(Integer.valueOf(99));
        UmcQryRelationUnionAbilityRspBO umcQryRelationUnionAbilityRspBO = this.umcQryRelationUnionAbilityService.qryRelation(umcQryRelationUnionAbilityReqBO);
        if (!"0000".equals(umcQryRelationUnionAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u5207\u6362\u767b\u5f55\u5931\u8d25");
        }
        String tokenOld = request.getHeader("auth-token");
        UmcLoginExpTimeAbilityReqBO expTimeReqBO = new UmcLoginExpTimeAbilityReqBO();
        expTimeReqBO.setToken(tokenOld);
        UmcLoginExpTimeAbilityRspBO LoginRspBO = this.umcLoginAbilityService.getLoginExpTime(expTimeReqBO);
        Long loginExpTime = 0L;
        LOGGER.debug("\u8c03\u7528\u83b7\u53d6\u5230\u671f\u65f6\u95f4\u670d\u52a1" + JSON.toJSONString((Object)LoginRspBO));
        if ("0000".equals(LoginRspBO.getRespCode())) {
            loginExpTime = LoginRspBO.getExpTime();
            LOGGER.debug("\u83b7\u53d6\u5230\u671f\u65f6\u95f4" + loginExpTime);
        }
        Map<String, Object> resultMap = UmcJwt.validToken(tokenOld, loginExpTime);
        HashMap<String, Object> payload = new HashMap<String, Object>();
        Date date = new Date();
        payload.put("iat", date.getTime());
        payload.put("userId", reqBO.getUserIdIn());
        payload.put("partOrgId", reqBO.getOrgIdWeb());
        payload.put("appCode", resultMap.get("appCode"));
        String tokenNew = UmcJwt.createToken(payload);
        if (StringUtils.isBlank((CharSequence)tokenNew)) {
            throw new ZTBusinessException("\u6388\u6743\u5931\u8d25");
        }
        UmcLoginExpTimeAbilityReqBO abilityReq = new UmcLoginExpTimeAbilityReqBO();
        abilityReq.setToken(tokenNew);
        this.umcLoginAbilityService.updateLoginExpTime(abilityReq);
        UmcLoginExpTimeAbilityReqBO logOutReq = new UmcLoginExpTimeAbilityReqBO();
        abilityReq.setToken(tokenOld);
        this.umcLoginAbilityService.logOut(logOutReq);
        Cookie cookie = new Cookie("auth-token", tokenNew);
        cookie.setPath("/");
        if (this.topDomainCookieFlag.booleanValue()) {
            cookie.setDomain(this.topDomain);
        }
        response.addCookie(cookie);
        abilityReq.setToken(tokenNew);
        abilityReq.setUserId(reqBO.getUserIdIn());
        abilityReq.setLoginSource("pc-web");
        this.umcLoginAbilityService.uniqueLogin(abilityReq);
        this.umcLoginAbilityService.updateLoginExpTime(abilityReq);
        UmcMemLoginAuthorityAbilityRspBO rspBO = new UmcMemLoginAuthorityAbilityRspBO();
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        rspBO.setToken(tokenNew);
        return rspBO;
    }

    @RequestMapping(value={"/umc/users/signup/getMobileVfCode"}, method={RequestMethod.GET, RequestMethod.POST})
    public Object getMobileVfCode(HttpServletRequest request, @RequestBody UmcMemAuthenticationAbilityReqBO reqBO) {
        Object verObj = this.cacheService.get("sendVfCode" + reqBO.getVerifyValue());
        if (null != verObj) {
            throw new ZTBusinessException(this.vfCodeRate + "\u79d2\u53ea\u80fd\u53d1\u9001\u4e00\u6b21\u9a8c\u8bc1\u7801");
        }
        String sessionId = request.getSession().getId();
        Object sessionIdObj = this.cacheService.get("sendVfCode" + sessionId);
        if (null != sessionIdObj) {
            throw new ZTBusinessException(this.vfCodeRate + "\u79d2\u53ea\u80fd\u53d1\u9001\u4e00\u6b21\u9a8c\u8bc1\u7801");
        }
        this.cacheService.set("sendVfCode" + reqBO.getVerifyValue(), (Object)reqBO.getVerifyValue(), this.vfCodeRate);
        this.cacheService.set("sendVfCode" + sessionId, (Object)sessionId, this.vfCodeRate);
        UmcMemInfoAbilityRspBO rspBO = this.umcMemAuthenticationAbilityService.getVerifyCode(reqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new ZTBusinessException(rspBO.getRespDesc());
        }
        return rspBO;
    }

    @RequestMapping(value={"/umc/delCacheDic"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object delDicCache(@RequestBody SelectDicByAllReqBO selectDicByAllReqBO) {
        Set keys = this.cacheService.getkeys("DIC_MENU_CODE_REDIS_*");
        if (!CollectionUtils.isEmpty((Collection)keys)) {
            keys.forEach(key -> this.cacheService.delete(key));
        }
        SelectDicBypDicValRspBO rspBO = new SelectDicBypDicValRspBO();
        rspBO.setCode("0");
        rspBO.setMessage("\u6210\u529f");
        return rspBO;
    }

    @RequestMapping(value={"/umc/refurshCacheDic"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object refurshCacheDic(@RequestBody SelectDicByAllReqBO selectDicByAllReqBO) {
        SelectDicRspBO selectDicBypDicValRspBO;
        String dicMenuCodeRedis = "DIC_MENU_CODE_REDIS_";
        Set keys = this.cacheService.getkeys(dicMenuCodeRedis + "*");
        if (!CollectionUtils.isEmpty((Collection)keys)) {
            keys.forEach(key -> this.cacheService.delete(key));
        }
        if (!CollectionUtils.isEmpty((Map)(selectDicBypDicValRspBO = this.selectDicBypDicValBusiService.selectDicByAll(selectDicByAllReqBO)).getDicMenuMap())) {
            selectDicBypDicValRspBO.getDicMenuMap().forEach((key, value) -> this.cacheService.set(dicMenuCodeRedis + key, value));
        }
        return selectDicBypDicValRspBO;
    }

    @RequestMapping(value={"/umc/delDicCacheSingle"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object delDicCacheSingle(@RequestBody SelectDicByAllReqBO selectDicByAllReqBO) {
        String dicMenuCodeRedis = "DIC_MENU_CODE_REDIS_";
        if (!CollectionUtils.isEmpty((Collection)selectDicByAllReqBO.getDicValues())) {
            selectDicByAllReqBO.getDicValues().forEach(dicValue -> this.cacheService.delete(dicMenuCodeRedis + dicValue));
        }
        SelectDicBypDicValRspBO selectDicBypDicValRspBO = new SelectDicBypDicValRspBO();
        selectDicBypDicValRspBO.setCode("0");
        selectDicBypDicValRspBO.setMessage("\u6210\u529f");
        return selectDicBypDicValRspBO;
    }

    @RequestMapping(value={"/umc/noauth/login/ext"}, method={RequestMethod.GET, RequestMethod.POST})
    @BusiResponseBody
    public Object dealExtLogin(HttpServletRequest request, HttpServletResponse response, @RequestBody UmcQueryAtourUserInfoByTokenReqBO reqBO) {
        HashMap<String, Object> payload = new HashMap<String, Object>();
        Date date = new Date();
        LOGGER.debug("\u767b\u5f55\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqBO));
        if (StringUtils.isBlank((CharSequence)reqBO.getToken())) {
            throw new ZTBusinessException("\u6388\u6743\u5931\u8d25\uff0c\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570");
        }
        UmcQueryAtourUserInfoByTokenRspBO umcQueryAtourUserInfoByTokenRspBO = this.umcQueryAtourUserInfoByTokenAbilityService.queryAtourUserInfo(reqBO);
        if (!"0000".equals(umcQueryAtourUserInfoByTokenRspBO.getRespCode())) {
            throw new ZTBusinessException("\u6388\u6743\u5931\u8d25\uff0c\u83b7\u53d6\u4e9a\u6735\u7528\u6237\u4fe1\u606f\u5931\u8d25");
        }
        UmcMemLoginAuthorityAbilityRspBO rspBO = new UmcMemLoginAuthorityAbilityRspBO();
        UmcThirdPartMemRegistAbilityReqBO umcThirdPartMemRegistAbilityReqBO = new UmcThirdPartMemRegistAbilityReqBO();
        umcThirdPartMemRegistAbilityReqBO.setMemNickName(umcQueryAtourUserInfoByTokenRspBO.getUserName());
        umcThirdPartMemRegistAbilityReqBO.setMemName(umcQueryAtourUserInfoByTokenRspBO.getUserName());
        umcThirdPartMemRegistAbilityReqBO.setRegAccount(umcQueryAtourUserInfoByTokenRspBO.getUserCode());
        umcThirdPartMemRegistAbilityReqBO.setRoleIds(umcQueryAtourUserInfoByTokenRspBO.getRoleIds());
        umcThirdPartMemRegistAbilityReqBO.setUserType(umcQueryAtourUserInfoByTokenRspBO.getUserType());
        umcThirdPartMemRegistAbilityReqBO.setThirdOrgIds(umcQueryAtourUserInfoByTokenRspBO.getChainIds());
        umcThirdPartMemRegistAbilityReqBO.setAgent(request.getHeader("user-agent").trim().replaceAll("; ", ";").replaceAll("like", ""));
        umcThirdPartMemRegistAbilityReqBO.setIp(IPUtils.getIp((HttpServletRequest)request));
        UmcThirdPartMemRegistAbilityRspBO umcThirdPartMemRegistAbilityRspBO = this.umcThirdPartMemRegistAbilityService.dealMemRegist(umcThirdPartMemRegistAbilityReqBO);
        if (!"0000".equals(umcThirdPartMemRegistAbilityRspBO.getRespCode())) {
            if ("4000".equals(umcThirdPartMemRegistAbilityRspBO.getRespCode())) {
                throw new ZTBusinessException("\u6388\u6743\u5931\u8d25\uff0c\u7f3a\u5c11\u5fc5\u8981\u7684\u53c2\u6570\uff1a" + umcThirdPartMemRegistAbilityRspBO.getRespDesc());
            }
            throw new ZTBusinessException(umcThirdPartMemRegistAbilityRspBO.getRespDesc());
        }
        payload.put("userId", umcThirdPartMemRegistAbilityRspBO.getUserId());
        payload.put("partOrgId", umcThirdPartMemRegistAbilityRspBO.getDefaultOrgId());
        payload.put("iat", date.getTime());
        String loginSource = "defaltSource";
        payload.put("loginSource", loginSource);
        String token = UmcJwt.createToken(payload);
        if (StringUtils.isBlank((CharSequence)token)) {
            throw new ZTBusinessException("\u6388\u6743\u5931\u8d25");
        }
        UmcLoginExpTimeAbilityReqBO abilityReq = new UmcLoginExpTimeAbilityReqBO();
        abilityReq.setToken(token);
        abilityReq.setUserId(rspBO.getUserId());
        abilityReq.setLoginSource(loginSource);
        this.umcLoginAbilityService.uniqueLogin(abilityReq);
        this.umcLoginAbilityService.updateLoginExpTime(abilityReq);
        rspBO.setToken(token);
        Cookie cookie = new Cookie("auth-token", token);
        if (this.topDomainCookieFlag.booleanValue()) {
            cookie.setDomain(this.topDomain);
        }
        cookie.setPath("/");
        response.addCookie(cookie);
        return rspBO;
    }
}

