/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.security.filter;

import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;

public class UmcCSRFilter {
    private static final Logger log = LoggerFactory.getLogger(UmcCSRFilter.class);
    @Value(value="${verify.referer}")
    private String verifyReferer;
    private String[] verifyReferers = null;

    @PostConstruct
    public void init() {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.verifyReferer})) {
            this.verifyReferers = this.verifyReferer.split(",");
        }
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        String method;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        String referer = request.getHeader("Referer");
        boolean b = false;
        if (this.verifyReferers == null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        for (String vReferer : this.verifyReferers) {
            if (referer != null && !referer.trim().startsWith(vReferer)) continue;
            b = true;
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (!b) {
            log.error("\u7591\u4f3cCSRF\u653b\u51fb\uff0creferer:" + referer);
        }
        if (!("GET".equalsIgnoreCase(method = request.getMethod()) || "POST".equalsIgnoreCase(method) || "HEAD".equalsIgnoreCase(method))) {
            log.error("The request with Method[" + method + "] was forbidden by server!");
            response.setContentType("text/html;charset=UTF-8");
            response.setCharacterEncoding("UTF-8");
            response.setStatus(403);
            response.getWriter().print("<font size=6 color=red>\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u8bf7\u6c42\u975e\u6cd5\uff0c\u7cfb\u7edf\u62d2\u7edd\u54cd\u5e94!</font>");
            return;
        }
    }
}

