/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.security.filter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.umc.security.base.UmcMemInfoBO;
import com.tydic.umc.security.base.UmcMemInfoHelper;
import com.tydic.umc.security.base.UmcUserDetails;
import com.tydic.umc.security.base.UmcUserInfoByUserIdReqBo;
import com.tydic.umc.security.filter.ParameterRequestWrapper;
import com.tydic.umc.security.jwt.UmcJwt;
import com.tydic.umc.security.jwt.UmcTokenState;
import com.tydic.umc.security.service.GetUserInfoByUserIdService;
import com.tydic.umc.security.utils.RegexUtils;
import com.tydic.umcext.ability.login.UmcLoginAbilityService;
import com.tydic.umcext.ability.login.bo.UmcLoginExpTimeAbilityReqBO;
import com.tydic.umcext.ability.login.bo.UmcLoginExpTimeAbilityRspBO;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.minidev.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.filter.GenericFilterBean;

@Order(value=0x7FFFFFFD)
@Component
public class UmcTokenAuthenticationFilter
extends GenericFilterBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcTokenAuthenticationFilter.class);
    @Value(value="${static.resources}")
    private String staticResources;
    @Value(value="${login.expTime:7200}")
    private Long expTime;
    private static final ThreadLocal<Boolean> allowSessionCreation = new ThreadLocal();
    @Autowired
    private GetUserInfoByUserIdService getUserInfoByTokenService;
    @Autowired
    private UmcLoginAbilityService umcLoginAbilityService;

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException {
        String url;
        Cookie[] cookies;
        String token = request.getHeader("auth-token");
        if ((StringUtils.isEmpty((CharSequence)token) || "123".equals(token)) && (cookies = request.getCookies()) != null) {
            for (int i = 0; i < cookies.length; ++i) {
                if (!cookies[i].getName().equals("auth-token")) continue;
                token = cookies[i].getValue();
            }
        }
        com.alibaba.fastjson.JSONObject jsonObject = new com.alibaba.fastjson.JSONObject();
        com.alibaba.fastjson.JSONObject datajsonObject = new com.alibaba.fastjson.JSONObject();
        LOGGER.debug("\u83b7\u53d6\u5f53\u524dtocken" + token);
        if (token != null) {
            if ("123".equals(token)) {
                url = request.getRequestURI();
                if (RegexUtils.wildcardEquals("**/**/noauth/**", url)) {
                    return null;
                }
                if (RegexUtils.wildcardEquals("/actuator/health$", url)) {
                    return null;
                }
            }
            try {
                UmcLoginExpTimeAbilityReqBO reqBO = new UmcLoginExpTimeAbilityReqBO();
                reqBO.setToken(token);
                UmcLoginExpTimeAbilityRspBO rspBO = this.umcLoginAbilityService.getLoginExpTime(reqBO);
                Long loginExpTime = 0L;
                LOGGER.debug("\u8c03\u7528\u83b7\u53d6\u5230\u671f\u65f6\u95f4\u670d\u52a1" + JSON.toJSONString((Object)rspBO));
                if ("0000".equals(rspBO.getRespCode())) {
                    loginExpTime = rspBO.getExpTime();
                    LOGGER.debug("\u83b7\u53d6\u5230\u671f\u65f6\u95f4" + loginExpTime);
                }
                Map<String, Object> resultMap = UmcJwt.validToken(token, loginExpTime);
                UmcTokenState state = UmcTokenState.getTokenState((String)resultMap.get("state"));
                switch (state) {
                    case VALID: {
                        JSONObject data = (JSONObject)resultMap.get("data");
                        request.setAttribute("data", (Object)data);
                        String appCode = data.getAsString("appCode");
                        Long userId = (Long)data.get((Object)"userId");
                        reqBO.setUserId(userId);
                        reqBO.setLoginSource((String)data.get((Object)"loginSource"));
                        String accessToken = (String)data.get((Object)"access-token");
                        this.umcLoginAbilityService.updateLoginExpTime(reqBO);
                        UmcUserInfoByUserIdReqBo userInfoReqBo = new UmcUserInfoByUserIdReqBo();
                        userInfoReqBo.setUserId(userId);
                        userInfoReqBo.setToken(token);
                        userInfoReqBo.setAccessToken(accessToken);
                        userInfoReqBo.setAppCode(appCode);
                        userInfoReqBo.setUri(request.getRequestURI());
                        userInfoReqBo.setSystemSource(request.getHeader("system-source"));
                        userInfoReqBo.setSystemMenuUri(request.getHeader("menu-code"));
                        UmcUserDetails user = this.getUserInfoByTokenService.getUserInfoByUserId(userInfoReqBo);
                        LOGGER.debug("\u7528\u6237\u4fe1\u606f\u83b7\u53d6respCode:{},respDesc:{}", (Object)user.getRespCode(), (Object)user.getRespDesc());
                        if ("0000".equals(user.getRespCode())) {
                            return new UsernamePasswordAuthenticationToken((Object)user.getUserDetails(), (Object)user.getUserDetails().getPassword(), user.getUserDetails().getAuthorities());
                        }
                        datajsonObject.put("respCode", (Object)user.getRespCode());
                        datajsonObject.put("respDesc", (Object)user.getRespDesc());
                        jsonObject.put("data", (Object)datajsonObject);
                        break;
                    }
                    case EXPIRED: {
                        datajsonObject.put("respCode", (Object)"AE401");
                        datajsonObject.put("respDesc", (Object)"\u767b\u5f55\u8d85\u65f6\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
                        jsonObject.put("data", (Object)datajsonObject);
                        break;
                    }
                    default: {
                        datajsonObject.put("respCode", (Object)"AE401");
                        datajsonObject.put("respDesc", (Object)"\u767b\u5f55\u4fe1\u606f\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
                        jsonObject.put("data", (Object)datajsonObject);
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.logger.error((Object)("token\u89e3\u6790\u5f02\u5e38!" + request.getRequestURI() + "\u9519\u8bef\u4fe1\u606f\uff1a" + e));
                datajsonObject.put("respCode", (Object)"AE401");
                datajsonObject.put("respDesc", (Object)"\u767b\u5f55\u4fe1\u606f\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
                jsonObject.put("data", (Object)datajsonObject);
            }
        } else {
            url = request.getRequestURI();
            if (RegexUtils.wildcardEquals("**/**/noauth/**", url)) {
                return null;
            }
            if (RegexUtils.wildcardEquals("/actuator/health$", url)) {
                return null;
            }
            datajsonObject.put("respCode", (Object)"AE401");
            datajsonObject.put("respDesc", (Object)"\u767b\u5f55\u4fe1\u606f\u65e0\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
            jsonObject.put("data", (Object)datajsonObject);
        }
        List<String> errorCodeList = Arrays.asList("AE4003", "AE4001", "AE4001FAIL", "99999");
        if (errorCodeList.contains(datajsonObject.getString("respCode"))) {
            response.setStatus(999);
        } else if ("AE403".equals(datajsonObject.getString("respCode"))) {
            response.setStatus(403);
        } else {
            response.setStatus(401);
        }
        response.setContentType("text/html;charset=UTF-8");
        PrintWriter out = response.getWriter();
        jsonObject.put("code", (Object)"1");
        jsonObject.put("message", (Object)"\u5931\u8d25");
        String jsonString = JSON.toJSONString((Object)jsonObject, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue, SerializerFeature.WriteNullStringAsEmpty});
        out.write(jsonString);
        out.close();
        return null;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        Authentication auth;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        ServletRequest requestWrapper = null;
        String url = request.getRequestURI();
        boolean needToken = true;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.staticResources})) {
            String[] split;
            for (String staticResource : split = this.staticResources.split(";")) {
                if (!RegexUtils.wildcardEquals(staticResource, url)) continue;
                needToken = false;
            }
        }
        if (RegexUtils.wildcardEquals("**/**/users/signup/**", url)) {
            needToken = false;
        }
        if (RegexUtils.wildcardEquals("**/**/oauth/**", url)) {
            needToken = false;
        }
        if (RegexUtils.wildcardEquals("**/**/api/token/get", url)) {
            needToken = false;
        }
        if (RegexUtils.wildcardEquals("**/pobstyle.css", url)) {
            needToken = false;
        }
        allowSessionCreation.set(true);
        if (needToken && (auth = this.attemptAuthentication(request, response)) != null) {
            allowSessionCreation.set(false);
            SecurityContextHolder.getContext().setAuthentication(auth);
            requestWrapper = this.parameterRequest(request.getHeader("auth-token"), request, response);
        }
        if (requestWrapper == null) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            LOGGER.debug("UmcUserInfoWrapperFilter---1\uff1a");
        } else {
            LOGGER.debug("UmcUserInfoWrapperFilter---2\uff1a");
            chain.doFilter(requestWrapper, (ServletResponse)response);
        }
    }

    private ServletRequest parameterRequest(String token, HttpServletRequest request, HttpServletResponse response) {
        UmcMemInfoBO userInfo = UmcMemInfoHelper.getCurrentUser();
        ParameterRequestWrapper requestWrapper = null;
        if (userInfo != null) {
            if (LOGGER.isDebugEnabled()) {
                // empty if block
            }
            if (userInfo.getUserId() != null && request instanceof HttpServletRequest) {
                LOGGER.debug("UmcUserInfoWrapperFilter---\u81ea\u5b9a\u4e49\u5305\u88c5\u5668\uff1a");
                requestWrapper = new ParameterRequestWrapper(request);
            }
        }
        LOGGER.debug("UmcUserInfoWrapperFilter---requestWrapper\uff1a");
        return requestWrapper;
    }

    public static boolean isAllowSessionCreation() {
        return allowSessionCreation.get();
    }
}

