/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.ability.impl;

import com.tydic.umc.ability.DictionaryAbilityService;
import com.tydic.umc.ability.bo.DicDictionaryBO;
import com.tydic.umc.ability.bo.DictionaryAbilityRspBO;
import com.tydic.umc.ability.bo.QueryDictionaryAbilityReqBO;
import com.tydic.umc.base.bo.UmcRspListBO;
import com.tydic.umc.base.bo.UmcRspPageBO;
import com.tydic.umc.busi.DictionaryBusiService;
import com.tydic.umc.busi.bo.DictionaryBusiReqBO;
import com.tydic.umc.common.UmcDicDictionaryReqBO;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.util.UmcBusinessException;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;

@Service(version="1.0.0", group="service", interfaceClass=DictionaryAbilityService.class)
public class DictionaryAbilityServiceImpl
implements DictionaryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(DictionaryAbilityServiceImpl.class);
    @Autowired
    private DictionaryBusiService dictionaryBusiService;

    public UmcRspListBO<DicDictionaryBO> queryBypCodeBackPo(QueryDictionaryAbilityReqBO abilityReqBO) {
        UmcRspListBO result = new UmcRspListBO();
        List busiList = this.dictionaryBusiService.queryBypCodeBackPo("UMC", abilityReqBO.getPcode(), abilityReqBO.getTitle());
        result.setRows(busiList);
        result.setRespCode("0000");
        result.setRespDesc("\u67e5\u8be2\u6210\u529f");
        return result;
    }

    public UmcRspPageBO<DicDictionaryBO> queryBypCodeBackPoPage(QueryDictionaryAbilityReqBO abilityReqBO) {
        UmcRspPageBO result = new UmcRspPageBO();
        DictionaryBusiReqBO dictionaryBusiReqBO = new DictionaryBusiReqBO();
        BeanUtils.copyProperties((Object)abilityReqBO, (Object)dictionaryBusiReqBO);
        UmcRspPageBO busiList = this.dictionaryBusiService.queryBypCodeBackPoPage(dictionaryBusiReqBO);
        BeanUtils.copyProperties((Object)busiList, (Object)result);
        return result;
    }

    public DictionaryAbilityRspBO updateDicDictionary(UmcDicDictionaryReqBO umcDicDictionaryBO) {
        this.validationParamsInvoice(umcDicDictionaryBO);
        DictionaryAbilityRspBO dictionaryAbilityRspBO = new DictionaryAbilityRspBO();
        dictionaryAbilityRspBO.setRespCode("0000");
        dictionaryAbilityRspBO.setRespDesc("\u6210\u529f");
        int checkResult = this.dictionaryBusiService.checkDicBy(umcDicDictionaryBO.getCode(), umcDicDictionaryBO.getPCode());
        if (checkResult < 1) {
            dictionaryAbilityRspBO.setRespCode("6033");
            dictionaryAbilityRspBO.setRespDesc("\u8be5\u5b57\u5178\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return dictionaryAbilityRspBO;
        }
        umcDicDictionaryBO.setSysCode("UMC");
        umcDicDictionaryBO.setDelflag(UmcCommConstant.DicDelFlag.YES);
        int result = this.dictionaryBusiService.updateDicDictionary(umcDicDictionaryBO);
        if (result < 1) {
            dictionaryAbilityRspBO.setRespCode("6033");
            dictionaryAbilityRspBO.setRespDesc("\u4fee\u6539\u5931\u8d25");
        }
        return dictionaryAbilityRspBO;
    }

    public DictionaryAbilityRspBO deleteDicDictionary(UmcDicDictionaryReqBO umcDicDictionaryBO) {
        this.validationParamsInvoice(umcDicDictionaryBO);
        DictionaryAbilityRspBO dictionaryAbilityRspBO = new DictionaryAbilityRspBO();
        dictionaryAbilityRspBO.setRespCode("0000");
        dictionaryAbilityRspBO.setRespDesc("\u6210\u529f");
        int checkResult = this.dictionaryBusiService.checkDicBy(umcDicDictionaryBO.getCode(), umcDicDictionaryBO.getPCode());
        if (checkResult < 1) {
            dictionaryAbilityRspBO.setRespCode("6033");
            dictionaryAbilityRspBO.setRespDesc("\u8be5\u5b57\u5178\u8bb0\u5f55\u4e0d\u5b58\u5728");
            return dictionaryAbilityRspBO;
        }
        int result = this.dictionaryBusiService.deleteDicDictionary(umcDicDictionaryBO);
        if (result < 1) {
            dictionaryAbilityRspBO.setRespCode("6033");
            dictionaryAbilityRspBO.setRespDesc("\u5220\u9664\u5931\u8d25");
        }
        return dictionaryAbilityRspBO;
    }

    public DictionaryAbilityRspBO addDicDictionary(UmcDicDictionaryReqBO umcDicDictionaryBO) {
        this.validationParamsInvoice(umcDicDictionaryBO);
        DictionaryAbilityRspBO dictionaryAbilityRspBO = new DictionaryAbilityRspBO();
        dictionaryAbilityRspBO.setRespCode("0000");
        dictionaryAbilityRspBO.setRespDesc("\u6210\u529f");
        int checkResult = this.dictionaryBusiService.checkDicBy(umcDicDictionaryBO.getCode(), umcDicDictionaryBO.getPCode());
        if (checkResult > 0) {
            dictionaryAbilityRspBO.setRespCode("6033");
            dictionaryAbilityRspBO.setRespDesc("\u8be5\u5b57\u5178\u5df2\u5b58\u5728");
            return dictionaryAbilityRspBO;
        }
        umcDicDictionaryBO.setDelflag(UmcCommConstant.DicDelFlag.YES);
        umcDicDictionaryBO.setSysCode("UMC");
        int result = this.dictionaryBusiService.addDicDictionary(umcDicDictionaryBO);
        if (result < 1) {
            dictionaryAbilityRspBO.setRespCode("6033");
            dictionaryAbilityRspBO.setRespDesc("\u65b0\u589e\u5931\u8d25");
        }
        return dictionaryAbilityRspBO;
    }

    @RequestMapping(value={"queryBypCodeBackPoByPcode"})
    public Map<String, String> queryBypCodeBackPo(String pCode) {
        return this.dictionaryBusiService.queryBypCodeBackMap("UMC", pCode);
    }

    private void validationParamsInvoice(UmcDicDictionaryReqBO reqBO) {
        if (StringUtils.isEmpty((CharSequence)reqBO.getPCode())) {
            throw new UmcBusinessException("8000", "\u5b57\u5178\u670d\u52a1\u5165\u53c2[pcode]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getCode())) {
            throw new UmcBusinessException("8000", "\u5b57\u5178\u670d\u52a1\u5165\u53c2[code]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

