/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.ability.impl;

import com.tydic.umc.ability.UmcLogisticsRelaAbilityService;
import com.tydic.umc.ability.bo.LogisticsRelaAbilityBO;
import com.tydic.umc.ability.bo.UmcLogisticsRelaAbilitReqBO;
import com.tydic.umc.ability.bo.UmcLogisticsRelaAbilityRspBO;
import com.tydic.umc.base.bo.UmcRspListBO;
import com.tydic.umc.busi.UmcLogisticsRelaAddBusiService;
import com.tydic.umc.busi.UmcLogisticsRelaCertUpdateBusiService;
import com.tydic.umc.busi.UmcLogisticsRelaDefaultSetBusiService;
import com.tydic.umc.busi.UmcLogisticsRelaDeleteBusiService;
import com.tydic.umc.busi.UmcLogisticsRelaQueryBusiService;
import com.tydic.umc.busi.UmcLogisticsRelaUpdateBusiService;
import com.tydic.umc.busi.UmcMemUserManageBusiService;
import com.tydic.umc.busi.bo.LogisticsRelaBusiBO;
import com.tydic.umc.busi.bo.MemUserBO;
import com.tydic.umc.busi.bo.UmcLogisticsRelaAddBusiReqBO;
import com.tydic.umc.busi.bo.UmcLogisticsRelaAddBusiRspBO;
import com.tydic.umc.busi.bo.UmcLogisticsRelaCertUpdateBusiReqBO;
import com.tydic.umc.busi.bo.UmcLogisticsRelaCertUpdateBusiRspBO;
import com.tydic.umc.busi.bo.UmcLogisticsRelaDefaultSetBusiReqBO;
import com.tydic.umc.busi.bo.UmcLogisticsRelaDefaultSetBusiRspBO;
import com.tydic.umc.busi.bo.UmcLogisticsRelaDeleteBusiReqBO;
import com.tydic.umc.busi.bo.UmcLogisticsRelaDeleteBusiRspBO;
import com.tydic.umc.busi.bo.UmcLogisticsRelaQueryBusiReqBO;
import com.tydic.umc.busi.bo.UmcLogisticsRelaQueryBusiRspBO;
import com.tydic.umc.busi.bo.UmcLogisticsRelaUpdateBusiReqBO;
import com.tydic.umc.busi.bo.UmcLogisticsRelaUpdateBusiRspBO;
import com.tydic.umc.busi.bo.UmcMemUserBusiReqBO;
import com.tydic.umc.util.UmcBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@Service(version="1.0.0", group="service", interfaceClass=UmcLogisticsRelaAbilityService.class)
public class UmcLogisticsRelaAbilityServiceImpl
implements UmcLogisticsRelaAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UmcLogisticsRelaAbilityServiceImpl.class);
    private static final String ERROR_MSG = "\u6536\u8d27\u5730\u5740\u4fe1\u606f\u7ef4\u62a4\u670d\u52a1\u6267\u884c\u5931\u8d25";
    private static final String PARAM_MSG = "\u6536\u8d27\u5730\u5740\u4fe1\u606f\u7ef4\u62a4\u670d\u52a1\u5165\u53c2";
    private static final String OPERTYPE_ADD = "1";
    private static final String OPERTYPE_UPDATE = "2";
    private static final String OPERTYPE_DELETE = "3";
    private static final String OPERTYPE_DEFAULT_SET = "4";
    private static final String OPERTYPE_QUERY = "5";
    private static final String OPERTYPE_ASSIGNMENT = "6";
    private static final String OPERTYPE_UPDATE_CERT = "7";
    @Autowired
    private UmcLogisticsRelaAddBusiService umcLogisticsRelaAddBusiService;
    @Autowired
    private UmcLogisticsRelaUpdateBusiService umcLogisticsRelaUpdateBusiService;
    @Autowired
    private UmcLogisticsRelaDeleteBusiService umcLogisticsRelaDeleteBusiService;
    @Autowired
    private UmcLogisticsRelaDefaultSetBusiService umcLogisticsRelaDefaultSetBusiService;
    @Autowired
    private UmcLogisticsRelaQueryBusiService umcLogisticsRelaQueryBusiService;
    @Autowired
    private UmcMemUserManageBusiService umcMemUserManageBusiService;
    @Autowired
    private UmcLogisticsRelaCertUpdateBusiService umcLogisticsRelaCertUpdateBusiService;

    public UmcLogisticsRelaAbilityRspBO operLogisticsRela(UmcLogisticsRelaAbilitReqBO reqBO) {
        this.validateArg(reqBO);
        UmcLogisticsRelaAbilityRspBO rspBO = new UmcLogisticsRelaAbilityRspBO();
        if (OPERTYPE_ADD.equals(reqBO.getOperType()) || OPERTYPE_ASSIGNMENT.equals(reqBO.getOperType())) {
            UmcLogisticsRelaAddBusiReqBO addReqBO = new UmcLogisticsRelaAddBusiReqBO();
            addReqBO.setMemId(reqBO.getMemId());
            addReqBO.setAdmOrgId(reqBO.getOrgIdWeb());
            addReqBO.setMemIds(reqBO.getMemIds());
            ArrayList<LogisticsRelaBusiBO> logisticsRelaBusiBOList = new ArrayList<LogisticsRelaBusiBO>();
            for (LogisticsRelaAbilityBO abilityBO : reqBO.getLogisticsRelaList()) {
                LogisticsRelaBusiBO busiBO = new LogisticsRelaBusiBO();
                BeanUtils.copyProperties((Object)abilityBO, (Object)busiBO);
                logisticsRelaBusiBOList.add(busiBO);
            }
            addReqBO.setLogisticsRelaList(logisticsRelaBusiBOList);
            addReqBO.setOperType(reqBO.getOperType());
            UmcLogisticsRelaAddBusiRspBO addRspBO = this.umcLogisticsRelaAddBusiService.addLogisticsRela(addReqBO);
            rspBO.setRespCode(addRspBO.getRespCode());
            rspBO.setRespDesc(addRspBO.getRespDesc());
        } else if (OPERTYPE_UPDATE.equals(reqBO.getOperType())) {
            UmcLogisticsRelaUpdateBusiReqBO updateReqBO = new UmcLogisticsRelaUpdateBusiReqBO();
            updateReqBO.setMemId(reqBO.getMemId());
            ArrayList<LogisticsRelaBusiBO> logisticsRelaBusiBOList = new ArrayList<LogisticsRelaBusiBO>();
            for (LogisticsRelaAbilityBO abilityBO : reqBO.getLogisticsRelaList()) {
                LogisticsRelaBusiBO busiBO = new LogisticsRelaBusiBO();
                BeanUtils.copyProperties((Object)abilityBO, (Object)busiBO);
                logisticsRelaBusiBOList.add(busiBO);
            }
            updateReqBO.setLogisticsRelaList(logisticsRelaBusiBOList);
            UmcLogisticsRelaUpdateBusiRspBO updateRspBO = this.umcLogisticsRelaUpdateBusiService.updateLogisticsRela(updateReqBO);
            rspBO.setRespCode(updateRspBO.getRespCode());
            rspBO.setRespDesc(updateRspBO.getRespDesc());
        } else if (OPERTYPE_DELETE.equals(reqBO.getOperType())) {
            UmcLogisticsRelaDeleteBusiReqBO deleteReqBO = new UmcLogisticsRelaDeleteBusiReqBO();
            deleteReqBO.setMemId(reqBO.getMemId());
            deleteReqBO.setContactId(reqBO.getContactId());
            if (reqBO.getLogisticsRelaList() != null) {
                ArrayList<LogisticsRelaBusiBO> logisticsRelaBusiBOList = new ArrayList<LogisticsRelaBusiBO>();
                for (LogisticsRelaAbilityBO abilityBO : reqBO.getLogisticsRelaList()) {
                    LogisticsRelaBusiBO busiBO = new LogisticsRelaBusiBO();
                    BeanUtils.copyProperties((Object)abilityBO, (Object)busiBO);
                    logisticsRelaBusiBOList.add(busiBO);
                }
                deleteReqBO.setLogisticsRelaList(logisticsRelaBusiBOList);
            }
            UmcLogisticsRelaDeleteBusiRspBO deleteRspBO = this.umcLogisticsRelaDeleteBusiService.deleteLogisticsRela(deleteReqBO);
            rspBO.setRespCode(deleteRspBO.getRespCode());
            rspBO.setRespDesc(deleteRspBO.getRespDesc());
        } else if (OPERTYPE_DEFAULT_SET.equals(reqBO.getOperType())) {
            UmcLogisticsRelaDefaultSetBusiReqBO defaultSetReqBO = new UmcLogisticsRelaDefaultSetBusiReqBO();
            defaultSetReqBO.setMemId(reqBO.getMemId());
            defaultSetReqBO.setContactId(reqBO.getContactId());
            UmcLogisticsRelaDefaultSetBusiRspBO defaultSetRspBO = this.umcLogisticsRelaDefaultSetBusiService.dealLogisticsRelaDefaultset(defaultSetReqBO);
            rspBO.setRespCode(defaultSetRspBO.getRespCode());
            rspBO.setRespDesc(defaultSetRspBO.getRespDesc());
        } else if (OPERTYPE_QUERY.equals(reqBO.getOperType())) {
            UmcLogisticsRelaQueryBusiReqBO queryBusiReqBO = new UmcLogisticsRelaQueryBusiReqBO();
            queryBusiReqBO.setMemId(reqBO.getMemId());
            queryBusiReqBO.setContactAddress(reqBO.getContactAddress());
            queryBusiReqBO.setContactCompany(reqBO.getContactCompany());
            queryBusiReqBO.setContactMobile(reqBO.getContactMobile());
            queryBusiReqBO.setContactName(reqBO.getContactName());
            queryBusiReqBO.setContactId(reqBO.getContactId());
            queryBusiReqBO.setIsDefault(reqBO.getIsDefault());
            queryBusiReqBO.setAreaCode(reqBO.getAreaCode());
            queryBusiReqBO.setAreaName(reqBO.getAreaName());
            queryBusiReqBO.setContactCountyId(reqBO.getContactCountyId());
            queryBusiReqBO.setContactProvinceId(reqBO.getContactProvinceId());
            queryBusiReqBO.setContactCityId(reqBO.getContactCityId());
            queryBusiReqBO.setContactCountryId(reqBO.getContactCountryId());
            queryBusiReqBO.setPageNo(reqBO.getPageNo());
            queryBusiReqBO.setPageSize(reqBO.getPageSize());
            queryBusiReqBO.setAdmOrgId(reqBO.getAdmOrgId());
            queryBusiReqBO.setNameOrPhoneNumber(reqBO.getNameOrPhoneNumber());
            queryBusiReqBO.setOrderBy(reqBO.getOrderBy());
            queryBusiReqBO.setMgOrgIdsExt(reqBO.getMgOrgIdsExt());
            queryBusiReqBO.setOrgIdWeb(reqBO.getOrgIdWeb());
            queryBusiReqBO.setPreciseContactMobile(reqBO.getPreciseContactMobile());
            queryBusiReqBO.setContactMemId(reqBO.getContactMemId());
            UmcLogisticsRelaQueryBusiRspBO queryBusiRspBO = this.umcLogisticsRelaQueryBusiService.queryLogisticsRela(queryBusiReqBO);
            ArrayList<LogisticsRelaAbilityBO> logisticsRelaAbilityBOList = new ArrayList<LogisticsRelaAbilityBO>();
            if (!CollectionUtils.isEmpty((Collection)queryBusiRspBO.getRows())) {
                for (LogisticsRelaBusiBO logisticsRelaBusiBO : queryBusiRspBO.getRows()) {
                    LogisticsRelaAbilityBO logisticsRelaAbilityBO = new LogisticsRelaAbilityBO();
                    BeanUtils.copyProperties((Object)logisticsRelaBusiBO, (Object)logisticsRelaAbilityBO);
                    logisticsRelaAbilityBOList.add(logisticsRelaAbilityBO);
                }
            }
            rspBO.setRecordsTotal(queryBusiRspBO.getRecordsTotal());
            rspBO.setTotal(queryBusiRspBO.getTotal());
            rspBO.setPageNo(queryBusiRspBO.getPageNo());
            rspBO.setRows(logisticsRelaAbilityBOList);
            rspBO.setRespCode(queryBusiRspBO.getRespCode());
            rspBO.setRespDesc(queryBusiRspBO.getRespDesc());
        } else if (OPERTYPE_UPDATE_CERT.equals(reqBO.getOperType())) {
            UmcLogisticsRelaCertUpdateBusiReqBO umcLogisticsRelaCertUpdateBusiReqBO = new UmcLogisticsRelaCertUpdateBusiReqBO();
            umcLogisticsRelaCertUpdateBusiReqBO.setCertName(reqBO.getCertName());
            umcLogisticsRelaCertUpdateBusiReqBO.setCertNo(reqBO.getCertNo());
            umcLogisticsRelaCertUpdateBusiReqBO.setContactId(Long.valueOf(reqBO.getContactId()));
            umcLogisticsRelaCertUpdateBusiReqBO.setMemId(reqBO.getMemId());
            UmcLogisticsRelaCertUpdateBusiRspBO umcLogisticsRelaCertUpdateBusiRspBO = this.umcLogisticsRelaCertUpdateBusiService.updateCert(umcLogisticsRelaCertUpdateBusiReqBO);
            BeanUtils.copyProperties((Object)umcLogisticsRelaCertUpdateBusiRspBO, (Object)rspBO);
        } else {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u6536\u8d27\u5730\u5740\u4fe1\u606f\u7ef4\u62a4\u670d\u52a1\u6267\u884c\u5931\u8d25,\u672a\u77e5\u7684\u64cd\u4f5c\u7c7b\u578b");
        }
        return rspBO;
    }

    private void validateArg(UmcLogisticsRelaAbilitReqBO reqBO) {
        if (null == reqBO) {
            throw new UmcBusinessException("8000", "\u6536\u8d27\u5730\u5740\u4fe1\u606f\u7ef4\u62a4\u670d\u52a1\u5165\u53c2\u5bf9\u8c61[req]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getOperType())) {
            throw new UmcBusinessException("8000", "\u6536\u8d27\u5730\u5740\u4fe1\u606f\u7ef4\u62a4\u670d\u52a1\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b[operType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getContactId() && (reqBO.getMemId() == null || reqBO.getMemId() == 0L) && reqBO.getUserId() == null && null == reqBO.getOrgIdWeb()) {
            throw new UmcBusinessException("8000", "\u6536\u8d27\u5730\u5740\u4fe1\u606f\u7ef4\u62a4\u670d\u52a1\u6267\u884c\u5931\u8d25\u4f1a\u5458ID[memId]\u3001[userId]\u548c[orgIdWeb]\u53c2\u6570\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (null != reqBO.getUserId()) {
            UmcMemUserBusiReqBO umcMemUserBusiReqBO = new UmcMemUserBusiReqBO();
            umcMemUserBusiReqBO.setUsreIdWeb(reqBO.getUserId());
            UmcRspListBO busiRsp = this.umcMemUserManageBusiService.queryMemUserList(umcMemUserBusiReqBO);
            if (CollectionUtils.isEmpty((Collection)busiRsp.getRows())) {
                throw new UmcBusinessException("8000", "\u7528\u6237\u3010" + reqBO.getUserId() + "\u3011\u4e0d\u5b58\u5728");
            }
            reqBO.setMemId(((MemUserBO)busiRsp.getRows().get(0)).getMemId());
        }
        if (OPERTYPE_DEFAULT_SET.equals(reqBO.getOperType())) {
            if (StringUtils.isBlank((CharSequence)reqBO.getContactId())) {
                throw new UmcBusinessException("8000", "\u6536\u8d27\u5730\u5740\u4fe1\u606f\u7ef4\u62a4\u670d\u52a1\u5165\u53c2\u8054\u7cfb\u4ebaID[contactId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else if (OPERTYPE_ADD.equals(reqBO.getOperType()) || OPERTYPE_UPDATE.equals(reqBO.getOperType())) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getLogisticsRelaList())) {
                throw new UmcBusinessException("8000", "\u6536\u8d27\u5730\u5740\u4fe1\u606f\u7ef4\u62a4\u670d\u52a1\u5165\u53c2\u6536\u8d27\u4fe1\u606f[logisticsRelaList]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (LogisticsRelaAbilityBO logisticsRelaBO : reqBO.getLogisticsRelaList()) {
                if (OPERTYPE_ADD.equals(reqBO.getOperType()) || OPERTYPE_UPDATE.equals(reqBO.getOperType())) {
                    if (StringUtils.isBlank((CharSequence)logisticsRelaBO.getContactAddress())) {
                        throw new UmcBusinessException("8000", "\u6536\u8d27\u5730\u5740\u4fe1\u606f\u7ef4\u62a4\u670d\u52a1\u5165\u53c2\u6536\u8d27\u4fe1\u606f[logisticsRelaList]\u4e2d\u7684\u8054\u7cfb\u4eba\u5730\u5740[contactAddress]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((CharSequence)logisticsRelaBO.getContactName())) {
                        throw new UmcBusinessException("8000", "\u6536\u8d27\u5730\u5740\u4fe1\u606f\u7ef4\u62a4\u670d\u52a1\u5165\u53c2\u6536\u8d27\u4fe1\u606f[logisticsRelaList]\u4e2d\u7684\u8054\u7cfb\u4eba\u59d3\u540d[contactName]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                    if (StringUtils.isBlank((CharSequence)logisticsRelaBO.getContactMobile())) {
                        throw new UmcBusinessException("8000", "\u6536\u8d27\u5730\u5740\u4fe1\u606f\u7ef4\u62a4\u670d\u52a1\u5165\u53c2\u6536\u8d27\u4fe1\u606f[logisticsRelaList]\u4e2d\u7684\u8054\u7cfb\u4eba\u624b\u673a[contactMobile]\u4e0d\u80fd\u4e3a\u7a7a");
                    }
                }
                if (!OPERTYPE_UPDATE.equals(reqBO.getOperType()) || !StringUtils.isBlank((CharSequence)logisticsRelaBO.getContactId())) continue;
                throw new UmcBusinessException("8000", "\u6536\u8d27\u5730\u5740\u4fe1\u606f\u7ef4\u62a4\u670d\u52a1\u5165\u53c2\u6536\u8d27\u4fe1\u606f[logisticsRelaList]\u4e2d\u7684\u8054\u7cfb\u4ebaID[contactId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (OPERTYPE_DELETE.equals(reqBO.getOperType()) && reqBO.getContactId() == null && CollectionUtils.isEmpty((Collection)reqBO.getLogisticsRelaList())) {
            throw new UmcBusinessException("8000", "\u6536\u8d27\u5730\u5740\u4fe1\u606f\u7ef4\u62a4\u670d\u52a1\u5165\u53c2\u5220\u9664\u65f6[contactId]\u548c[logisticsRelaList]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (OPERTYPE_ASSIGNMENT.equals(reqBO.getOperType())) {
            if (null == reqBO.getMemId() && CollectionUtils.isEmpty((Collection)reqBO.getMemIds())) {
                throw new UmcBusinessException("8000", "\u6536\u8d27\u5730\u5740\u4fe1\u606f\u7ef4\u62a4\u670d\u52a1\u5165\u53c2\u5206\u914d\u7528\u6237\u5730\u5740\u65f6[memId]\u548c[memIds]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            }
            if (CollectionUtils.isEmpty((Collection)reqBO.getLogisticsRelaList())) {
                throw new UmcBusinessException("8000", "\u6536\u8d27\u5730\u5740\u4fe1\u606f\u7ef4\u62a4\u670d\u52a1\u5165\u53c2\u5206\u914d\u7528\u6237\u5730\u5740\u65f6[logisticsRelaList]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            reqBO.getLogisticsRelaList().forEach(bo -> {
                if (StringUtils.isBlank((CharSequence)bo.getContactId())) {
                    throw new UmcBusinessException("8000", "\u6536\u8d27\u5730\u5740\u4fe1\u606f\u7ef4\u62a4\u670d\u52a1\u5165\u53c2\u5206\u914d\u7528\u6237\u5730\u5740\u65f6[logisticsRelaList.contactId]\u4e0d\u80fd\u4e3a\u7a7a");
                }
            });
        }
        if (OPERTYPE_UPDATE_CERT.equals(reqBO.getOperType())) {
            if (StringUtils.isBlank((CharSequence)reqBO.getContactId())) {
                throw new UmcBusinessException("8000", "\u6536\u8d27\u5730\u5740\u4fe1\u606f\u7ef4\u62a4\u670d\u52a1\u5165\u53c2\u8bbe\u7f6e\u8bc1\u4ef6\u4fe1\u606f\u65f6[contactId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == reqBO.getMemId()) {
                throw new UmcBusinessException("8000", "\u6536\u8d27\u5730\u5740\u4fe1\u606f\u7ef4\u62a4\u670d\u52a1\u5165\u53c2\u8bbe\u7f6e\u8bc1\u4ef6\u4fe1\u606f\u65f6[memId]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getCertName())) {
                throw new UmcBusinessException("8000", "\u6536\u8d27\u5730\u5740\u4fe1\u606f\u7ef4\u62a4\u670d\u52a1\u5165\u53c2\u8bbe\u7f6e\u8bc1\u4ef6\u4fe1\u606f\u65f6[certName]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (null == reqBO.getCertNo()) {
                throw new UmcBusinessException("8000", "\u6536\u8d27\u5730\u5740\u4fe1\u606f\u7ef4\u62a4\u670d\u52a1\u5165\u53c2\u8bbe\u7f6e\u8bc1\u4ef6\u4fe1\u606f\u65f6[certNo]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

