/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.umc.ability.bo.UmcMemAuthenticationAbilityReqBO;
import com.tydic.umc.ability.bo.UmcMemInfoAbilityRspBO;
import com.tydic.umc.ability.user.UmcMemAuthenticationAbilityService;
import com.tydic.umc.base.bo.UmcRspListBO;
import com.tydic.umc.busi.UmcMemManageBusiService;
import com.tydic.umc.busi.bo.MemberBusiBO;
import com.tydic.umc.busi.bo.UmcQueryMemBaseInfoBusiReqBO;
import com.tydic.umc.comb.UmcCheckUserExistCombService;
import com.tydic.umc.comb.UmcMemInfoUpdateCombService;
import com.tydic.umc.comb.bo.UmcCheckUserExistCombReqBO;
import com.tydic.umc.comb.bo.UmcCheckUserExistCombRspBO;
import com.tydic.umc.comb.bo.UmcMemInfoUpdateCombReqBO;
import com.tydic.umc.comb.bo.UmcMemInfoUpdateCombRspBO;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.external.notice.bo.UmcExternalCallHttpSendMassageReqBO;
import com.tydic.umc.external.notice.bo.UmcExternalCallHttpSendMassageRspBO;
import com.tydic.umc.external.notice.bo.UmcNoticeBaseBo;
import com.tydic.umc.external.notice.bo.UmcNoticeMessageOnlyBO;
import com.tydic.umc.facde.NoticeServiceHolder;
import com.tydic.umc.util.AesEcbUtil;
import com.tydic.umc.util.UmcBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

@Service(version="1.0.0", group="service", interfaceClass=UmcMemAuthenticationAbilityService.class)
public class UmcMemAuthenticationAbilityServiceImpl
implements UmcMemAuthenticationAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UmcMemAuthenticationAbilityServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcMemAuthenticationAbilityServiceImpl.class);
    @Autowired
    private NoticeServiceHolder noticeServiceHolder;
    @Autowired
    private CacheClient cacheService;
    @Value(value="${vfCodeExpTime}")
    private Integer verifyExpireTime;
    @Value(value="${sendVfCodeTemplateId}")
    private Long sendVfCodeTemplateId;
    @Autowired
    private UmcMemInfoUpdateCombService umcMemInfoUpdateCombService;
    @Autowired
    private UmcMemManageBusiService umcMemManageBusiService;
    @Autowired
    private UmcCheckUserExistCombService umcCheckUserExistCombService;
    private static String MSG_NULL_REGACCOUNT = "\u3010regAccount\u3011\u4e3a\u7a7a";
    private static String MSG_NULL_VERIFYVALUE = "\u3010verifyValue\u3011\u4e3a\u7a7a";
    @Value(value="${SMS_TYPE:HTTP}")
    private String SMS_TYPE;
    @Value(value="${isSendMsg:false}")
    private boolean IS_SEND_MSG;
    @Value(value="${MALL_SEND_PLATFORM:2}")
    private String MALL_SEND_PLATFORM;
    @Value(value="${IS_SHOW_VFCODE:true}")
    private boolean IS_SHOW_VFCODE;
    @Value(value="${login.originalKey:1234567890123456}")
    private String ORIGINAL_KEY;
    @Value(value="${IS_DECRYPT:false}")
    private boolean IS_DECRYPT;
    @Value(value="${VERIFY_TIMES:3}")
    private Integer VERIFY_TIMES;

    public UmcMemInfoAbilityRspBO memAuthenticatioGetVerifyCode(UmcMemAuthenticationAbilityReqBO abilityReqBO) {
        UmcMemInfoAbilityRspBO rspBO = new UmcMemInfoAbilityRspBO();
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getVerifyType())) {
            throw new UmcBusinessException("8000", "\u9a8c\u8bc1\u65b9\u5f0f\u3010verifyType\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getVerifyValue())) {
            throw new UmcBusinessException("8000", MSG_NULL_VERIFYVALUE);
        }
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getRegAccount())) {
            throw new UmcBusinessException("8000", MSG_NULL_REGACCOUNT);
        }
        UmcNoticeMessageOnlyBO umcNoticeMessageOnlyBO = new UmcNoticeMessageOnlyBO();
        ArrayList<String> templateTypes = new ArrayList<String>();
        UmcQueryMemBaseInfoBusiReqBO busiReqBO = new UmcQueryMemBaseInfoBusiReqBO();
        String errorMsg = "";
        if (abilityReqBO.getVerifyType().equals("01")) {
            umcNoticeMessageOnlyBO.setMail(abilityReqBO.getVerifyValue());
            templateTypes.add("mail");
            umcNoticeMessageOnlyBO.setTemplateTypes(templateTypes);
            busiReqBO.setRegEmail(abilityReqBO.getVerifyValue());
            errorMsg = "\u90ae\u7bb1\u4e0d\u5339\u914d";
        } else if (abilityReqBO.getVerifyType().equals("00")) {
            umcNoticeMessageOnlyBO.setPhoneNum(abilityReqBO.getVerifyValue());
            busiReqBO.setRegMobile(abilityReqBO.getVerifyValue());
            errorMsg = "\u624b\u673a\u53f7\u4e0d\u5339\u914d";
        } else {
            throw new UmcBusinessException("8000", "\u9a8c\u8bc1\u65b9\u5f0f\u4e0d\u652f\u6301");
        }
        busiReqBO.setRegAccount(abilityReqBO.getRegAccount());
        UmcRspListBO busiRsqBO = this.umcMemManageBusiService.queryMemBaseInfo(busiReqBO);
        if (busiRsqBO == null || CollectionUtils.isEmpty((Collection)busiRsqBO.getRows())) {
            throw new UmcBusinessException("8888", errorMsg);
        }
        if ("00".equals(((MemberBusiBO)busiRsqBO.getRows().get(0)).getStopStatus())) {
            throw new UmcBusinessException("8888", "\u7528\u6237\u5df2\u505c\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        umcNoticeMessageOnlyBO.setSendPlatform(Integer.valueOf(Integer.parseInt(this.MALL_SEND_PLATFORM)));
        umcNoticeMessageOnlyBO.setTemplateId(this.sendVfCodeTemplateId);
        JSONObject templateParam = new JSONObject();
        String verifyCode = String.valueOf((Math.random() * 9.0 + 1.0) * 100000.0).substring(0, 6);
        LOGGER.info("\u9a8c\u8bc1\u7801\u4e3averifyCode={}", (Object)verifyCode);
        templateParam.put("code", (Object)verifyCode);
        umcNoticeMessageOnlyBO.setTemplateParam(templateParam.toString());
        if (this.IS_SEND_MSG) {
            if (CollectionUtils.isEmpty(templateTypes) && this.SMS_TYPE.equals("HTTP")) {
                UmcExternalCallHttpSendMassageReqBO umcExternalCallHttpSendMassageReqBO = new UmcExternalCallHttpSendMassageReqBO();
                umcExternalCallHttpSendMassageReqBO.setMobile(umcNoticeMessageOnlyBO.getPhoneNum());
                umcExternalCallHttpSendMassageReqBO.setContent("\u77ed\u4fe1\u9a8c\u8bc1\u7801\uff1a" + verifyCode);
                UmcExternalCallHttpSendMassageRspBO umcExternalCallHttpSendMassageRspBO = this.noticeServiceHolder.getUmcExternalCallHttpSendMassageService().callHttpSendMassage(umcExternalCallHttpSendMassageReqBO);
                if ("0000".equals(umcExternalCallHttpSendMassageRspBO.getRespCode())) {
                    this.cacheService.set("VERIFY_CODE_PREFIX_" + abilityReqBO.getVerifyValue(), (Object)verifyCode, this.verifyExpireTime.intValue());
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u9a8c\u8bc1\u7801\u53d1\u9001\u6210\u529f");
                    if (this.IS_SHOW_VFCODE) {
                        rspBO.setCode(verifyCode);
                    }
                    return rspBO;
                }
            } else {
                UmcNoticeBaseBo umcNoticeBaseBo = this.noticeServiceHolder.getUmcExternalNoticeMassageService().httpSendOnlyMessage(umcNoticeMessageOnlyBO);
                if (umcNoticeBaseBo.getRespCode().equals("0000")) {
                    // empty if block
                }
            }
        }
        this.cacheService.set("VERIFY_CODE_PREFIX_" + abilityReqBO.getVerifyValue(), (Object)verifyCode, this.verifyExpireTime.intValue());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u9a8c\u8bc1\u7801\u53d1\u9001\u6210\u529f");
        if (this.IS_SHOW_VFCODE) {
            rspBO.setCode(verifyCode);
        }
        return rspBO;
    }

    public UmcMemInfoAbilityRspBO checkMemAuthenticatioVerifyCode(UmcMemAuthenticationAbilityReqBO abilityReqBO) {
        UmcMemInfoAbilityRspBO rspBO = new UmcMemInfoAbilityRspBO();
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getRegAccount())) {
            throw new UmcBusinessException("8000", MSG_NULL_REGACCOUNT);
        }
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getVerifyCode())) {
            throw new UmcBusinessException("8000", "\u3010VerifyCode\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getVerifyValue())) {
            throw new UmcBusinessException("8000", MSG_NULL_VERIFYVALUE);
        }
        Object verifyCode = this.cacheService.get("VERIFY_CODE_PREFIX_" + abilityReqBO.getVerifyValue());
        if (null == verifyCode || !abilityReqBO.getVerifyCode().equals(verifyCode.toString())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u9a8c\u8bc1\u7801\u9519\u8bef");
            return rspBO;
        }
        String verifyCode1 = String.valueOf((Math.random() * 9.0 + 1.0) * 100000.0).substring(0, 6);
        this.cacheService.set("VERIFY_CODE_PREFIX_" + abilityReqBO.getVerifyValue(), (Object)verifyCode1, this.verifyExpireTime.intValue());
        rspBO.setVerifyCode(verifyCode1);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u9a8c\u8bc1\u7801\u6821\u9a8c\u6210\u529f");
        return rspBO;
    }

    public UmcMemInfoAbilityRspBO changeMemKeyInfo(UmcMemAuthenticationAbilityReqBO abilityReqBO) {
        UmcMemInfoAbilityRspBO rspBO = new UmcMemInfoAbilityRspBO();
        UmcMemInfoUpdateCombReqBO umcMemInfoUpdateCombReqBO = new UmcMemInfoUpdateCombReqBO();
        this.validParam(abilityReqBO, umcMemInfoUpdateCombReqBO);
        if (this.IS_DECRYPT && !StringUtils.isBlank((CharSequence)abilityReqBO.getNewPassword())) {
            umcMemInfoUpdateCombReqBO.setNewPassword(AesEcbUtil.decryptStr(abilityReqBO.getNewPassword(), this.ORIGINAL_KEY));
        }
        if ("00".equals(abilityReqBO.getModifyInfoType())) {
            umcMemInfoUpdateCombReqBO.setOperTypeNew("updatePwd");
        } else {
            umcMemInfoUpdateCombReqBO.setOperTypeNew("update");
        }
        Object verifyCode = this.cacheService.get("VERIFY_CODE_PREFIX_" + abilityReqBO.getVerifyValue());
        Integer verifyTimes = (Integer)this.cacheService.get("VERIFY_CODE_PREFIX_TIMES" + abilityReqBO.getVerifyValue());
        if (null == verifyTimes) {
            verifyTimes = 0;
        } else if (verifyTimes >= this.VERIFY_TIMES) {
            this.cacheService.delete("VERIFY_CODE_PREFIX_" + abilityReqBO.getVerifyValue());
            this.cacheService.delete("VERIFY_CODE_PREFIX_TIMES" + abilityReqBO.getVerifyValue());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u9a8c\u8bc1\u7801\u9a8c\u8bc1\u6b21\u6570\u8d85\u8fc7" + this.VERIFY_TIMES.toString() + "\u6b21\uff0c\u8bf7\u91cd\u65b0\u53d1\u9001\u9a8c\u8bc1\u7801!");
            return rspBO;
        }
        if (null == verifyCode || !abilityReqBO.getVerifyCode().equals(verifyCode.toString())) {
            this.cacheService.set("VERIFY_CODE_PREFIX_TIMES" + abilityReqBO.getVerifyValue(), (Object)(verifyTimes + 1), this.verifyExpireTime.intValue());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u9a8c\u8bc1\u7801\u9519\u8bef");
            return rspBO;
        }
        umcMemInfoUpdateCombReqBO.setRegAccount(abilityReqBO.getRegAccount());
        umcMemInfoUpdateCombReqBO.setMemId(abilityReqBO.getMemId());
        UmcMemInfoUpdateCombRspBO combRspBO = this.umcMemInfoUpdateCombService.updateMemInfo(umcMemInfoUpdateCombReqBO);
        if (combRspBO.getRespCode().equals("0000")) {
            this.cacheService.delete("VERIFY_CODE_PREFIX_" + abilityReqBO.getVerifyValue());
            this.cacheService.delete("VERIFY_CODE_PREFIX_TIMES" + abilityReqBO.getVerifyValue());
            this.cacheService.delete("cas" + abilityReqBO.getRegAccount());
        }
        rspBO.setRespCode(combRspBO.getRespCode());
        rspBO.setRespDesc(combRspBO.getRespDesc());
        return rspBO;
    }

    public UmcMemInfoAbilityRspBO getVerifyCode(UmcMemAuthenticationAbilityReqBO abilityReqBO) {
        UmcMemInfoAbilityRspBO rspBO = new UmcMemInfoAbilityRspBO();
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getVerifyType())) {
            throw new UmcBusinessException("8000", "\u9a8c\u8bc1\u65b9\u5f0f\u3010verifyType\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getVerifyValue())) {
            throw new UmcBusinessException("8000", MSG_NULL_VERIFYVALUE);
        }
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getRegAccount())) {
            throw new UmcBusinessException("8000", MSG_NULL_REGACCOUNT);
        }
        UmcNoticeMessageOnlyBO umcNoticeMessageOnlyBO = new UmcNoticeMessageOnlyBO();
        ArrayList<String> templateTypes = new ArrayList<String>();
        if (abilityReqBO.getVerifyType().equals("01")) {
            umcNoticeMessageOnlyBO.setMail(abilityReqBO.getVerifyValue());
            templateTypes.add("mail");
            umcNoticeMessageOnlyBO.setTemplateTypes(templateTypes);
        } else if (abilityReqBO.getVerifyType().equals("00")) {
            umcNoticeMessageOnlyBO.setPhoneNum(abilityReqBO.getVerifyValue());
        } else {
            throw new UmcBusinessException("8000", "\u9a8c\u8bc1\u65b9\u5f0f\u4e0d\u652f\u6301");
        }
        umcNoticeMessageOnlyBO.setSendPlatform(UmcCommConstant.MessageProducer.MEM_CENTER);
        umcNoticeMessageOnlyBO.setTemplateId(this.sendVfCodeTemplateId);
        JSONObject templateParam = new JSONObject();
        String verifyCode = String.valueOf((Math.random() * 9.0 + 1.0) * 100000.0).substring(0, 6);
        LOGGER.info("\u9a8c\u8bc1\u7801\u4e3averifyCode={}", (Object)verifyCode);
        templateParam.put("code", (Object)verifyCode);
        umcNoticeMessageOnlyBO.setTemplateParam(templateParam.toString());
        if (this.IS_SEND_MSG) {
            if (CollectionUtils.isEmpty(templateTypes) && this.SMS_TYPE.equals("HTTP")) {
                UmcExternalCallHttpSendMassageReqBO umcExternalCallHttpSendMassageReqBO = new UmcExternalCallHttpSendMassageReqBO();
                umcExternalCallHttpSendMassageReqBO.setMobile(umcNoticeMessageOnlyBO.getPhoneNum());
                umcExternalCallHttpSendMassageReqBO.setContent("\u77ed\u4fe1\u9a8c\u8bc1\u7801\uff1a" + verifyCode);
                UmcExternalCallHttpSendMassageRspBO umcExternalCallHttpSendMassageRspBO = this.noticeServiceHolder.getUmcExternalCallHttpSendMassageService().callHttpSendMassage(umcExternalCallHttpSendMassageReqBO);
                if ("0000".equals(umcExternalCallHttpSendMassageRspBO.getRespCode())) {
                    this.cacheService.set("VERIFY_CODE_PREFIX_" + abilityReqBO.getVerifyValue(), (Object)verifyCode, this.verifyExpireTime.intValue());
                    rspBO.setRespCode("0000");
                    rspBO.setRespDesc("\u9a8c\u8bc1\u7801\u53d1\u9001\u6210\u529f");
                    if (this.IS_SHOW_VFCODE) {
                        rspBO.setCode(verifyCode);
                    }
                    return rspBO;
                }
            } else {
                UmcNoticeBaseBo umcNoticeBaseBo = this.noticeServiceHolder.getUmcExternalNoticeMassageService().httpSendOnlyMessage(umcNoticeMessageOnlyBO);
                if (umcNoticeBaseBo.getRespCode().equals("0000")) {
                    // empty if block
                }
            }
        }
        this.cacheService.set("VERIFY_CODE_PREFIX_" + abilityReqBO.getVerifyValue(), (Object)verifyCode, this.verifyExpireTime.intValue());
        if (this.IS_SHOW_VFCODE) {
            rspBO.setCode(verifyCode);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u9a8c\u8bc1\u7801\u53d1\u9001\u6210\u529f");
        return rspBO;
    }

    private void validParam(UmcMemAuthenticationAbilityReqBO abilityReqBO, UmcMemInfoUpdateCombReqBO umcMemInfoUpdateCombReqBO) {
        if (null == abilityReqBO) {
            throw new UmcBusinessException("8000", "\u5165\u53c2\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getVerifyCode())) {
            throw new UmcBusinessException("8000", "\u3010verifyCode\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getVerifyValue())) {
            throw new UmcBusinessException("8000", "\u3010verifyValue\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getModifyInfoType())) {
            throw new UmcBusinessException("8000", "\u3010modifyInfoType\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getRegAccount())) {
            throw new UmcBusinessException("8000", "\u3010regAccount\u3011\u4e3a\u7a7a");
        }
        this.validModifyInfoType(abilityReqBO, umcMemInfoUpdateCombReqBO);
    }

    private void validModifyInfoType(UmcMemAuthenticationAbilityReqBO abilityReqBO, UmcMemInfoUpdateCombReqBO umcMemInfoUpdateCombReqBO) {
        if ("02".equals(abilityReqBO.getModifyInfoType())) {
            if (StringUtils.isBlank((CharSequence)abilityReqBO.getNewEmail())) {
                throw new UmcBusinessException("8000", "\u3010newEmail\u3011\u4e3a\u7a7a");
            }
            umcMemInfoUpdateCombReqBO.setRegEmail(abilityReqBO.getNewEmail());
        } else if ("01".equals(abilityReqBO.getModifyInfoType())) {
            if (StringUtils.isBlank((CharSequence)abilityReqBO.getNewPhone())) {
                throw new UmcBusinessException("8000", "\u3010newPhone\u3011\u4e3a\u7a7a");
            }
            UmcCheckUserExistCombReqBO umcCheckUserExistCombReqBO = new UmcCheckUserExistCombReqBO();
            umcCheckUserExistCombReqBO.setRegAccount(abilityReqBO.getRegAccount());
            umcCheckUserExistCombReqBO.setRegMobile(abilityReqBO.getNewPhone());
            UmcCheckUserExistCombRspBO checkCombRspBO = this.umcCheckUserExistCombService.updateCheckUserExist(umcCheckUserExistCombReqBO);
            if (checkCombRspBO.getIsExistFlag().equals("1")) {
                throw new UmcBusinessException("8000", "\u624b\u673a\u53f7\u5df2\u5b58\u5728");
            }
            umcMemInfoUpdateCombReqBO.setRegMobile(abilityReqBO.getNewPhone());
        } else if ("00".equals(abilityReqBO.getModifyInfoType())) {
            if (StringUtils.isBlank((CharSequence)abilityReqBO.getNewPassword())) {
                throw new UmcBusinessException("8000", "\u3010newPassword\u3011\u4e3a\u7a7a");
            }
            umcMemInfoUpdateCombReqBO.setNewPassword(abilityReqBO.getNewPassword());
        } else {
            throw new UmcBusinessException("8000", "\u4fee\u6539\u65b9\u5f0f\u4e0d\u652f\u6301");
        }
    }
}

