/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.ability.impl;

import com.tydic.umc.ability.UmcMemLabelInfoAbilityService;
import com.tydic.umc.ability.bo.MemLabelInfoAbilityBO;
import com.tydic.umc.ability.bo.UmcMemLabelAbilityReqBO;
import com.tydic.umc.ability.bo.UmcMemLabelAbilityRspBO;
import com.tydic.umc.busi.UmcMemLabelInfoQueryBusiService;
import com.tydic.umc.busi.bo.MemLabelInfoBusiBO;
import com.tydic.umc.busi.bo.UmcMemLabelInfoQueryBusiReqBO;
import com.tydic.umc.busi.bo.UmcMemLabelInfoQueryBusiRspBO;
import com.tydic.umc.util.UmcBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@Service(version="1.0.0", group="service", interfaceClass=UmcMemLabelInfoAbilityService.class)
public class UmcMemLabelInfoAbilityServiceImpl
implements UmcMemLabelInfoAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UmcMemLabelInfoAbilityServiceImpl.class);
    private static final String ERROR_MSG = "\u4f1a\u5458\u6807\u7b7e\u4fe1\u606f\u7ef4\u62a4\u670d\u52a1\u6267\u884c\u5931\u8d25";
    private static final String PARAM_MSG = "\u4f1a\u5458\u6807\u7b7e\u4fe1\u606f\u7ef4\u62a4\u670d\u52a1\u5165\u53c2";
    private static final String OPERTYPE_ADD = "1";
    private static final String OPERTYPE_UPDATE = "2";
    private static final String OPERTYPE_DELETE = "3";
    private static final String OPERTYPE_QUERY = "4";
    @Autowired
    private UmcMemLabelInfoQueryBusiService umcMemLabelInfoQueryBusiService;

    public UmcMemLabelAbilityRspBO operMemLabelInfo(UmcMemLabelAbilityReqBO reqBO) {
        this.validateArg(reqBO);
        UmcMemLabelAbilityRspBO rspBO = new UmcMemLabelAbilityRspBO();
        if (!(OPERTYPE_ADD.equals(reqBO.getOperType()) || OPERTYPE_UPDATE.equals(reqBO.getOperType()) || OPERTYPE_DELETE.equals(reqBO.getOperType()))) {
            if (OPERTYPE_QUERY.equals(reqBO.getOperType())) {
                UmcMemLabelInfoQueryBusiReqBO busiReqBO = new UmcMemLabelInfoQueryBusiReqBO();
                busiReqBO.setMemberId(reqBO.getMemId());
                UmcMemLabelInfoQueryBusiRspBO busiRspBO = this.umcMemLabelInfoQueryBusiService.queryMemLabelInfo(busiReqBO);
                ArrayList<MemLabelInfoAbilityBO> memLabelInfoAbilityBOList = new ArrayList<MemLabelInfoAbilityBO>();
                if (!CollectionUtils.isEmpty((Collection)busiRspBO.getMemLabelInfoBOList())) {
                    for (MemLabelInfoBusiBO memLabelInfoBusiBO : busiRspBO.getMemLabelInfoBOList()) {
                        MemLabelInfoAbilityBO memLabelInfoAbilityBO = new MemLabelInfoAbilityBO();
                        BeanUtils.copyProperties((Object)memLabelInfoBusiBO, (Object)memLabelInfoAbilityBO);
                        memLabelInfoAbilityBOList.add(memLabelInfoAbilityBO);
                    }
                }
                rspBO.setMemLabelInfoBOList(memLabelInfoAbilityBOList);
                rspBO.setRespCode(busiRspBO.getRespCode());
                rspBO.setRespDesc(busiRspBO.getRespDesc());
            } else {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u4f1a\u5458\u6807\u7b7e\u4fe1\u606f\u7ef4\u62a4\u670d\u52a1\u6267\u884c\u5931\u8d25,\u672a\u77e5\u7684\u64cd\u4f5c\u7c7b\u578b");
            }
        }
        return rspBO;
    }

    private void validateArg(UmcMemLabelAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new UmcBusinessException("8000", "\u4f1a\u5458\u6807\u7b7e\u4fe1\u606f\u7ef4\u62a4\u670d\u52a1\u5165\u53c2\u5bf9\u8c61[req]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getOperType())) {
            throw new UmcBusinessException("8000", "\u4f1a\u5458\u6807\u7b7e\u4fe1\u606f\u7ef4\u62a4\u670d\u52a1\u5165\u53c2\u64cd\u4f5c\u7c7b\u578b[operType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getMemId()) {
            throw new UmcBusinessException("8000", "\u4f1a\u5458\u6807\u7b7e\u4fe1\u606f\u7ef4\u62a4\u670d\u52a1\u5165\u53c2\u4f1a\u5458ID[memberId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (OPERTYPE_ADD.equals(reqBO.getOperType()) || OPERTYPE_UPDATE.equals(reqBO.getOperType()) || OPERTYPE_DELETE.equals(reqBO.getOperType())) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getMemLabelInfoList())) {
                throw new UmcBusinessException("8000", "\u4f1a\u5458\u6807\u7b7e\u4fe1\u606f\u7ef4\u62a4\u670d\u52a1\u5165\u53c2\u6807\u7b7e\u4fe1\u606f\u5217\u8868[memLabelInfoList]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            for (MemLabelInfoAbilityBO memLabelInfoAbilityBO : reqBO.getMemLabelInfoList()) {
                if (!OPERTYPE_UPDATE.equals(reqBO.getOperType()) && !OPERTYPE_DELETE.equals(reqBO.getOperType()) || null != memLabelInfoAbilityBO.getId()) continue;
                throw new UmcBusinessException("8000", "\u4f1a\u5458\u6807\u7b7e\u4fe1\u606f\u7ef4\u62a4\u670d\u52a1\u5165\u53c2\u6807\u7b7e\u4fe1\u606f\u5217\u8868[memLabelInfoList]\u4e2d\u7684ID[id]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
    }
}

