/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.ability.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.umc.ability.UmcMemRegistAbilityService;
import com.tydic.umc.ability.bo.DicDictionaryBO;
import com.tydic.umc.ability.bo.FaceInfoAbilityBO;
import com.tydic.umc.ability.bo.UmcMemRegistAbilityReqBO;
import com.tydic.umc.ability.bo.UmcMemRegistAbilityRspBO;
import com.tydic.umc.busi.DictionaryBusiService;
import com.tydic.umc.busi.UmcEnterpriseOrgManageBusiService;
import com.tydic.umc.busi.bo.UmcEnterpriseOrgDetailBusiRspBO;
import com.tydic.umc.busi.bo.UmcEnterpriseOrgQryBusiReqBO;
import com.tydic.umc.comb.UmcCheckUserExistCombService;
import com.tydic.umc.comb.UmcMemRegistCombService;
import com.tydic.umc.comb.bo.FaceInfoCombBO;
import com.tydic.umc.comb.bo.UmcCheckUserExistCombReqBO;
import com.tydic.umc.comb.bo.UmcCheckUserExistCombRspBO;
import com.tydic.umc.comb.bo.UmcMemRegistCombReqBO;
import com.tydic.umc.comb.bo.UmcMemRegistCombRspBO;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.util.UmcBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(version="1.0.0", group="service", interfaceClass=UmcMemRegistAbilityService.class)
public class UmcMemRegistAbilityServiceImpl
implements UmcMemRegistAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UmcMemRegistAbilityServiceImpl.class);
    private UmcMemRegistCombService umcMemRegistCombService;
    @Autowired
    private UmcCheckUserExistCombService umcCheckUserExistCombService;
    @Autowired
    private UmcEnterpriseOrgManageBusiService umcEnterpriseOrgManageBusiService;
    @Autowired
    private DictionaryBusiService dictionaryBusiService;

    @Autowired
    public UmcMemRegistAbilityServiceImpl(UmcMemRegistCombService umcMemRegistCombService) {
        this.umcMemRegistCombService = umcMemRegistCombService;
    }

    public UmcMemRegistAbilityRspBO dealMemRegist(UmcMemRegistAbilityReqBO reqBO) {
        UmcEnterpriseOrgDetailBusiRspBO umcEnterpriseOrgDetailBusiRspBO;
        this.checkParaAndSetDefaultValue(reqBO);
        UmcMemRegistAbilityRspBO rspBO = new UmcMemRegistAbilityRspBO();
        Long orgId = reqBO.getOrgIdWeb();
        if (null != orgId || !StringUtils.isEmpty((Object)reqBO.getOrgCode())) {
            UmcEnterpriseOrgQryBusiReqBO umcEnterpriseOrgQryBusiReqBO = new UmcEnterpriseOrgQryBusiReqBO();
            umcEnterpriseOrgQryBusiReqBO.setOrgId(orgId);
            umcEnterpriseOrgQryBusiReqBO.setOrgCode(reqBO.getOrgCode());
            umcEnterpriseOrgDetailBusiRspBO = this.umcEnterpriseOrgManageBusiService.getOrgByOrgCode(umcEnterpriseOrgQryBusiReqBO);
            if (null == umcEnterpriseOrgDetailBusiRspBO.getUmcEnterpriseOrgBO()) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u8bf7\u6c42\u767b\u5f55\u673a\u6784\u4fe1\u606f\u4e0d\u5b58\u5728");
                return rspBO;
            }
            if (!umcEnterpriseOrgDetailBusiRspBO.getUmcEnterpriseOrgBO().getStatus().equals("02")) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u8be5\u673a\u6784\u975e\u6709\u6548\u673a\u6784");
                return rspBO;
            }
        } else {
            rspBO.setRespCode("4000");
            rspBO.setRespDesc("\u8bf7\u6c42\u53c2\u6570[orgId]\u548c[orgCode]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            return rspBO;
        }
        orgId = umcEnterpriseOrgDetailBusiRspBO.getUmcEnterpriseOrgBO().getOrgId();
        if (!StringUtils.isEmpty((Object)reqBO.getRegAccount())) {
            UmcCheckUserExistCombReqBO umcCheckUserExistCombReqBO = new UmcCheckUserExistCombReqBO();
            umcCheckUserExistCombReqBO.setRegAccount(reqBO.getRegAccount());
            umcCheckUserExistCombReqBO.setMemAffiliation(reqBO.getMemAffiliation());
            UmcCheckUserExistCombRspBO checkCombRspBO = this.umcCheckUserExistCombService.addCheckUserExist(umcCheckUserExistCombReqBO);
            if (checkCombRspBO.getIsExistFlag().equals("1")) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u7528\u6237\u540d\u5df2\u5b58\u5728");
                return rspBO;
            }
        }
        if (!StringUtils.isEmpty((Object)reqBO.getRegMobile())) {
            UmcCheckUserExistCombReqBO umcCheckUserExistCombReqBO1 = new UmcCheckUserExistCombReqBO();
            umcCheckUserExistCombReqBO1.setRegMobile(reqBO.getRegMobile());
            umcCheckUserExistCombReqBO1.setMemAffiliation(reqBO.getMemAffiliation());
            umcCheckUserExistCombReqBO1.setOrgId(orgId);
            UmcCheckUserExistCombRspBO checkCombRspBO1 = this.umcCheckUserExistCombService.addCheckUserExist(umcCheckUserExistCombReqBO1);
            if (checkCombRspBO1.getIsExistFlag().equals("1")) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u8be5\u624b\u673a\u53f7\u5df2\u88ab\u7ed1\u5b9a");
                return rspBO;
            }
        }
        UmcMemRegistCombReqBO combReqBO = this.buildCombReq(reqBO, orgId);
        UmcMemRegistCombRspBO combRspBO = this.umcMemRegistCombService.dealMemRegist(combReqBO);
        rspBO.setRespCode(combRspBO.getRespCode());
        rspBO.setRespDesc(combRspBO.getRespDesc());
        rspBO.setMemId(combRspBO.getMemId());
        return rspBO;
    }

    private UmcMemRegistCombReqBO buildCombReq(UmcMemRegistAbilityReqBO reqBO, Long orgId) {
        UmcMemRegistCombReqBO combReqBO = new UmcMemRegistCombReqBO();
        combReqBO.setRegAccount(reqBO.getRegAccount());
        combReqBO.setRegMobile(reqBO.getRegMobile());
        combReqBO.setRegEmail(reqBO.getRegEmail());
        combReqBO.setHeadUrl(reqBO.getHeadUrl());
        combReqBO.setRegVfCode(reqBO.getRegVfCode());
        combReqBO.setThirdAuthType(reqBO.getThirdAuthType());
        combReqBO.setThirdAuthId(reqBO.getThirdAuthId());
        combReqBO.setPasswd(reqBO.getPasswd());
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)reqBO.getPasswd())) {
            combReqBO.setPassCreate(Integer.valueOf(1));
        }
        combReqBO.setMemName1(reqBO.getMemName1());
        combReqBO.setMemName2(reqBO.getMemName2());
        combReqBO.setMemNickName(reqBO.getMemName2());
        combReqBO.setSex(reqBO.getSex());
        combReqBO.setCertType(reqBO.getCertType());
        combReqBO.setCertNo(reqBO.getCertNo());
        combReqBO.setMemLevel(reqBO.getMemLevel());
        combReqBO.setMemState(reqBO.getMemState());
        combReqBO.setMemType(reqBO.getMemType());
        combReqBO.setThirdAuthId(reqBO.getThirdAuthId());
        combReqBO.setThirdAuthType(reqBO.getThirdAuthType());
        combReqBO.setBirthday(reqBO.getBirthday());
        if (!StringUtils.isEmpty((Object)reqBO.getLevelEffTime())) {
            combReqBO.setLevelEffTime(DateUtils.strToDateLong((String)reqBO.getLevelEffTime()));
        }
        if (!StringUtils.isEmpty((Object)reqBO.getLevelExpTime())) {
            combReqBO.setLevelExpTime(DateUtils.strToDateLong((String)reqBO.getLevelExpTime()));
        }
        combReqBO.setIsPlus(reqBO.getIsPlus());
        if (!StringUtils.isEmpty((Object)reqBO.getPlusEffTime())) {
            combReqBO.setPlusEffTime(DateUtils.strToDateLong((String)reqBO.getPlusEffTime()));
        }
        if (!StringUtils.isEmpty((Object)reqBO.getPlusExpTime())) {
            combReqBO.setPlusExpTime(DateUtils.strToDateLong((String)reqBO.getPlusExpTime()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getFaceInfoList())) {
            ArrayList<FaceInfoCombBO> faceInfoList = new ArrayList<FaceInfoCombBO>(reqBO.getFaceInfoList().size());
            for (FaceInfoAbilityBO faceInfoBO : reqBO.getFaceInfoList()) {
                FaceInfoCombBO combFaceInfoBO = new FaceInfoCombBO();
                combFaceInfoBO.setFaceId(faceInfoBO.getFaceId());
                combFaceInfoBO.setPhotoType(faceInfoBO.getPhotoType());
                combFaceInfoBO.setPhotoUrl(faceInfoBO.getPhotoUrl());
                combFaceInfoBO.setShopCode(faceInfoBO.getShopCode());
                combFaceInfoBO.setCameraId(faceInfoBO.getCameraId());
                faceInfoList.add(combFaceInfoBO);
            }
            combReqBO.setFaceInfoList(faceInfoList);
        }
        combReqBO.setOrgIdWeb(orgId);
        combReqBO.setWorkNo(reqBO.getWorkNo());
        combReqBO.setOfficePhone(reqBO.getOfficePhone());
        combReqBO.setMainMemId(reqBO.getMainMemId());
        combReqBO.setMemAffiliation(reqBO.getMemAffiliation());
        combReqBO.setHeight(reqBO.getHeight());
        combReqBO.setWeight(reqBO.getWeight());
        combReqBO.setOccupation(reqBO.getOccupation());
        combReqBO.setIsCreateTbAccount(reqBO.getIsCreateTbAccount());
        if (!StringUtils.isEmpty((Object)reqBO.getStopStatus())) {
            combReqBO.setStopStatus(reqBO.getStopStatus());
        }
        if (reqBO.getRoleIds() != null) {
            combReqBO.setRoleIds(reqBO.getRoleIds());
        }
        return combReqBO;
    }

    private void checkParaAndSetDefaultValue(UmcMemRegistAbilityReqBO reqBO) {
        if ("01".equals(reqBO.getMemAffiliation())) {
            if (reqBO.getOrgIdWeb() == null && StringUtils.isEmpty((Object)reqBO.getOrgCode())) {
                throw new UmcBusinessException("4000", "\u8bf7\u6c42\u53c2\u6570[OrgIdWeb]\u548c[orgCode]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
            }
            this.checkParaRegAccount(reqBO);
            this.checkParaRegMobile(reqBO);
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)reqBO.getPasswd()) && UmcEnumConstant.RegScene.isTargetType((UmcEnumConstant.RegScene)UmcEnumConstant.RegScene.SYSTEM, (Integer)reqBO.getRegScene())) {
                reqBO.setPasswd(this.defaultPasswd());
            }
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)reqBO.getMemName2())) {
                throw new UmcBusinessException("4000", "\u8bf7\u6c42\u53c2\u6570[MemName2]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (reqBO.getSex() == null) {
                reqBO.setSex(UmcEnumConstant.Sex.Unknown.getCode());
            }
        } else {
            if (reqBO.getRegScene() == null) {
                reqBO.setRegScene(UmcEnumConstant.RegScene.PHONE.getCode());
            }
            if (UmcEnumConstant.MemType.ofCode((Integer)reqBO.getMemType()) == null) {
                throw new UmcBusinessException("4000", "\u8bf7\u6c42\u53c2\u6570[memType]\u683c\u5f0f\u975e\u6cd5");
            }
            if (StringUtils.isEmpty((Object)reqBO.getMemAffiliation())) {
                reqBO.setMemAffiliation("00");
            }
            if (UmcEnumConstant.RegScene.isTargetType((UmcEnumConstant.RegScene)UmcEnumConstant.RegScene.PHONE, (Integer)reqBO.getRegScene())) {
                this.checkParaRegMobile(reqBO);
                this.checkParaRegVfCode(reqBO);
                this.checkParaPasswd(reqBO);
            }
            if (UmcEnumConstant.RegScene.isTargetType((UmcEnumConstant.RegScene)UmcEnumConstant.RegScene.FACE_ID, (Integer)reqBO.getRegScene())) {
                this.checkParaFaceInfoList(reqBO);
            }
            if (UmcEnumConstant.RegScene.isTargetType((UmcEnumConstant.RegScene)UmcEnumConstant.RegScene.THIRD_AUTH, (Integer)reqBO.getRegScene())) {
                this.checkParaRegMobile(reqBO);
                this.checkParaRegVfCode(reqBO);
                this.checkParaPasswd(reqBO);
                this.checkParaThirdAuthInfo(reqBO);
            }
            if (UmcEnumConstant.RegScene.isTargetType((UmcEnumConstant.RegScene)UmcEnumConstant.RegScene.ACCOUNT, (Integer)reqBO.getRegScene())) {
                this.checkParaRegMobile(reqBO);
                this.checkParaRegVfCode(reqBO);
                this.checkParaPasswd(reqBO);
                this.checkParaRegAccount(reqBO);
            }
            if (UmcEnumConstant.RegScene.isTargetType((UmcEnumConstant.RegScene)UmcEnumConstant.RegScene.SYSTEM, (Integer)reqBO.getRegScene())) {
                if (StringUtils.isEmpty((Object)reqBO.getRegMobile()) && StringUtils.isEmpty((Object)reqBO.getThirdAuthId())) {
                    throw new UmcBusinessException("4000", "\u8bf7\u6c42\u53c2\u6570\u624b\u673a\u53f7\u548c\u4e09\u65b9\u7ed1\u5b9aID\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
                }
                if (!StringUtils.isEmpty((Object)reqBO.getThirdAuthId()) && null == reqBO.getThirdAuthType()) {
                    throw new UmcBusinessException("4000", "\u8bf7\u6c42\u53c2\u6570\u4e09\u65b9\u7ed1\u5b9a\u7c7b\u578b[ThirdAuthType]\u4e0d\u80fd\u4e3a\u7a7a");
                }
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)reqBO.getPasswd())) {
                    reqBO.setPasswd(this.defaultPasswd());
                }
            }
            if (reqBO.getSex() == null) {
                reqBO.setSex(UmcEnumConstant.Sex.Unknown.getCode());
            } else if (UmcEnumConstant.Sex.ofCode((Integer)reqBO.getSex()) == null) {
                throw new UmcBusinessException("4000", "\u8bf7\u6c42\u53c2\u6570[sex]\u683c\u5f0f\u975e\u6cd5");
            }
            if (reqBO.getMemLevel() == null) {
                reqBO.setMemLevel(UmcCommConstant.UmcDefaultValue.MEM_LEVEL);
            }
            if (reqBO.getMemState() == null) {
                reqBO.setMemState(UmcEnumConstant.MemState.EFFECTIVE.getCode());
            }
        }
    }

    private void checkParaFaceInfoList(UmcMemRegistAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getFaceInfoList())) {
            throw new UmcBusinessException("4000", "\u8bf7\u6c42\u53c2\u6570[faceInfoList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (FaceInfoAbilityBO faceInfoAbilityBO : reqBO.getFaceInfoList()) {
            if (!StringUtils.isEmpty((Object)faceInfoAbilityBO.getFaceId()) || !StringUtils.isEmpty((Object)reqBO.getThirdAuthType())) continue;
            throw new UmcBusinessException("4000", "\u8bf7\u6c42\u53c2\u6570[faceInfoList.faceId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkParaThirdAuthInfo(UmcMemRegistAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getThirdAuthType())) {
            throw new UmcBusinessException("4000", "\u8bf7\u6c42\u53c2\u6570[thirdAuthType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getThirdAuthId())) {
            throw new UmcBusinessException("4000", "\u8bf7\u6c42\u53c2\u6570[thirdAuthId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkParaRegAccount(UmcMemRegistAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getRegAccount())) {
            throw new UmcBusinessException("4000", "\u8bf7\u6c42\u53c2\u6570[regAccount]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkParaPasswd(UmcMemRegistAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getPasswd())) {
            throw new UmcBusinessException("4000", "\u8bf7\u6c42\u53c2\u6570[passwd]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkParaRegVfCode(UmcMemRegistAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getRegVfCode())) {
            throw new UmcBusinessException("4000", "\u8bf7\u6c42\u53c2\u6570[regVfCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkParaRegMobile(UmcMemRegistAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getRegMobile())) {
            throw new UmcBusinessException("4000", "\u8bf7\u6c42\u53c2\u6570[regMobile]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private String defaultPasswd() {
        DicDictionaryBO dicDictionaryBO = new DicDictionaryBO();
        dicDictionaryBO.setPCode("DEFAULT_PWD");
        DicDictionaryBO dicDictionary = this.dictionaryBusiService.getDictionaryByBO(dicDictionaryBO);
        if (null == dicDictionary) {
            throw new UmcBusinessException("8888", "\u9ed8\u8ba4\u5bc6\u7801\u672a\u914d\u7f6e");
        }
        if (StringUtils.isEmpty((Object)dicDictionary.getCode())) {
            throw new UmcBusinessException("8888", "\u9ed8\u8ba4\u5bc6\u7801\u672a\u914d\u7f6e");
        }
        return dicDictionary.getCode();
    }
}

