/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.ability.impl;

import com.tydic.umc.ability.bo.UmcMobileBindAbilityReqBO;
import com.tydic.umc.ability.bo.UmcMobileBindAbilityRspBO;
import com.tydic.umc.ability.user.UmcMobileBindAbilityService;
import com.tydic.umc.busi.UmcVfCodeCheckBusiService;
import com.tydic.umc.busi.bo.UmcVfCodeCheckBusiReqBO;
import com.tydic.umc.busi.bo.UmcVfCodeCheckBusiRspBO;
import com.tydic.umc.comb.UmcMobileBindCombService;
import com.tydic.umc.comb.bo.UmcMobileBindCombReqBO;
import com.tydic.umc.comb.bo.UmcMobileBindCombRspBO;
import com.tydic.umc.constant.UmcCommConstant;
import com.tydic.umc.util.UmcBusinessException;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

@Service(version="1.0.0", group="service", interfaceClass=UmcMobileBindAbilityService.class)
public class UmcMobileBindAbilityServiceImpl
implements UmcMobileBindAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UmcMobileBindAbilityServiceImpl.class);
    @Autowired
    private UmcMobileBindCombService umcMobileBindCombService;
    @Autowired
    private UmcVfCodeCheckBusiService umcVfCodeCheckBusiService;

    public UmcMobileBindAbilityRspBO mobileBind(UmcMobileBindAbilityReqBO reqBO) {
        this.initParam(reqBO);
        UmcMobileBindAbilityRspBO rspBO = new UmcMobileBindAbilityRspBO();
        UmcMobileBindCombReqBO umcMobileBindCombReqBO = new UmcMobileBindCombReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)umcMobileBindCombReqBO);
        this.checkVfCode(umcMobileBindCombReqBO);
        UmcMobileBindCombRspBO umcMobileBindCombRspBO = this.umcMobileBindCombService.mobileBind(umcMobileBindCombReqBO);
        BeanUtils.copyProperties((Object)umcMobileBindCombRspBO, (Object)rspBO);
        return rspBO;
    }

    private void initParam(UmcMobileBindAbilityReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getRegMobile())) {
            throw new UmcBusinessException("4000", "\u5165\u53c2[regMobile]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBO.getVfCode())) {
            throw new UmcBusinessException("4000", "\u5165\u53c2[vfCode]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getMemIdExt()) {
            throw new UmcBusinessException("4000", "\u5165\u53c2[memIdExt]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getIsRedPacket()) {
            throw new UmcBusinessException("4000", "\u5165\u53c2[isRedPacket]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!UmcCommConstant.MobileBindIsRedPacket.NO.equals(reqBO.getIsRedPacket()) && !UmcCommConstant.MobileBindIsRedPacket.YES.equals(reqBO.getIsRedPacket())) {
            throw new UmcBusinessException("4000", "\u5165\u53c2[isRedPacket]\u53ea\u80fd\u4e3a\u7a7a1\u62160");
        }
        if (null == reqBO.getAdmOrgId()) {
            throw new UmcBusinessException("4000", "\u5165\u53c2[admOrgId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getBindType()) {
            throw new UmcBusinessException("4000", "\u5165\u53c2[bindType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkVfCode(UmcMobileBindCombReqBO reqBO) {
        UmcVfCodeCheckBusiReqBO umcVfCodeCheckBusiReqBO = new UmcVfCodeCheckBusiReqBO();
        umcVfCodeCheckBusiReqBO.setRegMobile(reqBO.getRegMobile());
        umcVfCodeCheckBusiReqBO.setVFCode(reqBO.getVfCode());
        UmcVfCodeCheckBusiRspBO umcVfCodeCheckBusiRspBO = this.umcVfCodeCheckBusiService.checkVfCode(umcVfCodeCheckBusiReqBO);
        if (!"0000".equals(umcVfCodeCheckBusiRspBO.getRespCode())) {
            throw new UmcBusinessException(umcVfCodeCheckBusiRspBO.getRespCode(), umcVfCodeCheckBusiRspBO.getRespDesc());
        }
    }
}

