/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.ability.impl;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.tydic.umc.ability.UmcOssUploadFileAbilityService;
import com.tydic.umc.ability.bo.UccOssUploadFileAbilityReqBO;
import com.tydic.umc.ability.bo.UmcOssUploadFileAbilityRspBO;
import com.tydic.umc.util.Base64;
import com.tydic.umc.util.ImageUtil;
import com.tydic.umc.util.PrevImgBase64;
import com.tydic.umc.util.UmcBusinessException;
import com.tydic.umc.util.Utils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Date;
import net.coobird.thumbnailator.Thumbnails;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.multipart.MultipartFile;

@Service(version="1.0.0", group="service", interfaceClass=UmcOssUploadFileAbilityService.class)
public class UmcOssUploadFileAbilityServiceImpl
implements UmcOssUploadFileAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UmcOssUploadFileAbilityServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcOssUploadFileAbilityServiceImpl.class);
    private static final Boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    @Value(value="${oss.endpoint}")
    private String endpoint;
    @Value(value="${oss.accesskey}")
    private String accessKeyId;
    @Value(value="${oss.accessKeySecret}")
    private String accessKeySecret;
    @Value(value="${oss.bucketName}")
    private String bucketName;
    private static final String FILEDIR = "umc/ ";
    private static final String PDF = ".pdf";
    private static final String DOC = ".doc";
    private static final String DOCX = ".docx";
    private static final String XLSX = ".xlsx";
    private static final String XLS = ".xls";
    private static final String PPTX = ".pptx";
    private static final String PPT = ".ppt";
    private static final String MP4_U = ".MP4";
    private static final String MP4 = ".mp4";
    private static final String HTM = ".htm";
    private static final String HTML = ".html";
    private static final String SPLIT_EXPIRES = "Expires";
    private static final String KEY_WORD_HTTP = "http";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UmcOssUploadFileAbilityRspBO uploadFile(UccOssUploadFileAbilityReqBO abilityReqBO) {
        UmcOssUploadFileAbilityRspBO rsp = new UmcOssUploadFileAbilityRspBO();
        this.validateParam(abilityReqBO);
        MultipartFile file = Base64.base64ToMultipart(abilityReqBO.getBase64Img());
        String fileId = Utils.get16UUID();
        String fileSuffix = Utils.getFileSuffix(file.getOriginalFilename());
        fileSuffix = StringUtils.lowerCase((String)fileSuffix);
        OSSClient ossClient = new OSSClient(this.endpoint, this.accessKeyId, this.accessKeySecret);
        String ossKey = null;
        String ossKeyPreview = null;
        try {
            ossKey = FILEDIR + fileId + fileSuffix;
            ossKeyPreview = FILEDIR + fileId + "-preview";
            ByteArrayOutputStream bOutput = new ByteArrayOutputStream();
            if (PDF.equals(fileSuffix)) {
                ossClient.putObject(this.bucketName, ossKey, file.getInputStream());
                ossKeyPreview = ossKeyPreview + PrevImgBase64.PDF.getSuffix();
                ossClient.putObject(this.bucketName, ossKeyPreview, (InputStream)new ByteArrayInputStream(Base64.decode(PrevImgBase64.PDF.getData())));
            } else if (DOC.equals(fileSuffix) || DOCX.equals(fileSuffix)) {
                ossClient.putObject(this.bucketName, ossKey, file.getInputStream());
                ossKeyPreview = ossKeyPreview + PrevImgBase64.Word.getSuffix();
                ossClient.putObject(this.bucketName, ossKeyPreview, (InputStream)new ByteArrayInputStream(Base64.decode(PrevImgBase64.Word.getData())));
            } else if (XLSX.equals(fileSuffix) || XLS.equals(fileSuffix)) {
                ossClient.putObject(this.bucketName, ossKey, file.getInputStream());
                ossKeyPreview = ossKeyPreview + PrevImgBase64.Xlsx.getSuffix();
                ossClient.putObject(this.bucketName, ossKeyPreview, (InputStream)new ByteArrayInputStream(Base64.decode(PrevImgBase64.Xlsx.getData())));
            } else if (PPT.equals(fileSuffix) || PPTX.equals(fileSuffix)) {
                ossClient.putObject(this.bucketName, ossKey, file.getInputStream());
                ossKeyPreview = ossKeyPreview + PrevImgBase64.PPT.getSuffix();
                ossClient.putObject(this.bucketName, ossKeyPreview, (InputStream)new ByteArrayInputStream(Base64.decode(PrevImgBase64.PPT.getData())));
            } else if (MP4.equals(fileSuffix) || MP4_U.equals(fileSuffix)) {
                ossClient.putObject(this.bucketName, ossKey, file.getInputStream());
                ossKeyPreview = ossKeyPreview + PrevImgBase64.VIDEO.getSuffix();
                ossClient.putObject(this.bucketName, ossKeyPreview, (InputStream)new ByteArrayInputStream(Base64.decode(PrevImgBase64.VIDEO.getData())));
            } else if (HTML.equals(fileSuffix) || HTM.equals(fileSuffix)) {
                ossClient.putObject(this.bucketName, ossKey, file.getInputStream());
                ossKeyPreview = ossKeyPreview + PrevImgBase64.HTML.getSuffix();
                ossClient.putObject(this.bucketName, ossKeyPreview, (InputStream)new ByteArrayInputStream(Base64.decode(PrevImgBase64.HTML.getData())));
            } else {
                int minSize = 1024;
                ImageUtil imgUtil = new ImageUtil();
                if (Integer.parseInt(String.valueOf(file.getSize() / 1024L)) > minSize) {
                    ByteArrayOutputStream originOutput = new ByteArrayOutputStream();
                    Thumbnails.of((InputStream[])new InputStream[]{file.getInputStream()}).scale(1.0).outputQuality(0.9f).toOutputStream((OutputStream)originOutput);
                    ossClient.putObject(this.bucketName, ossKey, (InputStream)new ByteArrayInputStream(originOutput.toByteArray()));
                } else {
                    ossClient.putObject(this.bucketName, ossKey, file.getInputStream());
                }
                ossKeyPreview = ossKeyPreview + fileSuffix;
                imgUtil.thumbnailImage(file.getInputStream(), file.getOriginalFilename(), bOutput, 100, 100, "preview", false);
                ossClient.putObject(this.bucketName, ossKeyPreview, (InputStream)new ByteArrayInputStream(bOutput.toByteArray()));
            }
        }
        catch (OSSException oe) {
            oe.printStackTrace();
        }
        catch (ClientException ce) {
            ce.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ossClient.shutdown();
        }
        rsp.setRetUrl(this.getUrl(ossKey));
        rsp.setOssKey(ossKey);
        rsp.setOssKeyPreview(ossKeyPreview);
        rsp.setFileName(file.getOriginalFilename());
        rsp.setFileSize(Integer.valueOf(Integer.parseInt(String.valueOf(file.getSize() / 1024L))));
        rsp.setFileType(fileSuffix);
        rsp.setCreateOperId(abilityReqBO.getUserId());
        rsp.setCreateTime(new Date());
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u6210\u529f");
        return rsp;
    }

    private void validateParam(UccOssUploadFileAbilityReqBO abilityReqBO) {
        if (null == abilityReqBO) {
            throw new UmcBusinessException("2002", "OSS\u6587\u4ef6\u4e0a\u4f20\u670d\u52a1Api\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getFile() && null == abilityReqBO.getBase64Img()) {
            throw new UmcBusinessException("2002", "OSS\u6587\u4ef6\u4e0a\u4f20\u670d\u52a1Api\u5165\u53c2\u3010file,base64Img\u3011\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getBase64Img()) {
            String base64Img = null;
            try {
                base64Img = new String(org.apache.commons.codec.binary.Base64.encodeBase64((byte[])abilityReqBO.getFile().getBytes()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            abilityReqBO.setBase64Img(base64Img);
        }
    }

    public String getUrl(String key) {
        if (key.indexOf(KEY_WORD_HTTP) == -1) {
            OSSClient server = new OSSClient(this.endpoint, this.accessKeyId, this.accessKeySecret);
            Date expirations = new Date(System.currentTimeMillis() + 300000L);
            URL url = server.generatePresignedUrl(this.bucketName, key, expirations);
            String strUrl = String.valueOf(url);
            server.shutdown();
            if (IS_DEBUG_ENABLED.booleanValue()) {
                LOGGER.debug("strUrl = [{}]", (Object)strUrl);
            }
            return UmcOssUploadFileAbilityServiceImpl.splitUrl(strUrl);
        }
        if (IS_DEBUG_ENABLED.booleanValue()) {
            LOGGER.debug("key = [{}]", (Object)key);
        }
        return UmcOssUploadFileAbilityServiceImpl.splitUrl(key);
    }

    public static String splitUrl(String url) {
        if (url.indexOf("?Expires") != -1) {
            return url.split(SPLIT_EXPIRES)[0].substring(0, url.split(SPLIT_EXPIRES)[0].length() - 1);
        }
        return url;
    }
}

