/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.ability.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.umc.ability.UmcReceiveCouponAbilityService;
import com.tydic.umc.ability.bo.UmcReceiveCouponAbilityReqBO;
import com.tydic.umc.ability.bo.UmcReceiveCouponAbilityRspBO;
import com.tydic.umc.busi.UmcReceiveCouponBusiService;
import com.tydic.umc.busi.bo.UmcReceiveCouponBusiReqBO;
import com.tydic.umc.busi.bo.UmcReceiveCouponBusiRspBO;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.util.UmcBusinessException;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="service", interfaceClass=UmcReceiveCouponAbilityService.class)
public class UmcReceiveCouponAbilityServiceImpl
implements UmcReceiveCouponAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UmcReceiveCouponAbilityServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcReceiveCouponAbilityServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private UmcReceiveCouponBusiService umcReceiveCouponBusiService;

    @Autowired
    public UmcReceiveCouponAbilityServiceImpl(UmcReceiveCouponBusiService umcReceiveCouponBusiService) {
        this.umcReceiveCouponBusiService = umcReceiveCouponBusiService;
    }

    public UmcReceiveCouponAbilityRspBO receiveCoupon(UmcReceiveCouponAbilityReqBO abilityReqBO) {
        BigDecimal result;
        BigDecimal exchange;
        UmcReceiveCouponAbilityRspBO rsp = new UmcReceiveCouponAbilityRspBO();
        this.initParam(abilityReqBO);
        if (null == abilityReqBO.getUsedState()) {
            abilityReqBO.setUsedState(UmcEnumConstant.CouponUsedState.NOT_USE.getCode());
        }
        UmcReceiveCouponBusiReqBO umcReceiveCouponBusiReqBO = new UmcReceiveCouponBusiReqBO();
        BeanUtils.copyProperties((Object)abilityReqBO, (Object)umcReceiveCouponBusiReqBO);
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getGetTime())) {
            umcReceiveCouponBusiReqBO.setGetTime(new Date());
        } else {
            umcReceiveCouponBusiReqBO.setGetTime(DateUtils.strToDateLong((String)abilityReqBO.getGetTime()));
        }
        umcReceiveCouponBusiReqBO.setExpTime(DateUtils.strToDateLong((String)abilityReqBO.getExpTime()));
        umcReceiveCouponBusiReqBO.setEffTime(DateUtils.strToDateLong((String)abilityReqBO.getEffTime()));
        if (StringUtils.isNotBlank((CharSequence)abilityReqBO.getCouponValue())) {
            exchange = new BigDecimal("10000");
            result = new BigDecimal(abilityReqBO.getCouponValue());
            Integer couponValue = result.multiply(exchange).intValue();
            umcReceiveCouponBusiReqBO.setCouponValue(couponValue);
        }
        if (StringUtils.isNotBlank((CharSequence)abilityReqBO.getCouponBalance())) {
            exchange = new BigDecimal("10000");
            result = new BigDecimal(abilityReqBO.getCouponBalance());
            Integer couponBalance = result.multiply(exchange).intValue();
            umcReceiveCouponBusiReqBO.setCouponBalance(couponBalance);
        } else {
            umcReceiveCouponBusiReqBO.setCouponBalance(umcReceiveCouponBusiReqBO.getCouponValue());
        }
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u4f1a\u5458\u4f18\u60e0\u5377\u9886\u53d6\u4e1a\u52a1\u670d\u52a1\u5165\u53c2\uff1a" + umcReceiveCouponBusiReqBO.toString());
        }
        UmcReceiveCouponBusiRspBO umcReceiveCouponBusiRspBO = this.umcReceiveCouponBusiService.receiveCoupon(umcReceiveCouponBusiReqBO);
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u4f1a\u5458\u4f18\u60e0\u5377\u9886\u53d6\u4e1a\u52a1\u670d\u52a1\u51fa\u53c2\uff1a" + umcReceiveCouponBusiRspBO.toString());
        }
        if (!"0000".equals(umcReceiveCouponBusiRspBO.getRespCode())) {
            throw new UmcBusinessException(umcReceiveCouponBusiRspBO.getRespCode(), umcReceiveCouponBusiRspBO.getRespDesc());
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u4f1a\u5458\u4e2d\u5fc3\u4f1a\u5458\u4f18\u60e0\u5377\u9886\u53d6\u670d\u52a1API\u6210\u529f\uff01");
        return rsp;
    }

    private void initParam(UmcReceiveCouponAbilityReqBO abilityReqBO) {
        if (null == abilityReqBO) {
            throw new UmcBusinessException("8000", "\u4f1a\u5458\u4e2d\u5fc3\u4f1a\u5458\u4f18\u60e0\u5377\u9886\u53d6\u670d\u52a1API\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == abilityReqBO.getMemId()) {
            throw new UmcBusinessException("8000", "\u4f1a\u5458\u4e2d\u5fc3\u4f1a\u5458\u4f18\u60e0\u5377\u9886\u53d6\u670d\u52a1API\u5165\u53c2\u3010memId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getCouponNo())) {
            throw new UmcBusinessException("8000", "\u4f1a\u5458\u4e2d\u5fc3\u4f1a\u5458\u4f18\u60e0\u5377\u9886\u53d6\u670d\u52a1API\u5165\u53c2\u3010couponNo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == abilityReqBO.getCouponType()) {
            throw new UmcBusinessException("8000", "\u4f1a\u5458\u4e2d\u5fc3\u4f1a\u5458\u4f18\u60e0\u5377\u9886\u53d6\u670d\u52a1API\u5165\u53c2\u3010couponType\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == abilityReqBO.getFmId()) {
            throw new UmcBusinessException("8000", "\u4f1a\u5458\u4e2d\u5fc3\u4f1a\u5458\u4f18\u60e0\u5377\u9886\u53d6\u670d\u52a1API\u5165\u53c2\u3010fmId\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getExpTime())) {
            throw new UmcBusinessException("8000", "\u4f1a\u5458\u4e2d\u5fc3\u4f1a\u5458\u4f18\u60e0\u5377\u9886\u53d6\u670d\u52a1API\u5165\u53c2\u3010expTime\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getEffTime())) {
            throw new UmcBusinessException("8000", "\u4f1a\u5458\u4e2d\u5fc3\u4f1a\u5458\u4f18\u60e0\u5377\u9886\u53d6\u670d\u52a1API\u5165\u53c2\u3010effTime\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

