/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.ability.impl;

import com.tydic.umc.ability.UmcSignAbilityService;
import com.tydic.umc.ability.bo.UmcSignAbilityReqBO;
import com.tydic.umc.ability.bo.UmcSignAbilityRspBO;
import com.tydic.umc.busi.UmcSignAddBusiService;
import com.tydic.umc.busi.bo.UmcSignAddBusiReqBO;
import com.tydic.umc.busi.bo.UmcSignAddBusiRspBO;
import com.tydic.umc.comb.UmcSignGiveIntegralCombService;
import com.tydic.umc.comb.bo.UmcSignGiveIntegralCombReqBO;
import com.tydic.umc.comb.bo.UmcSignGiveIntegralCombRspBO;
import com.tydic.umc.util.UmcBusinessException;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="service", interfaceClass=UmcSignAbilityService.class)
public class UmcSignAbilityServiceImpl
implements UmcSignAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UmcSignAbilityServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcSignAbilityServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private static final String ERROR_MSG = "\u8c03\u7528\u4f1a\u5458\u7b7e\u5230\u7ef4\u62a4\u670d\u52a1\u5931\u8d25\uff1a";
    private UmcSignAddBusiService umcSignAddBusiService;
    private UmcSignGiveIntegralCombService umcSignGiveIntegralCombService;
    private static final int NORMAL_SIGN_OPER = 1;
    private static final int SIGN_OBTAIN_INTEGRAL_OPER = 2;

    @Autowired
    public UmcSignAbilityServiceImpl(UmcSignAddBusiService umcSignAddBusiService, UmcSignGiveIntegralCombService umcSignGiveIntegralCombService) {
        this.umcSignAddBusiService = umcSignAddBusiService;
        this.umcSignGiveIntegralCombService = umcSignGiveIntegralCombService;
    }

    public UmcSignAbilityRspBO signOperAbility(UmcSignAbilityReqBO umcSignAbilityReqBO) {
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u6267\u884c\u4f1a\u5458\u4e2d\u5fc3\u4f1a\u5458\u7b7e\u5230\u7ef4\u62a4\u670d\u52a1\uff1a" + umcSignAbilityReqBO.toString());
        }
        UmcSignAbilityRspBO rspBO = new UmcSignAbilityRspBO();
        this.validationParams(umcSignAbilityReqBO);
        switch (umcSignAbilityReqBO.getOperType()) {
            case 1: {
                rspBO = this.normalSign(umcSignAbilityReqBO);
                break;
            }
            case 2: {
                rspBO = this.signObtainIntegral(umcSignAbilityReqBO);
                break;
            }
            default: {
                rspBO.setRespCode("4000");
                rspBO.setRespDesc("\u65e0\u6548\u7684\u64cd\u4f5c\u7c7b\u578b");
            }
        }
        return rspBO;
    }

    private void validationParams(UmcSignAbilityReqBO reqBO) {
        if (reqBO.getOperType() == null || reqBO.getOperType() == 0) {
            throw new UmcBusinessException("8000", "\u8c03\u7528\u4f1a\u5458\u7b7e\u5230\u7ef4\u62a4\u670d\u52a1\u5931\u8d25\uff1a\u64cd\u4f5c\u7c7b\u578b[operType]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u503c\u4e0d\u80fd\u4e3a0");
        }
        if (reqBO.getMemId() == null || reqBO.getMemId() == 0L) {
            throw new UmcBusinessException("8000", "\u8c03\u7528\u4f1a\u5458\u7b7e\u5230\u7ef4\u62a4\u670d\u52a1\u5931\u8d25\uff1a\u4f1a\u5458ID[memId]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getSignSystem() == null || reqBO.getSignSystem() == 0) {
            throw new UmcBusinessException("8000", "\u8c03\u7528\u4f1a\u5458\u7b7e\u5230\u7ef4\u62a4\u670d\u52a1\u5931\u8d25\uff1a\u7b7e\u5230\u7cfb\u7edf[signSystem]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private UmcSignAbilityRspBO normalSign(UmcSignAbilityReqBO umcSignAbilityReqBO) {
        UmcSignAbilityRspBO rspBO = new UmcSignAbilityRspBO();
        UmcSignAddBusiReqBO umcSignAddBusiReqBO = new UmcSignAddBusiReqBO();
        umcSignAddBusiReqBO.setMemId(umcSignAbilityReqBO.getMemId());
        umcSignAddBusiReqBO.setRecvIntegral(umcSignAbilityReqBO.getRecvIntegral());
        umcSignAddBusiReqBO.setSignSystem(umcSignAbilityReqBO.getSignSystem());
        umcSignAddBusiReqBO.setSignDesc(umcSignAbilityReqBO.getSignDesc());
        umcSignAddBusiReqBO.setSignPicRul(umcSignAbilityReqBO.getSignPicRul());
        UmcSignAddBusiRspBO umcSignAddBusiRspBO = this.umcSignAddBusiService.insertSign(umcSignAddBusiReqBO);
        rspBO.setRespCode(umcSignAddBusiRspBO.getRespCode());
        rspBO.setRespDesc(umcSignAddBusiRspBO.getRespDesc());
        return rspBO;
    }

    private UmcSignAbilityRspBO signObtainIntegral(UmcSignAbilityReqBO umcSignAbilityReqBO) {
        UmcSignAbilityRspBO rspBO = new UmcSignAbilityRspBO();
        UmcSignGiveIntegralCombReqBO umcSignGiveIntegralCombReqBO = new UmcSignGiveIntegralCombReqBO();
        umcSignGiveIntegralCombReqBO.setMemId(umcSignAbilityReqBO.getMemId());
        umcSignGiveIntegralCombReqBO.setRecvIntegral(umcSignAbilityReqBO.getRecvIntegral());
        umcSignGiveIntegralCombReqBO.setSignDesc(umcSignAbilityReqBO.getSignDesc());
        umcSignGiveIntegralCombReqBO.setSignPicRul(umcSignAbilityReqBO.getSignPicRul());
        umcSignGiveIntegralCombReqBO.setSignSystem(umcSignAbilityReqBO.getSignSystem());
        UmcSignGiveIntegralCombRspBO umcSignGiveIntegralCombRspBO = this.umcSignGiveIntegralCombService.addSignAndIntegral(umcSignGiveIntegralCombReqBO);
        rspBO.setRespCode(umcSignGiveIntegralCombRspBO.getRespCode());
        rspBO.setRespDesc(umcSignGiveIntegralCombRspBO.getRespDesc());
        return rspBO;
    }
}

