/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.ability.impl;

import com.tydic.umc.ability.UmcSignQueryAbilityService;
import com.tydic.umc.ability.bo.MemSignAbilityBO;
import com.tydic.umc.ability.bo.UmcSignQueryAbilityReqBO;
import com.tydic.umc.ability.bo.UmcSignQueryAbilityRspBO;
import com.tydic.umc.busi.UmcSignQueryBusiService;
import com.tydic.umc.busi.bo.MemSignBusiBO;
import com.tydic.umc.busi.bo.UmcSignQueryBusiReqBO;
import com.tydic.umc.busi.bo.UmcSignQueryBusiRspBO;
import com.tydic.umc.util.UmcBusinessException;
import java.util.ArrayList;
import java.util.List;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="service", interfaceClass=UmcSignQueryAbilityService.class)
public class UmcSignQueryAbilityServiceImpl
implements UmcSignQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UmcSignQueryAbilityServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcSignQueryAbilityServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private static final String ERROR_MSG = "\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u4f1a\u5458\u7b7e\u5230\u67e5\u8be2\u80fd\u529b\u670d\u52a1\u5931\u8d25\uff1a";
    private UmcSignQueryBusiService umcSignQueryBusiService;

    @Autowired
    public UmcSignQueryAbilityServiceImpl(UmcSignQueryBusiService umcSignQueryBusiService) {
        this.umcSignQueryBusiService = umcSignQueryBusiService;
    }

    public UmcSignQueryAbilityRspBO querySignAndIntegral(UmcSignQueryAbilityReqBO umcSignQueryAbilityReqBO) {
        UmcSignQueryAbilityRspBO rspBO = new UmcSignQueryAbilityRspBO();
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u67e5\u8be2\u7b7e\u5230\u8bb0\u5f55\u80fd\u529b\u670d\u52a1\u7684\u5165\u53c2\u4e3a\uff1a" + umcSignQueryAbilityReqBO.toString());
        }
        this.validationParams(umcSignQueryAbilityReqBO);
        UmcSignQueryBusiReqBO reqBO = new UmcSignQueryBusiReqBO();
        reqBO.setMemId(umcSignQueryAbilityReqBO.getMemId());
        reqBO.setStartDate(umcSignQueryAbilityReqBO.getStartDate());
        reqBO.setEndDate(umcSignQueryAbilityReqBO.getEndDate());
        reqBO.setSignSystem(umcSignQueryAbilityReqBO.getSignSystem());
        UmcSignQueryBusiRspBO umcSignQueryBusiRspBO = this.umcSignQueryBusiService.querySignAndIntegral(reqBO);
        ArrayList<MemSignAbilityBO> memSignAbilityBOS = new ArrayList<MemSignAbilityBO>();
        List memSignBusiBOS = umcSignQueryBusiRspBO.getMemSignBusiBOS();
        if (memSignBusiBOS != null && !memSignBusiBOS.isEmpty()) {
            for (MemSignBusiBO memSignBusiBO : memSignBusiBOS) {
                MemSignAbilityBO memSignAbilityBO = new MemSignAbilityBO();
                BeanUtils.copyProperties((Object)memSignBusiBO, (Object)memSignAbilityBO);
                memSignAbilityBOS.add(memSignAbilityBO);
            }
        }
        rspBO.setRespCode(umcSignQueryBusiRspBO.getRespCode());
        rspBO.setRespDesc(umcSignQueryBusiRspBO.getRespDesc());
        rspBO.setMemSignAbilityBOS(memSignAbilityBOS);
        return rspBO;
    }

    private void validationParams(UmcSignQueryAbilityReqBO umcSignQueryAbilityReqBO) {
        if (umcSignQueryAbilityReqBO.getMemId() == null || umcSignQueryAbilityReqBO.getMemId() == 0L) {
            throw new UmcBusinessException("8000", "\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u4f1a\u5458\u7b7e\u5230\u67e5\u8be2\u80fd\u529b\u670d\u52a1\u5931\u8d25\uff1a\u4f1a\u5458ID[memId]\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

