/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.ability.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.umc.ability.bo.UmcDistributionAreaBO;
import com.tydic.umc.ability.bo.UmcSupMemDetailQueryAbilityReqBO;
import com.tydic.umc.ability.bo.UmcSupMemDetailQueryAbilityRspBO;
import com.tydic.umc.ability.bo.UmcUserRoleBO;
import com.tydic.umc.ability.user.UmcSupMemDetailQueryAbilityService;
import com.tydic.umc.base.bo.UmcRspListBO;
import com.tydic.umc.busi.DictionaryBusiService;
import com.tydic.umc.busi.UmcMemUserManageBusiService;
import com.tydic.umc.busi.UmcSupMemManageBusiService;
import com.tydic.umc.busi.bo.MemUserBO;
import com.tydic.umc.busi.bo.UmcMemUserBusiReqBO;
import com.tydic.umc.busi.bo.UmcSupMemDetailQueryBusiReqBO;
import com.tydic.umc.busi.bo.UmcSupMemDetailQueryBusiRspBO;
import com.tydic.umc.common.UmcSupMemberInfoBO;
import com.tydic.umc.external.authority.bo.UmcAuthoritySelectOrgAlreadyRolesRspBO;
import com.tydic.umc.external.authority.bo.UmcAuthorityUserAuthReqBO;
import com.tydic.umc.external.authority.bo.UmcHasAndNotGrantRoleBO;
import com.tydic.umc.facde.AuthorityServiceHolder;
import com.tydic.umc.util.UmcBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(version="1.0.0", group="service", interfaceClass=UmcSupMemDetailQueryAbilityService.class)
public class UmcSupMemDetailQueryAbilityServiceImpl
implements UmcSupMemDetailQueryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UmcSupMemDetailQueryAbilityServiceImpl.class);
    @Autowired
    private UmcSupMemManageBusiService umcSupMemManageBusiService;
    @Autowired
    private UmcMemUserManageBusiService umcMemUserManageBusiService;
    @Autowired
    private DictionaryBusiService dictionaryBusiService;
    @Autowired
    private AuthorityServiceHolder authorityServiceHolder;
    private static final Integer ISBIDDING_Y = 1;
    private static final Integer ISPARITY_Y = 1;
    private static final Integer ISPOWER_Y = 1;

    public UmcSupMemDetailQueryAbilityRspBO querySupplierMemDetail(UmcSupMemDetailQueryAbilityReqBO abilityReqBO) {
        this.validParam(abilityReqBO);
        UmcSupMemDetailQueryBusiReqBO umcSupMemDetailQueryBusiReqBO = new UmcSupMemDetailQueryBusiReqBO();
        umcSupMemDetailQueryBusiReqBO.setMemId(abilityReqBO.getMemId());
        UmcSupMemDetailQueryBusiRspBO busiRspBO = this.umcSupMemManageBusiService.qrySupplierMemDetail(umcSupMemDetailQueryBusiReqBO);
        UmcSupMemDetailQueryAbilityRspBO result = new UmcSupMemDetailQueryAbilityRspBO();
        BeanUtils.copyProperties((Object)busiRspBO, (Object)result);
        if ("0000".equals(result.getRespCode()) && result.getUmcMemDetailInfoAbilityRspBO() != null) {
            this.changeToCN(result.getUmcMemDetailInfoAbilityRspBO());
            this.invokeAuthRolesService(result.getUmcMemDetailInfoAbilityRspBO());
        }
        return result;
    }

    private void invokeAuthRolesService(UmcSupMemberInfoBO rsp) {
        try {
            UmcAuthorityUserAuthReqBO umcAuthorityUserAuthReqBO = new UmcAuthorityUserAuthReqBO();
            umcAuthorityUserAuthReqBO.setPrarmUserId(rsp.getUserId());
            UmcAuthoritySelectOrgAlreadyRolesRspBO userRoleRsp = this.authorityServiceHolder.getUmcExternalAuthorityUserService().invokeSelectOrgAlreadyRoles(umcAuthorityUserAuthReqBO);
            if (!StringUtils.isEmpty((Object)userRoleRsp) && !CollectionUtils.isEmpty((Collection)userRoleRsp.getUmcHasGrantRoles())) {
                ArrayList<UmcUserRoleBO> umcUserRoleBOList = new ArrayList<UmcUserRoleBO>();
                for (UmcHasAndNotGrantRoleBO roleBO : userRoleRsp.getUmcHasGrantRoles()) {
                    UmcUserRoleBO umcUserRoleBO = new UmcUserRoleBO();
                    umcUserRoleBO.setRoleId(roleBO.getRoleId());
                    umcUserRoleBO.setRoleName(roleBO.getRoleName());
                    umcUserRoleBO.setCanSel(roleBO.getCanSel());
                    umcUserRoleBO.setOrgExtend(roleBO.getOrgExtend());
                    umcUserRoleBOList.add(umcUserRoleBO);
                }
                rsp.setUmcUserRoleBOList(umcUserRoleBOList);
            }
        }
        catch (Exception e) {
            throw new UmcBusinessException("8005", "\u8c03\u7528\u6743\u9650\u4e2d\u5fc3\u67e5\u8be2\u7528\u6237\u89d2\u8272\u5f02\u5e38");
        }
    }

    private void validParam(UmcSupMemDetailQueryAbilityReqBO abilityReqBO) {
        if (null == abilityReqBO.getMemId() && null == abilityReqBO.getUserId()) {
            throw new UmcBusinessException("4000", "\u3010memId\u3011\u548c\u3010userId\u3011\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        if (null == abilityReqBO.getMemId()) {
            UmcMemUserBusiReqBO umcMemUserBusiReqBO = new UmcMemUserBusiReqBO();
            if (null != abilityReqBO.getMemId()) {
                umcMemUserBusiReqBO.setMemId(abilityReqBO.getMemId());
            } else {
                umcMemUserBusiReqBO.setUsreIdWeb(abilityReqBO.getUserId());
            }
            UmcRspListBO busiRsp = this.umcMemUserManageBusiService.queryMemUserList(umcMemUserBusiReqBO);
            if (!CollectionUtils.isEmpty((Collection)busiRsp.getRows())) {
                abilityReqBO.setMemId(((MemUserBO)busiRsp.getRows().get(0)).getMemId());
                abilityReqBO.setUserId(((MemUserBO)busiRsp.getRows().get(0)).getUsreId());
            } else {
                throw new UmcBusinessException("8005", "\u4f1a\u5458\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
        }
    }

    private void changeToCN(UmcSupMemberInfoBO bo) {
        Map sexMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC", "MEM_SEX");
        Map stopStatusMap = this.dictionaryBusiService.queryBypCodeBackMap("UMC", "SUPPLIER_MEM_STOP_STATUS");
        if (null != bo.getSex()) {
            bo.setSexStr((String)sexMap.get(bo.getSex().toString()));
        }
        String powerRange = "";
        String distributionAreas = "";
        if (null != bo.getDistributionAreaId()) {
            List parseArray = JSON.parseArray((String)bo.getDistributionAreaId(), UmcDistributionAreaBO.class);
            if (!CollectionUtils.isEmpty((Collection)parseArray)) {
                for (UmcDistributionAreaBO bo1 : parseArray) {
                    distributionAreas = distributionAreas + "\uff0c" + bo1.getAreaName();
                }
                distributionAreas = distributionAreas.substring(1);
                bo.setDistributionAreas(distributionAreas);
            }
            bo.setUmcDistributionAreaBOs(parseArray);
        }
        if (bo.getIsBidding() != null && bo.getIsBidding().intValue() == ISBIDDING_Y.intValue()) {
            powerRange = powerRange + "\uff0c\u62db\u6295\u6807";
        }
        if (bo.getIsParity() != null && bo.getIsParity().intValue() == ISPARITY_Y.intValue()) {
            powerRange = powerRange + "\uff0c\u8be2\u6bd4\u4ef7";
        }
        if (bo.getIsPower() != null && bo.getIsPower().intValue() == ISPOWER_Y.intValue()) {
            powerRange = powerRange + "\uff0c\u7535\u529b\u4e13\u533a";
        }
        if (powerRange.length() > 0) {
            powerRange = powerRange.substring(1);
        }
        bo.setPowerRange(powerRange);
        bo.setStopStatusStr((String)stopStatusMap.get(bo.getStopStatus()));
    }
}

