/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.ability.impl;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.umc.ability.wopay.UmcWoPayAuthGrantCodeSaveAbilityService;
import com.tydic.umc.util.UmcBusinessException;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@Service(version="1.0.0", group="service", interfaceClass=UmcWoPayAuthGrantCodeSaveAbilityService.class)
public class UmcWoPayAuthGrantCodeSaveAbilityServiceImpl
implements UmcWoPayAuthGrantCodeSaveAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UmcWoPayAuthGrantCodeSaveAbilityServiceImpl.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcWoPayAuthGrantCodeSaveAbilityServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    @Autowired
    private CacheClient cacheService;
    @Value(value="${vfCodeExpTime}")
    private Integer vfCodeExpTime;

    public void saveAuthGrantCode(String code, String state) {
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("saveAuthGrantCode:code={}, state={}", (Object)code, (Object)state);
        }
        if (StringUtils.isEmpty((CharSequence)code)) {
            throw new UmcBusinessException("4000", "\u5165\u53c2\u3010code\u3011\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)state)) {
            throw new UmcBusinessException("4000", "\u5165\u53c2\u3010state\u3011\u4e3a\u7a7a");
        }
        if (null == this.cacheService.get("AUTH_GRANT_CODE_PREFIX_SET_" + state) || !state.equals(this.cacheService.get("AUTH_GRANT_CODE_PREFIX_SET_" + state).toString())) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("[saveAuthGrantCode]\u6388\u6743\u7801\u4fdd\u5b58\u4e1a\u52a1\u670d\u52a1\u5f02\u5e38\uff0c\u5165\u53c2[{}]\u4e0d\u5b58\u5728redis\u4e2d", (Object)state);
            }
            return;
        }
        this.cacheService.set("AUTH_GRANT_CODE_PREFIX_GET_" + state, (Object)code, this.vfCodeExpTime.intValue());
    }
}

