/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.atom.impl;

import com.tydic.umc.atom.UmcCalcIntegralAndGrowValueAtomService;
import com.tydic.umc.atom.UmcRuleCalculateAtomService;
import com.tydic.umc.atom.bo.UmcCalcIntegralAndGrowValueAtomReqBO;
import com.tydic.umc.atom.bo.UmcCalcIntegralAndGrowValueAtomRspBO;
import com.tydic.umc.atom.bo.UmcRuleCalculateAtomReqBO;
import com.tydic.umc.atom.bo.UmcRuleCalculateAtomRspBO;
import com.tydic.umc.dao.OperRuleMapper;
import com.tydic.umc.po.OperRulePO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcCalcIntegralAndGrowValueAtomService")
public class UmcCalcIntegralAndGrowValueAtomServiceImpl
implements UmcCalcIntegralAndGrowValueAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcCalcIntegralAndGrowValueAtomServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private OperRuleMapper operRuleMapper;
    private UmcRuleCalculateAtomService umcRuleCalculateAtomService;

    @Autowired
    public UmcCalcIntegralAndGrowValueAtomServiceImpl(OperRuleMapper operRuleMapper, UmcRuleCalculateAtomService umcRuleCalculateAtomService) {
        this.operRuleMapper = operRuleMapper;
        this.umcRuleCalculateAtomService = umcRuleCalculateAtomService;
    }

    @Override
    public UmcCalcIntegralAndGrowValueAtomRspBO calcIntegralAndGrowValue(UmcCalcIntegralAndGrowValueAtomReqBO reqBO) {
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u4f1a\u5458\u4e2d\u5fc3\u4e1a\u52a1\u79ef\u5206\u53ca\u6210\u957f\u503c\u8ba1\u7b97\u539f\u5b50\u670d\u52a1\u5165\u53c2\u4e3a\uff1a" + reqBO.toString());
        }
        UmcCalcIntegralAndGrowValueAtomRspBO rspBO = new UmcCalcIntegralAndGrowValueAtomRspBO();
        List<OperRulePO> operRulePOS = this.qryOperRule(reqBO);
        if (operRulePOS == null || operRulePOS.isEmpty()) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u672a\u67e5\u8be2\u5230\u4e1a\u52a1\u7f16\u7801[" + reqBO.getOperCode() + "]\u6240\u5bf9\u5e94\u7684\u89c4\u5219\u4fe1\u606f");
            }
            rspBO.setRespCode("1012");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u4e1a\u52a1\u7f16\u7801[" + reqBO.getOperCode() + "]\u6240\u5bf9\u5e94\u7684\u89c4\u5219\u4fe1\u606f");
            return rspBO;
        }
        Long totalTargetValue = 0L;
        for (OperRulePO operRulePO : operRulePOS) {
            UmcRuleCalculateAtomRspBO umcRuleCalculateAtomRspBO = this.ruleCalculate(operRulePO, reqBO);
            if ("1022".equals(umcRuleCalculateAtomRspBO.getRespCode())) continue;
            if (!"0000".equals(umcRuleCalculateAtomRspBO.getRespCode())) {
                rspBO.setRespCode(umcRuleCalculateAtomRspBO.getRespCode());
                rspBO.setRespDesc(umcRuleCalculateAtomRspBO.getRespDesc());
                return rspBO;
            }
            totalTargetValue = totalTargetValue + Long.valueOf(umcRuleCalculateAtomRspBO.getTargetValue());
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u83b7\u8d60\u79ef\u5206\u6216\u6210\u957f\u503c\u8ba1\u7b97\u6210\u529f");
        rspBO.setTargetValue(totalTargetValue + "");
        return rspBO;
    }

    private List<OperRulePO> qryOperRule(UmcCalcIntegralAndGrowValueAtomReqBO reqBO) {
        OperRulePO operRuleModel = new OperRulePO();
        operRuleModel.setOperCode(reqBO.getOperCode());
        operRuleModel.setRuleType(reqBO.getRuleType());
        return this.operRuleMapper.getListByCondition(operRuleModel);
    }

    private UmcRuleCalculateAtomRspBO ruleCalculate(OperRulePO operRulePO, UmcCalcIntegralAndGrowValueAtomReqBO reqBO) {
        UmcRuleCalculateAtomReqBO umcRuleCalculateAtomReqBO = new UmcRuleCalculateAtomReqBO();
        umcRuleCalculateAtomReqBO.setRuleId(operRulePO.getRuleId());
        umcRuleCalculateAtomReqBO.setRuleType(operRulePO.getRuleType());
        umcRuleCalculateAtomReqBO.setRuleParamsMap(reqBO.getRuleParamsMap());
        umcRuleCalculateAtomReqBO.setMemId(reqBO.getMemId());
        return this.umcRuleCalculateAtomService.ruleCalculate(umcRuleCalculateAtomReqBO);
    }
}

