/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.atom.impl;

import com.tydic.umc.atom.UmcEnterpriseOrgManageAtomService;
import com.tydic.umc.atom.bo.UmcQryOrgByDeliveryIdsAtomReqBO;
import com.tydic.umc.atom.bo.UmcQryOrgFullNameByOrgIdsAtomReqBO;
import com.tydic.umc.atom.bo.UmcQryOrgFullNameByOrgIdsAtomRspBO;
import com.tydic.umc.atom.bo.UmcQrySpecialOrgAtomReqBO;
import com.tydic.umc.atom.bo.UmcQryUpOrgAtomReqBO;
import com.tydic.umc.atom.bo.UmcQryUpOrgAtomRspBO;
import com.tydic.umc.base.bo.UmcRspListBO;
import com.tydic.umc.common.UmcEnterpriseOrgBO;
import com.tydic.umc.dao.EnterpriseOrgMapper;
import com.tydic.umc.po.EnterpriseOrgPO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UmcEnterpriseOrgManageAtomServiceImpl
implements UmcEnterpriseOrgManageAtomService {
    private static final Logger LOG = LoggerFactory.getLogger(UmcEnterpriseOrgManageAtomServiceImpl.class);
    @Autowired
    private EnterpriseOrgMapper enterpriseOrgMapper;

    @Override
    public UmcQryUpOrgAtomRspBO qryUpOrg(UmcQryUpOrgAtomReqBO atomReqBO) {
        UmcQryUpOrgAtomRspBO result = new UmcQryUpOrgAtomRspBO();
        if (atomReqBO == null || atomReqBO.getOrgId() == null || CollectionUtils.isEmpty(atomReqBO.getUpOrgType())) {
            result.setRespCode("8888");
            result.setRespDesc("\u5165\u53c2\u4e3a\u7a7a");
            return result;
        }
        Long orgParentId = atomReqBO.getOrgId();
        while (orgParentId != null) {
            EnterpriseOrgPO po = new EnterpriseOrgPO();
            po.setOrgId(orgParentId);
            po.setDelStatus("00");
            UmcEnterpriseOrgBO rspPO = this.enterpriseOrgMapper.getModelBy(po);
            if (null == rspPO) break;
            if (atomReqBO.getUpOrgType().contains(rspPO.getOrgType())) {
                UmcEnterpriseOrgBO bo = new UmcEnterpriseOrgBO();
                BeanUtils.copyProperties((Object)rspPO, (Object)bo);
                result.setUmcEnterpriseOrgBO(bo);
                break;
            }
            orgParentId = rspPO.getParentId();
        }
        result.setRespCode("0000");
        result.setRespDesc("\u67e5\u8be2\u6210\u529f");
        return result;
    }

    @Override
    public UmcRspListBO<UmcEnterpriseOrgBO> qryOrgByDeliveryIds(UmcQryOrgByDeliveryIdsAtomReqBO atomReqBO) {
        UmcRspListBO result = new UmcRspListBO();
        EnterpriseOrgPO enterpriseOrgPO = new EnterpriseOrgPO();
        enterpriseOrgPO.setDeliveryCenterIds(atomReqBO.getDeliveryIds());
        enterpriseOrgPO.setOrderBy("deep,createTime DESC");
        enterpriseOrgPO.setIsProfessionalOrgs(atomReqBO.getIsProfessionalOrgs());
        List<UmcEnterpriseOrgBO> daoList = this.enterpriseOrgMapper.getOrgByDeliveryIds(enterpriseOrgPO);
        result.setRows(daoList);
        result.setRespCode("0000");
        result.setRespDesc("\u67e5\u8be2\u6210\u529f");
        return result;
    }

    @Override
    public UmcRspListBO<UmcEnterpriseOrgBO> qrySpecialOrg(UmcQrySpecialOrgAtomReqBO atomReqBO) {
        EnterpriseOrgPO enterpriseOrgPO = new EnterpriseOrgPO();
        enterpriseOrgPO.setDelStatus("00");
        enterpriseOrgPO.setIsProfessionalOrg("0");
        ArrayList<String> orgType = new ArrayList<String>();
        orgType.add("02");
        orgType.add("01");
        orgType.add("00");
        enterpriseOrgPO.setOrgTypes(orgType);
        enterpriseOrgPO.setOrgId(atomReqBO.getOrgId());
        List<UmcEnterpriseOrgBO> daoList = this.enterpriseOrgMapper.getSpecialOrg(enterpriseOrgPO);
        UmcRspListBO result = new UmcRspListBO();
        result.setRespCode("0000");
        result.setRespDesc("\u67e5\u8be2\u6210\u529f");
        result.setRows(daoList);
        return result;
    }

    @Override
    public UmcQryOrgFullNameByOrgIdsAtomRspBO qryOrgFullNameByOrgIds(UmcQryOrgFullNameByOrgIdsAtomReqBO atomReqBO) {
        UmcQryOrgFullNameByOrgIdsAtomRspBO result = new UmcQryOrgFullNameByOrgIdsAtomRspBO();
        HashMap<Long, UmcEnterpriseOrgBO> orgIdAndOrgBOMap = new HashMap<Long, UmcEnterpriseOrgBO>();
        if (CollectionUtils.isEmpty(atomReqBO.getOrgIds())) {
            result.setRespCode("4000");
            result.setRespDesc("\u5165\u53c2\u4e3a\u7a7a");
            return result;
        }
        List<UmcEnterpriseOrgBO> enterpriseOrgBOs = this.enterpriseOrgMapper.getListByIds(atomReqBO.getOrgIds());
        if (CollectionUtils.isEmpty(enterpriseOrgBOs)) {
            result.setRespCode("4000");
            result.setRespDesc("\u5165\u53c2\u673a\u6784\u4e0d\u5b58\u5728");
            return result;
        }
        HashMap<Long, String> orgIdAndOrgTreeMap = new HashMap<Long, String>();
        HashSet<Long> orgSet = new HashSet<Long>();
        for (UmcEnterpriseOrgBO umcEnterpriseOrgBO : enterpriseOrgBOs) {
            String[] orgTrees;
            orgIdAndOrgBOMap.put(umcEnterpriseOrgBO.getOrgId(), umcEnterpriseOrgBO);
            orgIdAndOrgTreeMap.put(umcEnterpriseOrgBO.getOrgId(), "-" + umcEnterpriseOrgBO.getOrgTreePath());
            for (String orgId : orgTrees = umcEnterpriseOrgBO.getOrgTreePath().split("-")) {
                orgSet.add(Long.parseLong(orgId));
            }
        }
        ArrayList<Long> orgIds = new ArrayList<Long>();
        for (Long orgIdItem : orgSet) {
            orgIds.add(orgIdItem);
        }
        EnterpriseOrgPO enterpriseOrgPO = new EnterpriseOrgPO();
        enterpriseOrgPO.setOrgIds(orgIds);
        List<UmcEnterpriseOrgBO> umcEnterpriseOrgBOS = this.enterpriseOrgMapper.getListByOrgPO(enterpriseOrgPO);
        if (!CollectionUtils.isEmpty(umcEnterpriseOrgBOS)) {
            HashMap<String, String> orgIdAndOrgNameMap = new HashMap<String, String>();
            for (UmcEnterpriseOrgBO bo : umcEnterpriseOrgBOS) {
                orgIdAndOrgNameMap.put(bo.getOrgId().toString(), bo.getOrgName());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("\u673a\u6784\u540d\u79f0map:" + orgIdAndOrgNameMap);
            }
            for (Long sourceOrgId : orgIdAndOrgTreeMap.keySet()) {
                String orgTree = (String)orgIdAndOrgTreeMap.get(sourceOrgId);
                String[] orgTrees = orgTree.split("-");
                String orgTreeName = "";
                for (String orgIdStr : orgTrees) {
                    if (orgIdStr.equals("1")) continue;
                    orgTreeName = orgIdAndOrgNameMap.get(orgIdStr) != null ? orgTreeName + "-" + (String)orgIdAndOrgNameMap.get(orgIdStr) : orgTreeName + "-" + orgIdStr;
                }
                orgTreeName = !StringUtils.isBlank((CharSequence)orgTreeName) && orgTreeName.length() > 1 ? orgTreeName.substring(2, orgTreeName.length()) : "root";
                ((UmcEnterpriseOrgBO)orgIdAndOrgBOMap.get(sourceOrgId)).setOrgFullName(orgTreeName);
            }
        }
        result.setOrgIdAndOrgBOMap(orgIdAndOrgBOMap);
        result.setRespCode("0000");
        result.setRespDesc("\u67e5\u8be2\u6210\u529f");
        return result;
    }
}

