/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.atom.impl;

import com.tydic.umc.atom.UmcGrowValueAddAtomService;
import com.tydic.umc.atom.bo.UmcGrowValueAddAtomReqBO;
import com.tydic.umc.atom.bo.UmcGrowValueAddAtomRspBO;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.GrowChgLogMapper;
import com.tydic.umc.dao.MemberMapper;
import com.tydic.umc.po.GrowChgLogPO;
import com.tydic.umc.po.MemberPO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcGrowValueAddAtomService")
public class UmcGrowValueAddAtomServiceImpl
implements UmcGrowValueAddAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcGrowValueAddAtomServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private MemberMapper memberMapper;
    private GrowChgLogMapper growChgLogMapper;

    @Autowired
    public UmcGrowValueAddAtomServiceImpl(MemberMapper memberMapper, GrowChgLogMapper growChgLogMapper) {
        this.memberMapper = memberMapper;
        this.growChgLogMapper = growChgLogMapper;
    }

    @Override
    public UmcGrowValueAddAtomRspBO addGroupValue(UmcGrowValueAddAtomReqBO atomReqBO) {
        UmcGrowValueAddAtomRspBO rsp = new UmcGrowValueAddAtomRspBO();
        MemberPO memberPO = new MemberPO();
        memberPO.setMemId(atomReqBO.getMemId());
        MemberPO member = this.memberMapper.getModelByCondition(memberPO);
        if (null == member) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u4f1a\u5458\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
            }
            rsp.setRespCode("1007");
            rsp.setRespDesc("\u4f1a\u5458\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
            return rsp;
        }
        memberPO.setGrowValue(member.getGrowValue() + atomReqBO.getGrowValue());
        int isUpdate = this.memberMapper.updateByCondition(memberPO);
        if (isUpdate < 1) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u4f1a\u5458\u8868\u66f4\u65b0\u5931\u8d25!");
            }
            rsp.setRespCode("1007");
            rsp.setRespDesc("\u4f1a\u5458\u8868\u66f4\u65b0\u5931\u8d25!");
            return rsp;
        }
        GrowChgLogPO growChgLogPO = new GrowChgLogPO();
        BeanUtils.copyProperties((Object)atomReqBO, (Object)growChgLogPO);
        growChgLogPO.setOperTime(new Date());
        growChgLogPO.setAction(UmcEnumConstant.GrowChgLogAction.ADD_GROW_VALUE.getCode());
        int isInsert = this.growChgLogMapper.insert(growChgLogPO);
        if (isInsert < 1) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u63d2\u5165\u4f1a\u5458\u6d3b\u8dc3\u5ea6\u65e5\u5fd7\u8868\u5931\u8d25!");
            }
            rsp.setRespCode("1007");
            rsp.setRespDesc("\u63d2\u5165\u4f1a\u5458\u6d3b\u8dc3\u5ea6\u65e5\u5fd7\u8868\u5931\u8d25!");
            return rsp;
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u4f1a\u5458\u4e2d\u5fc3\u6210\u957f\u503c\u589e\u52a0\u539f\u5b50\u670d\u52a1\u6210\u529f\uff01");
        return rsp;
    }
}

