/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.umc.atom.impl;

import com.tydic.umc.atom.UmcGrowValueDeductAtomService;
import com.tydic.umc.atom.bo.UmcGrowValueDeductAtomReqBO;
import com.tydic.umc.atom.bo.UmcGrowValueDeductAtomRspBO;
import com.tydic.umc.constant.UmcEnumConstant;
import com.tydic.umc.dao.GrowChgLogMapper;
import com.tydic.umc.dao.MemberMapper;
import com.tydic.umc.po.GrowChgLogPO;
import com.tydic.umc.po.MemberPO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="umcGrowValueDeductAtomService")
public class UmcGrowValueDeductAtomServiceImpl
implements UmcGrowValueDeductAtomService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmcGrowValueDeductAtomServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private MemberMapper memberMapper;
    private GrowChgLogMapper growChgLogMapper;

    @Autowired
    public UmcGrowValueDeductAtomServiceImpl(MemberMapper memberMapper, GrowChgLogMapper growChgLogMapper) {
        this.memberMapper = memberMapper;
        this.growChgLogMapper = growChgLogMapper;
    }

    @Override
    public UmcGrowValueDeductAtomRspBO deductGroupValue(UmcGrowValueDeductAtomReqBO atomReqBO) {
        UmcGrowValueDeductAtomRspBO rsp = new UmcGrowValueDeductAtomRspBO();
        MemberPO memberPO = new MemberPO();
        memberPO.setMemId(atomReqBO.getMemId());
        MemberPO member = this.memberMapper.getModelByCondition(memberPO);
        if (null == member) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u4f1a\u5458\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            }
            rsp.setRespCode("1008");
            rsp.setRespDesc("\u4f1a\u5458\u8868\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a!");
            return rsp;
        }
        Long newGrowValue = member.getGrowValue() - atomReqBO.getGrowValue();
        if (newGrowValue < 0L) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u8be5\u4f1a\u5458Id\u3010" + atomReqBO.getMemId() + "\u3011\u6210\u957f\u503c\u53ea\u6709\uff1a" + member.getGrowValue() + "\uff0c\u4e0d\u80fd\u6ee1\u8db3\u672c\u6b21\u9700\u8981\u6263\u51cf\u7684\u3010" + atomReqBO.getGrowValue() + "\u6210\u957f\u503c\u3011\uff01\u91cd\u7f6e\u4e3a0");
            }
            newGrowValue = 0L;
        }
        memberPO.setGrowValue(newGrowValue);
        int isUpdate = this.memberMapper.updateByCondition(memberPO);
        if (isUpdate < 1) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u4f1a\u5458\u8868\u66f4\u65b0\u5931\u8d25");
            }
            rsp.setRespCode("1017");
            rsp.setRespDesc("\u4f1a\u5458\u8868\u66f4\u65b0\u5931\u8d25!");
            return rsp;
        }
        GrowChgLogPO growChgLogPO = new GrowChgLogPO();
        BeanUtils.copyProperties((Object)atomReqBO, (Object)growChgLogPO);
        if (newGrowValue == 0L) {
            growChgLogPO.setGrowValue(-member.getGrowValue().longValue());
        } else {
            growChgLogPO.setGrowValue(-atomReqBO.getGrowValue().longValue());
        }
        growChgLogPO.setOperTime(new Date());
        growChgLogPO.setAction(UmcEnumConstant.GrowChgLogAction.DEDUCT_GROW_VALUE.getCode());
        int isInsert = this.growChgLogMapper.insert(growChgLogPO);
        if (isInsert < 1) {
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u63d2\u5165\u4f1a\u5458\u6d3b\u8dc3\u5ea6\u65e5\u5fd7\u8868\u5931\u8d25!");
            }
            rsp.setRespCode("1018");
            rsp.setRespDesc("\u63d2\u5165\u4f1a\u5458\u6d3b\u8dc3\u5ea6\u65e5\u5fd7\u8868\u5931\u8d25!");
            return rsp;
        }
        rsp.setRespCode("0000");
        rsp.setRespDesc("\u4f1a\u5458\u4e2d\u5fc3\u6210\u957f\u503c\u6263\u51cf\u539f\u5b50\u670d\u52a1\u6210\u529f\uff01");
        return rsp;
    }
}

